/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.HashSet;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.PrintableStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class TeletexTerminalIdentifierSyntaxImpl
extends AbstractSyntaxImpl {
    private static final HashSet<String> ALLOWED_TTX_PARAMETERS = new HashSet(5);

    TeletexTerminalIdentifierSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.2";
    }

    @Override
    public String getName() {
        return "TeletexTerminalIdentifier";
    }

    @Override
    public String getOrderingMatchingRule() {
        return "2.5.13.3";
    }

    @Override
    public String getSubstringMatchingRule() {
        return "2.5.13.4";
    }

    @Override
    public boolean isHumanReadable() {
        return false;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String paramName;
        int colonPos;
        String paramStr;
        int pos;
        String valueString = value.toString();
        int valueLength = valueString.length();
        if (valueLength == 0) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELETEXID_EMPTY.get());
            return false;
        }
        char c = valueString.charAt(0);
        if (!PrintableStringSyntaxImpl.isPrintableCharacter(c)) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELETEXID_NOT_PRINTABLE.get(valueString, String.valueOf(c), 0));
            return false;
        }
        for (pos = 1; pos < valueLength; ++pos) {
            c = valueString.charAt(pos);
            if (c == '$') {
                ++pos;
                break;
            }
            if (PrintableStringSyntaxImpl.isPrintableCharacter(c)) continue;
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELETEXID_NOT_PRINTABLE.get(valueString, Character.valueOf(c), pos));
        }
        if (pos >= valueLength) {
            if (c == '$') {
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELETEXID_END_WITH_DOLLAR.get(valueString));
                return false;
            }
            return true;
        }
        int paramStartPos = pos;
        boolean escaped = false;
        while (pos < valueLength) {
            if (escaped) {
                ++pos;
                continue;
            }
            if ((c = valueString.charAt(pos++)) == '\\') {
                escaped = true;
                continue;
            }
            if (c != '$') continue;
            paramStr = valueString.substring(paramStartPos, pos);
            colonPos = paramStr.indexOf(58);
            if (colonPos < 0) {
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELETEXID_PARAM_NO_COLON.get(valueString));
                return false;
            }
            paramName = paramStr.substring(0, colonPos);
            if (!ALLOWED_TTX_PARAMETERS.contains(paramName)) {
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELETEXID_ILLEGAL_PARAMETER.get(valueString, paramName));
                return false;
            }
            paramStartPos = pos;
        }
        paramStr = valueString.substring(paramStartPos);
        colonPos = paramStr.indexOf(58);
        if (colonPos < 0) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELETEXID_PARAM_NO_COLON.get(valueString));
            return false;
        }
        paramName = paramStr.substring(0, colonPos);
        if (!ALLOWED_TTX_PARAMETERS.contains(paramName)) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELETEXID_ILLEGAL_PARAMETER.get(valueString, paramName));
            return false;
        }
        return true;
    }

    static {
        ALLOWED_TTX_PARAMETERS.add("graphic");
        ALLOWED_TTX_PARAMETERS.add("control");
        ALLOWED_TTX_PARAMETERS.add("misc");
        ALLOWED_TTX_PARAMETERS.add("page");
        ALLOWED_TTX_PARAMETERS.add("private");
    }
}

