/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.schema.AbstractSchemaElement;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.AttributeUsage;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaUtils;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

public final class ObjectClass
extends AbstractSchemaElement {
    private final String oid;
    private final List<String> names;
    private final boolean isObsolete;
    private final Set<String> superiorClassOids;
    private final ObjectClassType objectClassType;
    private final Set<String> requiredAttributeOids;
    private final Set<String> optionalAttributeOids;
    private Set<ObjectClass> superiorClasses = Collections.emptySet();
    private Set<AttributeType> declaredRequiredAttributes = Collections.emptySet();
    private Set<AttributeType> requiredAttributes = Collections.emptySet();
    private Set<AttributeType> declaredOptionalAttributes = Collections.emptySet();
    private Set<AttributeType> optionalAttributes = Collections.emptySet();
    private boolean needsValidating = true;
    private boolean isValid;
    private boolean isPlaceHolder;
    private final boolean isExtensibleObject;

    static ObjectClass newExtensibleObjectObjectClass(String description, Map<String, List<String>> extraProperties, SchemaBuilder builder) {
        return new ObjectClass(((Builder)new Builder("1.3.6.1.4.1.1466.101.120.111", builder).description(description).extraProperties((Map)extraProperties)).names("extensibleObject").superiorObjectClasses("top").type(ObjectClassType.AUXILIARY));
    }

    static ObjectClass newPlaceHolder(String name) {
        return new ObjectClass(name);
    }

    private ObjectClass(Builder builder) {
        super(builder);
        if (builder.oid == null || builder.oid.isEmpty()) {
            throw new IllegalArgumentException("An OID must be specified.");
        }
        this.oid = builder.oid;
        this.names = SchemaUtils.unmodifiableCopyOfList(builder.names);
        this.isObsolete = builder.isObsolete;
        this.superiorClassOids = SchemaUtils.unmodifiableCopyOfSet(builder.superiorClasses);
        this.objectClassType = builder.type;
        this.requiredAttributeOids = SchemaUtils.unmodifiableCopyOfSet(builder.requiredAttributes);
        this.optionalAttributeOids = SchemaUtils.unmodifiableCopyOfSet(builder.optionalAttributes);
        this.isExtensibleObject = this.oid.equals("1.3.6.1.4.1.1466.101.120.111");
        this.isPlaceHolder = false;
    }

    private ObjectClass(String name) {
        this.oid = ObjectClass.toOid(name);
        this.names = Collections.singletonList(name);
        this.isObsolete = false;
        this.superiorClassOids = Collections.singleton("top");
        this.objectClassType = ObjectClassType.ABSTRACT;
        this.requiredAttributeOids = Collections.emptySet();
        this.optionalAttributeOids = Collections.emptySet();
        this.isExtensibleObject = this.oid.equals("1.3.6.1.4.1.1466.101.120.111");
        this.isPlaceHolder = true;
    }

    private static String toOid(String name) {
        StringBuilder builder = new StringBuilder(name.length() + 4);
        StaticUtils.toLowerCase(name, builder);
        builder.append("-oid");
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ObjectClass) {
            ObjectClass other = (ObjectClass)o;
            return this.oid.equals(other.oid);
        }
        return false;
    }

    public Set<AttributeType> getDeclaredOptionalAttributes() {
        return this.declaredOptionalAttributes;
    }

    public Set<AttributeType> getDeclaredRequiredAttributes() {
        return this.declaredRequiredAttributes;
    }

    public String getNameOrOid() {
        if (this.names.isEmpty()) {
            return this.oid;
        }
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public ObjectClassType getObjectClassType() {
        return this.objectClassType != null ? this.objectClassType : ObjectClassType.STRUCTURAL;
    }

    public String getOid() {
        return this.oid;
    }

    public Set<AttributeType> getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public Set<AttributeType> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public Set<ObjectClass> getSuperiorClasses() {
        return this.superiorClasses;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    public boolean hasName(String name) {
        for (String n : this.names) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameOrOid(String value) {
        return this.hasName(value) || this.getOid().equals(value);
    }

    public boolean isDescendantOf(ObjectClass objectClass) {
        for (ObjectClass sup : this.superiorClasses) {
            if (!sup.equals(objectClass) && !sup.isDescendantOf(objectClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isExtensible() {
        return this.isExtensibleObject;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    @Deprecated
    public boolean isPlaceHolder() {
        return this.isPlaceHolder;
    }

    public boolean isOptional(AttributeType attributeType) {
        return this.isExtensibleObject || this.optionalAttributes.contains(attributeType);
    }

    public boolean isRequired(AttributeType attributeType) {
        return this.requiredAttributes.contains(attributeType);
    }

    public boolean isRequiredOrOptional(AttributeType attributeType) {
        return this.isRequired(attributeType) || this.isOptional(attributeType);
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        String firstName;
        Iterator<String> iterator;
        buffer.append(this.oid);
        if (!this.names.isEmpty()) {
            iterator = this.names.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append(iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        this.appendDescription(buffer);
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        if (!this.superiorClassOids.isEmpty()) {
            iterator = this.superiorClassOids.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" SUP ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" SUP ");
                buffer.append(firstName);
            }
        }
        if (this.objectClassType != null) {
            buffer.append(" ");
            buffer.append((Object)this.objectClassType);
        }
        if (!this.requiredAttributeOids.isEmpty()) {
            iterator = this.requiredAttributeOids.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" MUST ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MUST ");
                buffer.append(firstName);
            }
        }
        if (!this.isExtensible() && !this.optionalAttributeOids.isEmpty()) {
            iterator = this.optionalAttributeOids.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" MAY ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MAY ");
                buffer.append(firstName);
            }
        }
    }

    boolean validate(Schema schema, List<ObjectClass> invalidSchemaElements, List<LocalizableMessage> warnings) {
        LocalizableMessage message;
        boolean derivesTop;
        if (!this.needsValidating) {
            return this.isValid;
        }
        this.needsValidating = false;
        boolean bl = derivesTop = this.getObjectClassType() != ObjectClassType.STRUCTURAL;
        if (!this.superiorClassOids.isEmpty()) {
            this.superiorClasses = new HashSet<ObjectClass>(this.superiorClassOids.size());
            for (String superClassOid : this.superiorClassOids) {
                Set<AttributeType> supOptionalAttrs;
                LocalizableMessage message2;
                ObjectClass superiorClass;
                try {
                    superiorClass = schema.getObjectClass(superClassOid);
                }
                catch (UnknownSchemaElementException e) {
                    message = CoreMessages.WARN_ATTR_SYNTAX_OBJECTCLASS_UNKNOWN_SUPERIOR_CLASS1.get(this.getNameOrOid(), superClassOid);
                    this.failValidation(invalidSchemaElements, warnings, message);
                    return false;
                }
                if (!this.isObsolete() && superiorClass.isObsolete()) {
                    warnings.add(CoreMessages.WARN_OBJECTCLASS_HAS_OBSOLETE_SUPERIOR_CLASS.get(this.getNameOrOid(), superClassOid));
                }
                ObjectClassType superiorType = superiorClass.getObjectClassType();
                ObjectClassType type = this.getObjectClassType();
                switch (type) {
                    case ABSTRACT: {
                        if (superiorType == ObjectClassType.ABSTRACT) break;
                        message2 = CoreMessages.WARN_ATTR_SYNTAX_OBJECTCLASS_INVALID_SUPERIOR_TYPE1.get(this.getNameOrOid(), type.toString(), superiorType.toString(), superiorClass.getNameOrOid());
                        this.failValidation(invalidSchemaElements, warnings, message2);
                        return false;
                    }
                    case AUXILIARY: {
                        if (superiorType == ObjectClassType.ABSTRACT || superiorType == ObjectClassType.AUXILIARY) break;
                        message2 = CoreMessages.WARN_ATTR_SYNTAX_OBJECTCLASS_INVALID_SUPERIOR_TYPE1.get(this.getNameOrOid(), type.toString(), superiorType.toString(), superiorClass.getNameOrOid());
                        this.failValidation(invalidSchemaElements, warnings, message2);
                        return false;
                    }
                    case STRUCTURAL: {
                        if (superiorType == ObjectClassType.ABSTRACT || superiorType == ObjectClassType.STRUCTURAL) break;
                        message2 = CoreMessages.WARN_ATTR_SYNTAX_OBJECTCLASS_INVALID_SUPERIOR_TYPE1.get(this.getNameOrOid(), type.toString(), superiorType.toString(), superiorClass.getNameOrOid());
                        this.failValidation(invalidSchemaElements, warnings, message2);
                        return false;
                    }
                }
                if (!derivesTop && superiorType == ObjectClassType.STRUCTURAL) {
                    derivesTop = true;
                }
                if (!superiorClass.validate(schema, invalidSchemaElements, warnings)) {
                    message2 = CoreMessages.WARN_ATTR_SYNTAX_OBJECTCLASS_INVALID_SUPERIOR_CLASS.get(this.getNameOrOid(), superClassOid);
                    this.failValidation(invalidSchemaElements, warnings, message2);
                    return false;
                }
                Set<AttributeType> supRequiredAttrs = superiorClass.getRequiredAttributes();
                if (!supRequiredAttrs.isEmpty()) {
                    if (this.requiredAttributes == Collections.EMPTY_SET) {
                        this.requiredAttributes = new HashSet<AttributeType>(supRequiredAttrs);
                    } else {
                        this.requiredAttributes.addAll(supRequiredAttrs);
                    }
                }
                if (!(supOptionalAttrs = superiorClass.getOptionalAttributes()).isEmpty()) {
                    if (this.optionalAttributes == Collections.EMPTY_SET) {
                        this.optionalAttributes = new HashSet<AttributeType>(supOptionalAttrs);
                    } else {
                        this.optionalAttributes.addAll(supOptionalAttrs);
                    }
                }
                this.superiorClasses.add(superiorClass);
            }
        } else if (this.superiorClasses.isEmpty() && this.getObjectClassType() == ObjectClassType.STRUCTURAL) {
            this.superiorClasses = new HashSet<ObjectClass>(1);
            this.superiorClasses.add(schema.getObjectClass("2.5.6.0"));
            derivesTop = true;
        }
        if (!derivesTop) {
            derivesTop = this.isDescendantOf(schema.getObjectClass("2.5.6.0"));
        }
        if (!derivesTop) {
            LocalizableMessage message3 = CoreMessages.WARN_ATTR_SYNTAX_OBJECTCLASS_STRUCTURAL_SUPERIOR_NOT_TOP1.get(this.getNameOrOid());
            this.failValidation(invalidSchemaElements, warnings, message3);
            return false;
        }
        if (this.isExtensible()) {
            Collection<AttributeType> attributeTypes = schema.getAttributeTypes();
            this.declaredOptionalAttributes = new HashSet<AttributeType>(attributeTypes.size());
            for (AttributeType attributeType : attributeTypes) {
                if (attributeType.getUsage() != AttributeUsage.USER_APPLICATIONS || this.requiredAttributes.contains(attributeType)) continue;
                this.declaredOptionalAttributes.add(attributeType);
            }
            this.optionalAttributes = this.declaredOptionalAttributes;
        } else {
            AttributeType attributeType;
            if (!this.requiredAttributeOids.isEmpty()) {
                this.declaredRequiredAttributes = new HashSet<AttributeType>(this.requiredAttributeOids.size());
                for (String requiredAttribute : this.requiredAttributeOids) {
                    try {
                        attributeType = schema.getAttributeType(requiredAttribute);
                    }
                    catch (UnknownSchemaElementException e) {
                        message = CoreMessages.WARN_ATTR_SYNTAX_OBJECTCLASS_UNKNOWN_REQUIRED_ATTR1.get(this.getNameOrOid(), requiredAttribute);
                        this.failValidation(invalidSchemaElements, warnings, message);
                        return false;
                    }
                    if (!this.isObsolete() && attributeType.isObsolete()) {
                        warnings.add(CoreMessages.WARN_OBJECTCLASS_HAS_OBSOLETE_REQUIRED_ATTR.get(this.getNameOrOid(), requiredAttribute));
                    }
                    this.declaredRequiredAttributes.add(attributeType);
                }
                if (this.requiredAttributes == Collections.EMPTY_SET) {
                    this.requiredAttributes = this.declaredRequiredAttributes;
                } else {
                    this.requiredAttributes.addAll(this.declaredRequiredAttributes);
                }
            }
            if (!this.optionalAttributeOids.isEmpty()) {
                this.declaredOptionalAttributes = new HashSet<AttributeType>(this.optionalAttributeOids.size());
                for (String optionalAttribute : this.optionalAttributeOids) {
                    try {
                        attributeType = schema.getAttributeType(optionalAttribute);
                    }
                    catch (UnknownSchemaElementException e) {
                        message = CoreMessages.WARN_ATTR_SYNTAX_OBJECTCLASS_UNKNOWN_OPTIONAL_ATTR1.get(this.getNameOrOid(), optionalAttribute);
                        this.failValidation(invalidSchemaElements, warnings, message);
                        return false;
                    }
                    if (!this.isObsolete() && attributeType.isObsolete()) {
                        warnings.add(CoreMessages.WARN_OBJECTCLASS_HAS_OBSOLETE_OPTIONAL_ATTR.get(this.getNameOrOid(), optionalAttribute));
                    }
                    this.declaredOptionalAttributes.add(attributeType);
                }
                if (this.optionalAttributes == Collections.EMPTY_SET) {
                    this.optionalAttributes = this.declaredOptionalAttributes;
                } else {
                    this.optionalAttributes.addAll(this.declaredOptionalAttributes);
                }
            }
        }
        this.declaredOptionalAttributes = Collections.unmodifiableSet(this.declaredOptionalAttributes);
        this.declaredRequiredAttributes = Collections.unmodifiableSet(this.declaredRequiredAttributes);
        this.optionalAttributes = Collections.unmodifiableSet(this.optionalAttributes);
        this.requiredAttributes = Collections.unmodifiableSet(this.requiredAttributes);
        this.superiorClasses = Collections.unmodifiableSet(this.superiorClasses);
        this.isValid = true;
        return true;
    }

    private void failValidation(List<ObjectClass> invalidSchemaElements, List<LocalizableMessage> warnings, LocalizableMessage message) {
        invalidSchemaElements.add(this);
        warnings.add(CoreMessages.ERR_OC_VALIDATION_FAIL.get(this.toString(), message));
    }

    public static final class Builder
    extends AbstractSchemaElement.SchemaElementBuilder<Builder> {
        private boolean isObsolete;
        private final List<String> names = new LinkedList<String>();
        private String oid;
        private final Set<String> optionalAttributes = new LinkedHashSet<String>();
        private final Set<String> requiredAttributes = new LinkedHashSet<String>();
        private final Set<String> superiorClasses = new LinkedHashSet<String>();
        private ObjectClassType type;

        Builder(ObjectClass oc, SchemaBuilder builder) {
            super(builder, oc);
            this.oid = oc.oid;
            this.names.addAll(oc.names);
            this.isObsolete = oc.isObsolete;
            this.type = oc.objectClassType;
            this.superiorClasses.addAll(oc.superiorClassOids);
            this.requiredAttributes.addAll(oc.requiredAttributeOids);
            if (!oc.isExtensible()) {
                this.optionalAttributes.addAll(oc.optionalAttributeOids);
            }
        }

        Builder(String oid, SchemaBuilder builder) {
            super(builder);
            this.oid = oid;
        }

        public SchemaBuilder addToSchema() {
            return this.getSchemaBuilder().addObjectClass(new ObjectClass(this), false);
        }

        public SchemaBuilder addToSchemaOverwrite() {
            return this.getSchemaBuilder().addObjectClass(new ObjectClass(this), true);
        }

        SchemaBuilder addToSchema(boolean overwrite) {
            return overwrite ? this.addToSchemaOverwrite() : this.addToSchema();
        }

        @Override
        public Builder description(String description) {
            return (Builder)this.description0(description);
        }

        @Override
        public Builder extraProperties(Map<String, List<String>> extraProperties) {
            return (Builder)this.extraProperties0(extraProperties);
        }

        @Override
        public Builder extraProperties(String extensionName, String ... extensionValues) {
            return (Builder)this.extraProperties0(extensionName, extensionValues);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public Builder names(Collection<String> names) {
            this.names.addAll(names);
            return this;
        }

        public Builder names(String ... names) {
            return this.names(Arrays.asList(names));
        }

        public Builder obsolete(boolean isObsolete) {
            this.isObsolete = isObsolete;
            return this;
        }

        public Builder oid(String oid) {
            this.oid = oid;
            return this;
        }

        public Builder optionalAttributes(Collection<String> attributeNamesOrOids) {
            this.optionalAttributes.addAll(attributeNamesOrOids);
            return this;
        }

        public Builder optionalAttributes(String ... attributeNamesOrOids) {
            this.optionalAttributes.addAll(Arrays.asList(attributeNamesOrOids));
            return this;
        }

        @Override
        public Builder removeAllExtraProperties() {
            return (Builder)this.removeAllExtraProperties0();
        }

        @Override
        public Builder removeExtraProperty(String extensionName, String ... extensionValues) {
            return (Builder)this.removeExtraProperty0(extensionName, extensionValues);
        }

        public Builder removeAllNames() {
            this.names.clear();
            return this;
        }

        public Builder removeAllOptionalAttributes() {
            this.optionalAttributes.clear();
            return this;
        }

        public Builder removeAllRequiredAttributes() {
            this.requiredAttributes.clear();
            return this;
        }

        public Builder removeAllSuperiorObjectClass() {
            this.superiorClasses.clear();
            return this;
        }

        public Builder removeName(String name) {
            this.names.remove(name);
            return this;
        }

        public Builder removeOptionalAttribute(String attributeNameOrOid) {
            this.optionalAttributes.remove(attributeNameOrOid);
            return this;
        }

        public Builder removeRequiredAttribute(String attributeNameOrOid) {
            this.requiredAttributes.remove(attributeNameOrOid);
            return this;
        }

        public Builder removeSuperiorObjectClass(String objectClassNameOrOid) {
            this.superiorClasses.remove(objectClassNameOrOid);
            return this;
        }

        public Builder requiredAttributes(Collection<String> attributeNamesOrOids) {
            this.requiredAttributes.addAll(attributeNamesOrOids);
            return this;
        }

        public Builder requiredAttributes(String ... attributeNamesOrOids) {
            this.requiredAttributes.addAll(Arrays.asList(attributeNamesOrOids));
            return this;
        }

        public Builder superiorObjectClasses(Collection<String> objectClassNamesOrOids) {
            this.superiorClasses.addAll(objectClassNamesOrOids);
            return this;
        }

        public Builder superiorObjectClasses(String ... objectClassNamesOrOids) {
            this.superiorClasses.addAll(Arrays.asList(objectClassNamesOrOids));
            return this;
        }

        public Builder type(ObjectClassType type) {
            this.type = type;
            return this;
        }
    }
}

