/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.forgerock.api.ApiValidationException;
import org.forgerock.api.util.ValidationUtil;

@JsonDeserialize(builder=Builder.class)
public final class Reference {
    private final String value;

    private Reference(Builder builder) {
        this.value = builder.value;
        if (ValidationUtil.isEmpty(this.value)) {
            throw new ApiValidationException("Reference-value is required");
        }
        if (ValidationUtil.containsWhitespace(this.value)) {
            throw new ApiValidationException("Reference-value may not contain whitespace");
        }
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reference reference = (Reference)o;
        return Objects.equals(this.value, reference.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public static Builder reference() {
        return new Builder();
    }

    public static final class Builder {
        private String value;

        private Builder() {
        }

        @JsonCreator
        private Builder(String value) {
            this.value = value;
        }

        @JsonCreator
        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Reference build() {
            return new Reference(this);
        }
    }
}

