/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers;

import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriberPad4;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.QueueDrain;
import io.reactivex.internal.util.QueueDrainHelper;
import org.reactivestreams.Subscriber;

public abstract class QueueDrainSubscriber<T, U, V>
extends QueueDrainSubscriberPad4
implements Subscriber<T>,
QueueDrain<U, V> {
    protected final Subscriber<? super V> actual;
    protected final SimplePlainQueue<U> queue;
    protected volatile boolean cancelled;
    protected volatile boolean done;
    protected Throwable error;

    public QueueDrainSubscriber(Subscriber<? super V> actual, SimplePlainQueue<U> queue) {
        this.actual = actual;
        this.queue = queue;
    }

    @Override
    public final boolean cancelled() {
        return this.cancelled;
    }

    @Override
    public final boolean done() {
        return this.done;
    }

    @Override
    public final boolean enter() {
        return this.wip.getAndIncrement() == 0;
    }

    public final boolean fastEnter() {
        return this.wip.get() == 0 && this.wip.compareAndSet(0, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void fastPathEmitMax(U value, boolean delayError, Disposable dispose) {
        Subscriber<V> s = this.actual;
        SimplePlainQueue<U> q = this.queue;
        if (this.wip.get() == 0 && this.wip.compareAndSet(0, 1)) {
            long r = this.requested.get();
            if (r == 0L) {
                dispose.dispose();
                s.onError(new MissingBackpressureException("Could not emit buffer due to lack of requests"));
                return;
            }
            if (this.accept((Subscriber<? super V>)s, value) && r != Long.MAX_VALUE) {
                this.produced(1L);
            }
            if (this.leave(-1) == 0) {
                return;
            }
        } else {
            q.offer(value);
            if (!this.enter()) {
                return;
            }
        }
        QueueDrainHelper.drainMaxLoop(q, s, delayError, dispose, this);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void fastPathOrderedEmitMax(U value, boolean delayError, Disposable dispose) {
        Subscriber<V> s = this.actual;
        SimplePlainQueue<U> q = this.queue;
        if (this.wip.get() == 0 && this.wip.compareAndSet(0, 1)) {
            long r = this.requested.get();
            if (r == 0L) {
                this.cancelled = true;
                dispose.dispose();
                s.onError(new MissingBackpressureException("Could not emit buffer due to lack of requests"));
                return;
            }
            if (q.isEmpty()) {
                if (this.accept((Subscriber<? super V>)s, value) && r != Long.MAX_VALUE) {
                    this.produced(1L);
                }
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                q.offer(value);
            }
        } else {
            q.offer(value);
            if (!this.enter()) {
                return;
            }
        }
        QueueDrainHelper.drainMaxLoop(q, s, delayError, dispose, this);
    }

    @Override
    public boolean accept(Subscriber<? super V> a, U v) {
        return false;
    }

    @Override
    public final Throwable error() {
        return this.error;
    }

    @Override
    public final int leave(int m) {
        return this.wip.addAndGet(m);
    }

    @Override
    public final long requested() {
        return this.requested.get();
    }

    @Override
    public final long produced(long n) {
        return this.requested.addAndGet(-n);
    }

    public final void requested(long n) {
        if (SubscriptionHelper.validate(n)) {
            BackpressureHelper.add(this.requested, n);
        }
    }

    public void drain(boolean delayError) {
        if (this.enter()) {
            QueueDrainHelper.drainLoop(this.queue, this.actual, delayError, this);
        }
    }
}

