/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.CliMessages;
import org.forgerock.i18n.LocalizableMessageBuilder;

public final class IntegerArgument
extends Argument {
    private final int lowerBound;
    private final int upperBound;

    public static Builder builder(String name) {
        return new Builder(name);
    }

    private IntegerArgument(Builder builder, int lowerBound, int upperBound) {
        super(builder);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException(CliMessages.ERR_INTARG_LOWER_BOUND_ABOVE_UPPER_BOUND.get(builder.longIdentifier, lowerBound, upperBound).toString());
        }
    }

    @Override
    public boolean valueIsAcceptable(String valueString, LocalizableMessageBuilder invalidReason) {
        try {
            int intValue = Integer.parseInt(valueString);
            if (intValue < this.lowerBound) {
                invalidReason.append(CliMessages.ERR_INTARG_VALUE_BELOW_LOWER_BOUND.get(this.longIdentifier, intValue, this.lowerBound));
                return false;
            }
            if (intValue > this.upperBound) {
                invalidReason.append(CliMessages.ERR_INTARG_VALUE_ABOVE_UPPER_BOUND.get(this.longIdentifier, intValue, this.upperBound));
                return false;
            }
            return true;
        }
        catch (NumberFormatException e) {
            invalidReason.append(CliMessages.ERR_ARG_CANNOT_DECODE_AS_INT.get(valueString, this.longIdentifier));
            return false;
        }
    }

    public static final class Builder
    extends Argument.ArgumentBuilder<Builder, Integer, IntegerArgument> {
        private int lowerBound = Integer.MIN_VALUE;
        private int upperBound = Integer.MAX_VALUE;

        private Builder(String name) {
            super(name);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public Builder lowerBound(int lowerBound) {
            this.lowerBound = lowerBound;
            return this.getThis();
        }

        public Builder range(int lowerBound, int upperBound) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            return this.getThis();
        }

        @Override
        public IntegerArgument buildArgument() {
            return new IntegerArgument(this, this.lowerBound, this.upperBound);
        }
    }
}

