/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.query;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.util.Utils;
import org.forgerock.util.query.QueryFilter;
import org.forgerock.util.query.QueryFilterVisitor;

public final class JsonValueFilterVisitor
implements QueryFilterVisitor<Boolean, JsonValue, JsonPointer> {
    private static final QueryFilterVisitor<Boolean, JsonValue, JsonPointer> INSTANCE = new JsonValueFilterVisitor();

    public static QueryFilterVisitor<Boolean, JsonValue, JsonPointer> jsonValueFilterVisitor() {
        return INSTANCE;
    }

    private JsonValueFilterVisitor() {
    }

    @Override
    public Boolean visitAndFilter(JsonValue p, List<QueryFilter<JsonPointer>> subFilters) {
        for (QueryFilter<JsonPointer> subFilter : subFilters) {
            if (subFilter.accept(this, p).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitBooleanLiteralFilter(JsonValue p, boolean value) {
        return value;
    }

    @Override
    public Boolean visitContainsFilter(JsonValue p, JsonPointer field, Object valueAssertion) {
        for (Object value : this.getValues(p, field)) {
            if (!Utils.isCompatible(valueAssertion, value)) continue;
            if (valueAssertion instanceof String) {
                String s1 = ((String)valueAssertion).toLowerCase(Locale.ENGLISH);
                String s2 = ((String)value).toLowerCase(Locale.ENGLISH);
                if (!s2.contains(s1)) continue;
                return Boolean.TRUE;
            }
            if (Utils.compareValues(valueAssertion, value) != 0) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitEqualsFilter(JsonValue p, JsonPointer field, Object valueAssertion) {
        Boolean result = Boolean.TRUE;
        for (Object value : this.getValues(p, field)) {
            if (Utils.isCompatible(valueAssertion, value) && Utils.compareValues(valueAssertion, value) == 0) continue;
            result = Boolean.FALSE;
        }
        return result;
    }

    @Override
    public Boolean visitExtendedMatchFilter(JsonValue p, JsonPointer field, String matchingRuleId, Object valueAssertion) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitGreaterThanFilter(JsonValue p, JsonPointer field, Object valueAssertion) {
        for (Object value : this.getValues(p, field)) {
            if (!Utils.isCompatible(valueAssertion, value) || Utils.compareValues(valueAssertion, value) >= 0) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitGreaterThanOrEqualToFilter(JsonValue p, JsonPointer field, Object valueAssertion) {
        for (Object value : this.getValues(p, field)) {
            if (!Utils.isCompatible(valueAssertion, value) || Utils.compareValues(valueAssertion, value) > 0) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitLessThanFilter(JsonValue p, JsonPointer field, Object valueAssertion) {
        for (Object value : this.getValues(p, field)) {
            if (!Utils.isCompatible(valueAssertion, value) || Utils.compareValues(valueAssertion, value) <= 0) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitLessThanOrEqualToFilter(JsonValue p, JsonPointer field, Object valueAssertion) {
        for (Object value : this.getValues(p, field)) {
            if (!Utils.isCompatible(valueAssertion, value) || Utils.compareValues(valueAssertion, value) < 0) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitNotFilter(JsonValue p, QueryFilter<JsonPointer> subFilter) {
        return subFilter.accept(this, p) == false;
    }

    @Override
    public Boolean visitOrFilter(JsonValue p, List<QueryFilter<JsonPointer>> subFilters) {
        for (QueryFilter<JsonPointer> subFilter : subFilters) {
            if (!subFilter.accept(this, p).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitPresentFilter(JsonValue p, JsonPointer field) {
        JsonValue value = p.get(field);
        return value != null && !value.isNull();
    }

    @Override
    public Boolean visitStartsWithFilter(JsonValue p, JsonPointer field, Object valueAssertion) {
        for (Object value : this.getValues(p, field)) {
            if (!Utils.isCompatible(valueAssertion, value)) continue;
            if (valueAssertion instanceof String) {
                String s1 = ((String)valueAssertion).toLowerCase(Locale.ENGLISH);
                String s2 = ((String)value).toLowerCase(Locale.ENGLISH);
                if (!s2.startsWith(s1)) continue;
                return Boolean.TRUE;
            }
            if (Utils.compareValues(valueAssertion, value) != 0) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private List<Object> getValues(JsonValue resource, JsonPointer field) {
        JsonValue value = resource.get(field);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value.isList()) {
            return value.asList();
        }
        return Collections.singletonList(value.getObject());
    }
}

