/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.forgerock.util.Option;

public final class Options {
    private static final Options DEFAULT = Options.unmodifiableCopyOf(Options.defaultOptions());
    private final Map<Option<?>, Object> map;

    public static Options copyOf(Options options) {
        return new Options(new IdentityHashMap(options.map));
    }

    public static Options defaultOptions() {
        return new Options(new IdentityHashMap());
    }

    public static Options unmodifiableCopyOf(Options options) {
        return new Options(Collections.unmodifiableMap(new IdentityHashMap(options.map)));
    }

    public static Options unmodifiableDefaultOptions() {
        return DEFAULT;
    }

    private Options(Map<Option<?>, Object> optionsMap) {
        this.map = optionsMap;
    }

    public <T> T get(Option<T> option) {
        return option.getValue(this.map.get(option));
    }

    public <T> Options reset(Option<T> option) {
        this.map.remove(option);
        return this;
    }

    public <T> Options set(Option<T> option, T value) {
        this.map.put(option, value);
        return this;
    }
}

