/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.forgerock.util.Function;

public final class LambdaExceptionUtils {
    private LambdaExceptionUtils() {
    }

    public static <T, E extends Exception> Consumer<T> rethrowConsumer(ThrowingConsumer<T, E> consumer) throws E {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception exception) {
                LambdaExceptionUtils.throwActualException(exception);
            }
        };
    }

    public static <T, E extends Exception> Predicate<T> rethrowPredicate(ThrowingPredicate<T, E> predicate) throws E {
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (Exception exception) {
                LambdaExceptionUtils.throwActualException(exception);
                return false;
            }
        };
    }

    public static <T, E extends Exception> Supplier<T> rethrowSupplier(ThrowingSupplier<T, E> supplier) throws E {
        return () -> {
            try {
                return supplier.accept();
            }
            catch (Exception exception) {
                LambdaExceptionUtils.throwActualException(exception);
                return null;
            }
        };
    }

    public static <T, R, E extends Exception> java.util.function.Function<T, R> rethrowFunction(Function<T, R, E> function) throws E {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                LambdaExceptionUtils.throwActualException(exception);
                return null;
            }
        };
    }

    public static <T, U, R, E extends Exception> BiFunction<T, U, R> rethrowBiFunction(ThrowingBiFunction<T, U, R, E> function) throws E {
        return (t, u) -> {
            try {
                return function.apply(t, u);
            }
            catch (Exception exception) {
                LambdaExceptionUtils.throwActualException(exception);
                return null;
            }
        };
    }

    private static <E extends Exception> void throwActualException(Exception exception) throws E {
        throw exception;
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T, E extends Exception> {
        public T accept() throws E;
    }

    @FunctionalInterface
    public static interface ThrowingPredicate<T, E extends Exception> {
        public boolean test(T var1) throws E;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }

    @FunctionalInterface
    public static interface ThrowingBiFunction<T, U, R, E extends Exception> {
        public R apply(T var1, U var2) throws E;
    }
}

