/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.messages.AbstractIntermediateResponse;
import org.forgerock.opendj.ldap.messages.GenericIntermediateResponse;

final class GenericIntermediateResponseImpl
extends AbstractIntermediateResponse<GenericIntermediateResponse>
implements GenericIntermediateResponse {
    private String responseName;
    private ByteString responseValue;

    GenericIntermediateResponseImpl() {
    }

    GenericIntermediateResponseImpl(GenericIntermediateResponse genericIntermediateResponse) {
        super(genericIntermediateResponse);
        this.responseName = genericIntermediateResponse.getOid();
        this.responseValue = genericIntermediateResponse.getValue();
    }

    @Override
    public String getOid() {
        return this.responseName;
    }

    @Override
    public ByteString getValue() {
        return this.responseValue;
    }

    @Override
    public boolean hasValue() {
        return this.responseValue != null;
    }

    @Override
    public GenericIntermediateResponse setOid(String oid) {
        this.responseName = oid;
        return this;
    }

    @Override
    public GenericIntermediateResponse setValue(Object value) {
        this.responseValue = value != null ? ByteString.valueOfObject(value) : null;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GenericIntermediateResponse(responseName=");
        builder.append(this.getOid() == null ? "" : this.getOid());
        if (this.hasValue()) {
            builder.append(", requestValue=");
            builder.append(this.getValue().toHexPlusAsciiString(4));
        }
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }
}

