/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.messages.AbstractProtocolOpImpl;
import org.forgerock.opendj.ldap.messages.DeleteRequest;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.RequestVisitor;
import org.forgerock.util.Reject;

final class DeleteRequestImpl
extends AbstractProtocolOpImpl<DeleteRequest>
implements DeleteRequest {
    private Dn name;

    DeleteRequestImpl(DeleteRequest deleteRequest) {
        super(deleteRequest);
        this.name = deleteRequest.getName();
    }

    DeleteRequestImpl(Dn name) {
        this.name = name;
    }

    @Override
    public <R, P, E extends Exception> R accept(RequestVisitor<R, P, E> v, P p) throws E {
        return v.visitRequest(p, this);
    }

    @Override
    public Dn getName() {
        return this.name;
    }

    @Override
    public DeleteRequest setName(Dn dn) {
        Reject.ifNull(dn);
        this.name = dn;
        return this;
    }

    @Override
    public DeleteRequest setName(String dn) {
        Reject.ifNull(dn);
        this.name = Dn.valueOf(dn);
        return this;
    }

    @Override
    public Request.RequestType getType() {
        return Request.RequestType.DELETE;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeleteRequest(name=");
        builder.append(this.getName());
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    DeleteRequest getThis() {
        return this;
    }
}

