/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.Asn1;
import org.forgerock.opendj.io.Asn1Reader;
import org.forgerock.opendj.io.Asn1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class SubentriesRequestControl
implements Control {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final String OID = "1.3.6.1.4.1.4203.1.10.1";
    private static final SubentriesRequestControl CRITICAL_VISIBLE_INSTANCE = new SubentriesRequestControl(true, true);
    private static final SubentriesRequestControl NONCRITICAL_VISIBLE_INSTANCE = new SubentriesRequestControl(false, true);
    private static final SubentriesRequestControl CRITICAL_INVISIBLE_INSTANCE = new SubentriesRequestControl(true, false);
    private static final SubentriesRequestControl NONCRITICAL_INVISIBLE_INSTANCE = new SubentriesRequestControl(false, false);
    public static final ControlDecoder<SubentriesRequestControl> DECODER = new ControlDecoder<SubentriesRequestControl>(){

        @Override
        public SubentriesRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            boolean visibility;
            Reject.ifNull(control);
            if (control instanceof SubentriesRequestControl) {
                return (SubentriesRequestControl)control;
            }
            if (!control.getOid().equals(SubentriesRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_SUBENTRIES_CONTROL_BAD_OID.get(control.getOid(), SubentriesRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_SUBENTRIES_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            Asn1Reader reader = Asn1.getReader(control.getValue());
            try {
                visibility = reader.readBoolean();
            }
            catch (IOException e) {
                logger.debug(LocalizableMessage.raw("Unable to read visbility", e));
                LocalizableMessage message = CoreMessages.ERR_SUBENTRIES_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message);
            }
            return SubentriesRequestControl.newControl(control.isCritical(), visibility);
        }

        @Override
        public String getOid() {
            return SubentriesRequestControl.OID;
        }
    };
    private final boolean isCritical;
    private final boolean visibility;

    public static SubentriesRequestControl newControl(boolean isCritical, boolean visibility) {
        if (isCritical) {
            return visibility ? CRITICAL_VISIBLE_INSTANCE : CRITICAL_INVISIBLE_INSTANCE;
        }
        return visibility ? NONCRITICAL_VISIBLE_INSTANCE : NONCRITICAL_INVISIBLE_INSTANCE;
    }

    private SubentriesRequestControl(boolean isCritical, boolean visibility) {
        this.isCritical = isCritical;
        this.visibility = visibility;
    }

    @Override
    public String getOid() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        Asn1Writer writer = Asn1.getWriter(buffer);
        try {
            writer.writeBoolean(this.visibility);
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public boolean getVisibility() {
        return this.visibility;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SubentriesRequestControl(oid=");
        builder.append(this.getOid());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", visibility=");
        builder.append(this.getVisibility());
        builder.append(")");
        return builder.toString();
    }
}

