/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.Asn1;
import org.forgerock.opendj.io.Asn1Reader;
import org.forgerock.opendj.io.Asn1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class SimplePagedResultsControl
implements Control {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final String OID = "1.2.840.113556.1.4.319";
    public static final ControlDecoder<SimplePagedResultsControl> DECODER = new ControlDecoder<SimplePagedResultsControl>(){

        @Override
        public SimplePagedResultsControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            ByteString cookie;
            int size;
            Reject.ifNull(control);
            if (control instanceof SimplePagedResultsControl) {
                return (SimplePagedResultsControl)control;
            }
            if (!control.getOid().equals(SimplePagedResultsControl.OID)) {
                throw DecodeException.error(CoreMessages.ERR_LDAP_PAGED_RESULTS_CONTROL_BAD_OID.get(control.getOid(), SimplePagedResultsControl.OID));
            }
            if (!control.hasValue()) {
                throw DecodeException.error(CoreMessages.ERR_LDAP_PAGED_RESULTS_DECODE_NULL.get());
            }
            Asn1Reader reader = Asn1.getReader(control.getValue());
            try {
                reader.readStartSequence();
            }
            catch (Exception e) {
                logger.debug(LocalizableMessage.raw("Unable to read start sequence", e));
                throw DecodeException.error(CoreMessages.ERR_LDAP_PAGED_RESULTS_DECODE_SEQUENCE.get(e), e);
            }
            try {
                size = (int)reader.readInteger();
            }
            catch (Exception e) {
                logger.debug(LocalizableMessage.raw("Unable to read size", e));
                throw DecodeException.error(CoreMessages.ERR_LDAP_PAGED_RESULTS_DECODE_SIZE.get(e), e);
            }
            try {
                cookie = reader.readOctetString();
            }
            catch (Exception e) {
                logger.debug(LocalizableMessage.raw("Unable to read cookie", e));
                throw DecodeException.error(CoreMessages.ERR_LDAP_PAGED_RESULTS_DECODE_COOKIE.get(e), e);
            }
            try {
                reader.readEndSequence();
            }
            catch (Exception e) {
                logger.debug(LocalizableMessage.raw("Unable to read end sequence", e));
                throw DecodeException.error(CoreMessages.ERR_LDAP_PAGED_RESULTS_DECODE_SEQUENCE.get(e), e);
            }
            return new SimplePagedResultsControl(control.isCritical(), size, cookie);
        }

        @Override
        public String getOid() {
            return SimplePagedResultsControl.OID;
        }
    };
    private final int size;
    private final ByteString cookie;
    private final boolean isCritical;

    public static SimplePagedResultsControl newControl(boolean isCritical, int size, ByteString cookie) {
        Reject.ifNull(cookie);
        return new SimplePagedResultsControl(isCritical, size, cookie);
    }

    private SimplePagedResultsControl(boolean isCritical, int size, ByteString cookie) {
        this.isCritical = isCritical;
        this.size = size;
        this.cookie = cookie;
    }

    public ByteString getCookie() {
        return this.cookie;
    }

    @Override
    public String getOid() {
        return OID;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        Asn1Writer writer = Asn1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            writer.writeInteger(this.size);
            writer.writeOctetString(this.cookie);
            writer.writeEndSequence();
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SimplePagedResultsControl(oid=");
        builder.append(this.getOid());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", size=");
        builder.append(this.size);
        builder.append(", cookie=");
        builder.append(this.cookie);
        builder.append(")");
        return builder.toString();
    }
}

