/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import java.io.IOException;
import org.forgerock.opendj.grizzly.Asn1BufferReader;
import org.forgerock.opendj.grizzly.Asn1BufferWriter;
import org.forgerock.opendj.grizzly.GrizzlyUtils;
import org.forgerock.opendj.grizzly.StartTlsFilter;
import org.forgerock.opendj.io.LdapReader;
import org.forgerock.opendj.io.LdapWriter;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.LdapMessage;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.StartTlsExtendedResult;
import org.forgerock.util.Function;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

final class LdapMessageCodec
extends BaseFilter {
    private static final Function<LdapReader<?>, LdapMessage, IOException> REQUEST_DECODER = new Function<LdapReader<?>, LdapMessage, IOException>(){

        @Override
        public LdapMessage apply(LdapReader<?> reader) throws IOException {
            return reader.readLdapRequestMessage();
        }
    };
    private static final Function<LdapReader<?>, LdapMessage, IOException> RESPONSE_DECODER = new Function<LdapReader<?>, LdapMessage, IOException>(){

        @Override
        public LdapMessage apply(LdapReader<?> reader) throws IOException {
            return reader.readLdapResponseMessage();
        }
    };
    private final ThreadLocal<LdapReader<Asn1BufferReader>> readers;
    private final Function<LdapReader<?>, LdapMessage, IOException> decoder;
    private volatile boolean isLdapV2Pending;
    private volatile int protocolVersion = 3;

    static final BaseFilter newServerMessageCodec(int maxAsn1ElementSize, DecodeOptions decodeOptions) {
        return new LdapMessageCodec(REQUEST_DECODER, maxAsn1ElementSize, decodeOptions);
    }

    static final BaseFilter newClientMessageCodec(int maxAsn1ElementSize, DecodeOptions decodeOptions) {
        return new LdapMessageCodec(RESPONSE_DECODER, maxAsn1ElementSize, decodeOptions);
    }

    private LdapMessageCodec(Function<LdapReader<?>, LdapMessage, IOException> decoder, final int maxAsn1ElementSize, final DecodeOptions decodeOptions) {
        this.readers = new ThreadLocal<LdapReader<Asn1BufferReader>>(){

            @Override
            protected LdapReader<Asn1BufferReader> initialValue() {
                return GrizzlyUtils.createReader(decodeOptions, maxAsn1ElementSize);
            }
        };
        this.decoder = decoder;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer buffer = (Buffer)ctx.getMessage();
        int mark = buffer.position();
        LdapReader<Asn1BufferReader> ldapReader = this.readers.get();
        Asn1BufferReader asn1Reader = ldapReader.getAsn1Reader();
        asn1Reader.setBuffer(buffer);
        if (!ldapReader.hasMessageAvailable()) {
            buffer.position(mark);
            return ctx.getStopAction(buffer);
        }
        LdapMessage decodedMessage = this.decoder.apply(ldapReader);
        if (decodedMessage.getProtocolOpType() == 96) {
            this.isLdapV2Pending = ((BindRequest)decodedMessage.getProtocolOp()).getVersion() == 2;
        }
        ctx.setMessage(decodedMessage);
        Buffer remaining = buffer.hasRemaining() ? buffer.split(buffer.position()) : null;
        asn1Reader.close();
        return ctx.getInvokeAction(remaining);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        StartTlsExtendedResult startTlsResult;
        LdapMessage ldapMessage = (LdapMessage)ctx.getMessage();
        if (this.isBindResult(ldapMessage)) {
            Result bindResult = (Result)ldapMessage.getProtocolOp();
            if (bindResult.isSuccess()) {
                this.protocolVersion = this.isLdapV2Pending ? 2 : 3;
            }
        } else if (this.isStartTlsExtendedResult(ldapMessage) && (startTlsResult = (StartTlsExtendedResult)ldapMessage.getProtocolOp()).isSuccess()) {
            ctx.notifyDownstream(new StartTlsFilter.ActivateStartTlsEvent(startTlsResult.getSslOptions()));
        }
        LdapWriter<Asn1BufferWriter> writer = GrizzlyUtils.getWriter(ctx.getMemoryManager(), this.protocolVersion);
        try {
            writer.writeLdapMessage(ldapMessage);
            Buffer buffer = writer.getAsn1Writer().getBuffer();
            ctx.setMessage(buffer);
            NextAction nextAction = ctx.getInvokeAction();
            return nextAction;
        }
        finally {
            GrizzlyUtils.recycleWriter(writer);
        }
    }

    private boolean isBindResult(LdapMessage message) {
        return message.getProtocolOpType() == 97 && message.getProtocolOp() instanceof BindResult;
    }

    private boolean isStartTlsExtendedResult(LdapMessage message) {
        return message.getProtocolOpType() == 120 && message.getProtocolOp() instanceof StartTlsExtendedResult;
    }
}

