/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.opendj.grizzly.GrizzlyMessages;
import com.forgerock.opendj.util.ReferenceCountedObject;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.grizzly.DefaultTCPNIOTransport;
import org.forgerock.opendj.grizzly.GrizzlyLdapConnection;
import org.forgerock.opendj.grizzly.GrizzlyUtils;
import org.forgerock.opendj.grizzly.LdapClientFilter;
import org.forgerock.opendj.grizzly.LdapMessageCodec;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.LdapConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.TimeoutChecker;
import org.forgerock.opendj.ldap.TimeoutEventListener;
import org.forgerock.opendj.ldap.spi.LdapConnectionFactoryImpl;
import org.forgerock.opendj.ldap.spi.LdapConnectionImpl;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.time.Duration;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public final class GrizzlyLdapConnectionFactory
implements LdapConnectionFactoryImpl {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final Options options;
    private final String host;
    private final int port;
    private final AtomicInteger referenceCount = new AtomicInteger(1);
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final ReferenceCountedObject.Reference<TCPNIOTransport> transport;
    private final ReferenceCountedObject.Reference<TimeoutChecker> timeoutChecker = TimeoutChecker.TIMEOUT_CHECKER.acquire();
    public static final Option<TCPNIOTransport> GRIZZLY_TRANSPORT = Option.of(TCPNIOTransport.class, null);

    public GrizzlyLdapConnectionFactory(String host, int port, Options options) {
        this.transport = DefaultTCPNIOTransport.DEFAULT_TRANSPORT.acquireIfNull(options.get(GRIZZLY_TRANSPORT));
        this.host = host;
        this.port = port;
        this.options = options;
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.releaseTransportAndTimeoutChecker();
        }
    }

    @Override
    public Promise<LdapConnectionImpl, LdapException> getConnectionAsync() {
        this.acquireTransportAndTimeoutChecker();
        TCPNIOConnectorHandler connectorHandler = TCPNIOConnectorHandler.builder(this.transport.get()).build();
        PromiseImpl<LdapConnectionImpl, LdapException> promise = PromiseImpl.create();
        connectorHandler.connect(this.getSocketAddress(), (CompletionHandler<Connection>)new CompletionHandlerAdapter(promise));
        return promise;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    @Override
    public String getHostName() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    TimeoutChecker getTimeoutChecker() {
        return this.timeoutChecker.get();
    }

    Options getLdapOptions() {
        return this.options;
    }

    void releaseTransportAndTimeoutChecker() {
        if (this.referenceCount.decrementAndGet() == 0) {
            this.transport.release();
            this.timeoutChecker.release();
        }
    }

    private void acquireTransportAndTimeoutChecker() {
        this.referenceCount.incrementAndGet();
        if (this.isClosed.get()) {
            this.releaseTransportAndTimeoutChecker();
            throw new IllegalStateException("Attempted to get a connection after factory close");
        }
    }

    private final class CompletionHandlerAdapter
    implements CompletionHandler<Connection>,
    TimeoutEventListener {
        private final PromiseImpl<LdapConnectionImpl, LdapException> promise;
        private final long timeoutEndTime;

        private CompletionHandlerAdapter(PromiseImpl<LdapConnectionImpl, LdapException> promise) {
            this.promise = promise;
            long timeoutMS = this.getTimeout();
            this.timeoutEndTime = timeoutMS > 0L ? System.currentTimeMillis() + timeoutMS : 0L;
            ((TimeoutChecker)GrizzlyLdapConnectionFactory.this.timeoutChecker.get()).addListener(this);
        }

        @Override
        public void cancelled() {
        }

        @Override
        public void completed(Connection result) {
            GrizzlyLdapConnection connection = this.adaptConnection(result);
            ((TimeoutChecker)GrizzlyLdapConnectionFactory.this.timeoutChecker.get()).removeListener(this);
            if (!this.promise.tryHandleResult(connection)) {
                connection.close();
            }
        }

        @Override
        public void failed(Throwable throwable) {
            ((TimeoutChecker)GrizzlyLdapConnectionFactory.this.timeoutChecker.get()).removeListener(this);
            this.promise.handleException(this.adaptConnectionException(throwable));
            GrizzlyLdapConnectionFactory.this.releaseTransportAndTimeoutChecker();
        }

        @Override
        public void updated(Connection result) {
        }

        private GrizzlyLdapConnection adaptConnection(Connection<?> connection) {
            GrizzlyUtils.configureConnection(connection, logger, GrizzlyLdapConnectionFactory.this.options);
            connection.configureBlocking(true);
            GrizzlyLdapConnection ldapConnection = new GrizzlyLdapConnection(connection, GrizzlyLdapConnectionFactory.this);
            ((TimeoutChecker)GrizzlyLdapConnectionFactory.this.timeoutChecker.get()).addListener(ldapConnection);
            connection.setProcessor(GrizzlyUtils.buildFilterChain(connection.getProcessor(), LdapMessageCodec.newClientMessageCodec(0, (DecodeOptions)GrizzlyLdapConnectionFactory.this.options.get(LdapConnectionFactory.LDAP_DECODE_OPTIONS)), new LdapClientFilter(ldapConnection)));
            return ldapConnection;
        }

        private LdapException adaptConnectionException(Throwable t) {
            if (!(t instanceof LdapException) && t instanceof ExecutionException) {
                Throwable throwable = t = t.getCause() != null ? t.getCause() : t;
            }
            if (t instanceof LdapException) {
                return (LdapException)t;
            }
            return LdapException.newLdapException(ResultCode.CLIENT_SIDE_CONNECT_ERROR, t.getMessage(), t);
        }

        @Override
        public long handleTimeout(long currentTime) {
            if (this.timeoutEndTime == 0L) {
                return 0L;
            }
            if (this.timeoutEndTime > currentTime) {
                return this.timeoutEndTime - currentTime;
            }
            this.promise.handleException(LdapException.newLdapException(ResultCode.CLIENT_SIDE_CONNECT_ERROR, GrizzlyMessages.LDAP_CONNECTION_CONNECT_TIMEOUT.get(GrizzlyLdapConnectionFactory.this.getSocketAddress(), this.getTimeout()).toString()));
            return 0L;
        }

        @Override
        public long getTimeout() {
            Duration duration = GrizzlyLdapConnectionFactory.this.options.get(LdapConnectionFactory.CONNECT_TIMEOUT);
            return duration.isUnlimited() ? 0L : duration.to(TimeUnit.MILLISECONDS);
        }
    }
}

