/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.schema.validator.validators;

import java.util.List;
import java.util.Map;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.schema.validator.ErrorHandler;
import org.forgerock.json.schema.validator.exceptions.SchemaException;
import org.forgerock.json.schema.validator.exceptions.ValidationException;
import org.forgerock.json.schema.validator.helpers.EnumHelper;
import org.forgerock.json.schema.validator.helpers.MaximumHelper;
import org.forgerock.json.schema.validator.helpers.MinimumHelper;
import org.forgerock.json.schema.validator.validators.SimpleValidator;
import org.forgerock.json.schema.validator.validators.Validator;

public class NumberTypeValidator
extends Validator {
    private Number divisibleBy = null;
    private EnumHelper enumHelper = null;
    private SimpleValidator<Number> minimumValidator = null;
    private SimpleValidator<Number> maximumValidator = null;

    public NumberTypeValidator(Map<String, Object> schema, List<String> jsonPointer) {
        super(schema, jsonPointer);
        Number minimum = null;
        Number maximum = null;
        boolean exclusiveMinimum = false;
        boolean exclusiveMaximum = false;
        for (Map.Entry<String, Object> e : schema.entrySet()) {
            if ("minimum".equals(e.getKey())) {
                if (!(e.getValue() instanceof Number)) continue;
                minimum = (Number)e.getValue();
                continue;
            }
            if ("maximum".equals(e.getKey())) {
                if (!(e.getValue() instanceof Number)) continue;
                maximum = (Number)e.getValue();
                continue;
            }
            if ("exclusiveMinimum".equals(e.getKey())) {
                if (e.getValue() instanceof Boolean) {
                    exclusiveMinimum = (Boolean)e.getValue();
                    continue;
                }
                if (!(e.getValue() instanceof String)) continue;
                exclusiveMinimum = Boolean.parseBoolean((String)e.getValue());
                continue;
            }
            if ("exclusiveMaximum".equals(e.getKey())) {
                if (e.getValue() instanceof Boolean) {
                    exclusiveMaximum = (Boolean)e.getValue();
                    continue;
                }
                if (!(e.getValue() instanceof String)) continue;
                exclusiveMaximum = Boolean.parseBoolean((String)e.getValue());
                continue;
            }
            if ("divisibleBy".equals(e.getKey())) {
                if (e.getValue() instanceof Float) {
                    this.divisibleBy = ((Float)e.getValue()).floatValue() != 0.0f ? (Float)e.getValue() : null;
                    continue;
                }
                if (!(e.getValue() instanceof Double)) continue;
                this.divisibleBy = (Double)e.getValue() != 0.0 ? (Double)e.getValue() : null;
                continue;
            }
            if (!"enum".equals(e.getKey()) || !(e.getValue() instanceof List)) continue;
            this.enumHelper = new EnumHelper((List)e.getValue());
        }
        if (null != minimum) {
            this.minimumValidator = new MinimumHelper(minimum, exclusiveMinimum);
        }
        if (null != maximum) {
            this.maximumValidator = new MaximumHelper(maximum, exclusiveMaximum);
        }
    }

    @Override
    public void validate(Object node, JsonPointer at, ErrorHandler handler) throws SchemaException {
        if (node instanceof Number) {
            Number nodeValue = (Number)node;
            if (null != this.minimumValidator) {
                this.minimumValidator.validate(nodeValue, this.getPath(at, null), handler);
            }
            if (null != this.maximumValidator) {
                this.maximumValidator.validate(nodeValue, this.getPath(at, null), handler);
            }
            if (this.divisibleBy instanceof Float && node instanceof Float && (double)(((Float)nodeValue).floatValue() % ((Float)this.divisibleBy).floatValue()) != 0.0) {
                handler.error(new ValidationException("", this.getPath(at, null)));
            } else if (this.divisibleBy instanceof Double && node instanceof Double && (Double)nodeValue % (Double)this.divisibleBy != 0.0) {
                handler.error(new ValidationException("", this.getPath(at, null)));
            }
            if (null != this.enumHelper) {
                this.enumHelper.validate(node, at, handler);
            }
        } else if (null != node) {
            handler.error(new ValidationException("Type mismatch at {}. Expected type {} found {}", this.getPath(at, null)));
        } else if (this.required) {
            handler.error(new ValidationException("Required property violation at {}", this.getPath(at, null)));
        }
    }
}

