/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.forgerock.http.routing.Version;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.CountPolicy;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestType;
import org.forgerock.json.resource.RequestVisitor;
import org.forgerock.json.resource.ResourcePath;
import org.forgerock.json.resource.SortKey;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.util.Utils;
import org.forgerock.util.i18n.PreferredLocales;
import org.forgerock.util.query.QueryFilter;

public final class Requests {
    public static ActionRequest copyOfActionRequest(ActionRequest request) {
        return new ActionRequestImpl(request);
    }

    public static CreateRequest copyOfCreateRequest(CreateRequest request) {
        return new CreateRequestImpl(request);
    }

    public static DeleteRequest copyOfDeleteRequest(DeleteRequest request) {
        return new DeleteRequestImpl(request);
    }

    public static PatchRequest copyOfPatchRequest(PatchRequest request) {
        return new PatchRequestImpl(request);
    }

    public static QueryRequest copyOfQueryRequest(QueryRequest request) {
        return new QueryRequestImpl(request);
    }

    public static ReadRequest copyOfReadRequest(ReadRequest request) {
        return new ReadRequestImpl(request);
    }

    public static UpdateRequest copyOfUpdateRequest(UpdateRequest request) {
        return new UpdateRequestImpl(request);
    }

    public static Request copyOfApiRequest(Request request) {
        return new ApiRequestImpl((ApiRequestImpl)request);
    }

    public static ActionRequest newActionRequest(String resourcePath, String actionId) {
        return ((ActionRequest)new ActionRequestImpl().setResourcePath(resourcePath)).setAction(actionId);
    }

    public static ActionRequest newActionRequest(ResourcePath resourcePath, String actionId) {
        return ((ActionRequest)new ActionRequestImpl().setResourcePath(resourcePath)).setAction(actionId);
    }

    public static ActionRequest newActionRequest(String resourceContainer, String resourceId, String actionId) {
        return Requests.newActionRequest(ResourcePath.valueOf(resourceContainer), resourceId, actionId);
    }

    public static ActionRequest newActionRequest(ResourcePath resourceContainer, String resourceId, String actionId) {
        return Requests.newActionRequest(resourceContainer.child(resourceId), actionId);
    }

    public static CreateRequest newCreateRequest(String resourceContainer, JsonValue content) {
        return ((CreateRequest)new CreateRequestImpl().setResourcePath(resourceContainer)).setContent(content);
    }

    public static CreateRequest newCreateRequest(ResourcePath resourceContainer, JsonValue content) {
        return ((CreateRequest)new CreateRequestImpl().setResourcePath(resourceContainer)).setContent(content);
    }

    public static CreateRequest newCreateRequest(String resourceContainer, String newResourceId, JsonValue content) {
        return Requests.newCreateRequest(resourceContainer, content).setNewResourceId(newResourceId);
    }

    public static CreateRequest newCreateRequest(ResourcePath resourceContainer, String newResourceId, JsonValue content) {
        return Requests.newCreateRequest(resourceContainer, content).setNewResourceId(newResourceId);
    }

    public static DeleteRequest newDeleteRequest(String resourcePath) {
        return (DeleteRequest)new DeleteRequestImpl().setResourcePath(resourcePath);
    }

    public static DeleteRequest newDeleteRequest(ResourcePath resourcePath) {
        return (DeleteRequest)new DeleteRequestImpl().setResourcePath(resourcePath);
    }

    public static DeleteRequest newDeleteRequest(String resourceContainer, String resourceId) {
        return Requests.newDeleteRequest(ResourcePath.valueOf(resourceContainer), resourceId);
    }

    public static DeleteRequest newDeleteRequest(ResourcePath resourceContainer, String resourceId) {
        return Requests.newDeleteRequest(resourceContainer.child(resourceId));
    }

    public static PatchRequest newPatchRequest(String resourcePath, PatchOperation ... operations) {
        return ((PatchRequest)new PatchRequestImpl().setResourcePath(resourcePath)).addPatchOperation(operations);
    }

    public static PatchRequest newPatchRequest(ResourcePath resourcePath, PatchOperation ... operations) {
        return ((PatchRequest)new PatchRequestImpl().setResourcePath(resourcePath)).addPatchOperation(operations);
    }

    public static PatchRequest newPatchRequest(String resourceContainer, String resourceId, PatchOperation ... operations) {
        return Requests.newPatchRequest(ResourcePath.valueOf(resourceContainer), resourceId, operations);
    }

    public static PatchRequest newPatchRequest(ResourcePath resourceContainer, String resourceId, PatchOperation ... operations) {
        return Requests.newPatchRequest(resourceContainer.child(resourceId), operations);
    }

    public static QueryRequest newQueryRequest(String resourceContainer) {
        return (QueryRequest)new QueryRequestImpl().setResourcePath(resourceContainer);
    }

    public static QueryRequest newQueryRequest(ResourcePath resourceContainer) {
        return (QueryRequest)new QueryRequestImpl().setResourcePath(resourceContainer);
    }

    public static ReadRequest newReadRequest(String resourcePath) {
        return (ReadRequest)new ReadRequestImpl().setResourcePath(resourcePath);
    }

    public static ReadRequest newReadRequest(ResourcePath resourcePath) {
        return (ReadRequest)new ReadRequestImpl().setResourcePath(resourcePath);
    }

    public static ReadRequest newReadRequest(String resourceContainer, String resourceId) {
        return Requests.newReadRequest(ResourcePath.valueOf(resourceContainer), resourceId);
    }

    public static ReadRequest newReadRequest(ResourcePath resourceContainer, String resourceId) {
        return Requests.newReadRequest(resourceContainer.child(resourceId));
    }

    public static UpdateRequest newUpdateRequest(String resourcePath, JsonValue newContent) {
        return ((UpdateRequest)new UpdateRequestImpl().setResourcePath(resourcePath)).setContent(newContent);
    }

    public static UpdateRequest newUpdateRequest(ResourcePath resourcePath, JsonValue newContent) {
        return ((UpdateRequest)new UpdateRequestImpl().setResourcePath(resourcePath)).setContent(newContent);
    }

    public static UpdateRequest newUpdateRequest(CreateRequest createRequest) {
        return (UpdateRequest)new UpdateRequestImpl(createRequest).setResourcePath(createRequest.getResourcePathObject().child(createRequest.getNewResourceId()));
    }

    public static UpdateRequest newUpdateRequest(String resourceContainer, String resourceId, JsonValue newContent) {
        return Requests.newUpdateRequest(ResourcePath.valueOf(resourceContainer), resourceId, newContent);
    }

    public static UpdateRequest newUpdateRequest(ResourcePath resourceContainer, String resourceId, JsonValue newContent) {
        return Requests.newUpdateRequest(resourceContainer.child(resourceId), newContent);
    }

    public static Request newApiRequest(ResourcePath path) {
        return new ApiRequestImpl().setResourcePath(path);
    }

    private static JsonValue copyJsonValue(JsonValue value) {
        return value != null ? value.copy() : null;
    }

    private static <T> T notNull(T object) {
        if (object != null) {
            return object;
        }
        throw new NullPointerException();
    }

    private Requests() {
    }

    private static final class ApiRequestImpl
    extends AbstractRequestImpl<Request> {
        private ApiRequestImpl() {
        }

        private ApiRequestImpl(ApiRequestImpl request) {
            super(request);
        }

        @Override
        protected Request getThis() {
            return this;
        }

        @Override
        public <R, P> R accept(RequestVisitor<R, P> v, P p) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.API;
        }
    }

    private static final class UpdateRequestImpl
    extends AbstractRequestImpl<UpdateRequest>
    implements UpdateRequest {
        private JsonValue content;
        private String version;

        private UpdateRequestImpl() {
        }

        private UpdateRequestImpl(CreateRequest request) {
            super(request);
            this.content = Requests.copyJsonValue(request.getContent());
        }

        private UpdateRequestImpl(UpdateRequest request) {
            super(request);
            this.version = request.getRevision();
            this.content = Requests.copyJsonValue(request.getContent());
        }

        @Override
        public <R, P> R accept(RequestVisitor<R, P> v, P p) {
            return v.visitUpdateRequest(p, this);
        }

        @Override
        public JsonValue getContent() {
            return this.content;
        }

        @Override
        public String getRevision() {
            return this.version;
        }

        @Override
        public UpdateRequest setContent(JsonValue content) {
            this.content = (JsonValue)Requests.notNull(content);
            return this;
        }

        @Override
        public UpdateRequest setRevision(String version) {
            this.version = version;
            return this;
        }

        @Override
        protected UpdateRequest getThis() {
            return this;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.UPDATE;
        }

        @Override
        public JsonValue toJsonValue() {
            return super.toJsonValue().put("revision", (Object)String.valueOf(this.getRevision())).put("content", this.getContent().getObject());
        }
    }

    private static final class ReadRequestImpl
    extends AbstractRequestImpl<ReadRequest>
    implements ReadRequest {
        private ReadRequestImpl() {
        }

        private ReadRequestImpl(ReadRequest request) {
            super(request);
        }

        @Override
        public <R, P> R accept(RequestVisitor<R, P> v, P p) {
            return v.visitReadRequest(p, this);
        }

        @Override
        protected ReadRequest getThis() {
            return this;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.READ;
        }
    }

    private static final class QueryRequestImpl
    extends AbstractRequestImpl<QueryRequest>
    implements QueryRequest {
        private QueryFilter<JsonPointer> filter;
        private final List<SortKey> keys = new LinkedList<SortKey>();
        private String pagedResultsCookie;
        private CountPolicy totalPagedResultsPolicy = CountPolicy.NONE;
        private int pagedResultsOffset = 0;
        private int pageSize = 0;
        private String queryId;
        private String queryExpression;

        private QueryRequestImpl() {
        }

        private QueryRequestImpl(QueryRequest request) {
            super(request);
            this.filter = request.getQueryFilter();
            this.queryId = request.getQueryId();
            this.queryExpression = request.getQueryExpression();
            this.keys.addAll(request.getSortKeys());
            this.pageSize = request.getPageSize();
            this.pagedResultsCookie = request.getPagedResultsCookie();
            this.pagedResultsOffset = request.getPagedResultsOffset();
            this.totalPagedResultsPolicy = request.getTotalPagedResultsPolicy();
        }

        @Override
        public <R, P> R accept(RequestVisitor<R, P> v, P p) {
            return v.visitQueryRequest(p, this);
        }

        @Override
        public QueryRequest addSortKey(SortKey ... keys) {
            for (SortKey key : keys) {
                this.keys.add((SortKey)Requests.notNull(key));
            }
            return this;
        }

        @Override
        public final QueryRequest addSortKey(String ... keys) {
            for (String key : keys) {
                this.keys.add(SortKey.valueOf(key));
            }
            return this;
        }

        @Override
        public String getPagedResultsCookie() {
            return this.pagedResultsCookie;
        }

        @Override
        public CountPolicy getTotalPagedResultsPolicy() {
            return this.totalPagedResultsPolicy;
        }

        @Override
        public int getPagedResultsOffset() {
            return this.pagedResultsOffset;
        }

        @Override
        public int getPageSize() {
            return this.pageSize;
        }

        @Override
        public QueryFilter<JsonPointer> getQueryFilter() {
            return this.filter;
        }

        @Override
        public String getQueryId() {
            return this.queryId;
        }

        @Override
        public String getQueryExpression() {
            return this.queryExpression;
        }

        @Override
        public List<SortKey> getSortKeys() {
            return this.keys;
        }

        @Override
        public QueryRequest setPagedResultsCookie(String cookie) {
            this.pagedResultsCookie = cookie;
            return this;
        }

        @Override
        public QueryRequest setTotalPagedResultsPolicy(CountPolicy totalPagedResultsPolicy) {
            this.totalPagedResultsPolicy = (CountPolicy)((Object)Requests.notNull((Object)totalPagedResultsPolicy));
            return this;
        }

        @Override
        public QueryRequest setPagedResultsOffset(int offset) {
            this.pagedResultsOffset = offset;
            return this;
        }

        @Override
        public QueryRequest setPageSize(int size) {
            this.pageSize = size;
            return this;
        }

        @Override
        public QueryRequest setQueryExpression(String expression) {
            this.queryExpression = expression;
            return this;
        }

        @Override
        public QueryRequest setQueryFilter(QueryFilter<JsonPointer> filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public QueryRequest setQueryId(String id) {
            this.queryId = id;
            return this;
        }

        @Override
        protected QueryRequest getThis() {
            return this;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.QUERY;
        }

        @Override
        public JsonValue toJsonValue() {
            ArrayList<String> sortKeys = new ArrayList<String>();
            for (SortKey key : this.getSortKeys()) {
                sortKeys.add(String.valueOf(key));
            }
            return super.toJsonValue().put("queryId", (Object)String.valueOf(this.getQueryId())).put("queryExpression", (Object)String.valueOf(this.getQueryExpression())).put("queryFilter", (Object)String.valueOf(this.getQueryFilter())).put("sortKeys", sortKeys).put("pageSize", (Object)String.valueOf(this.getPageSize())).put("pagedResultsOffset", (Object)String.valueOf(this.getPagedResultsOffset())).put("pagedResultsCookie", (Object)String.valueOf(this.getPagedResultsCookie())).put("totalPagedResultsPolicy", (Object)String.valueOf((Object)this.getTotalPagedResultsPolicy())).put("additionalParameters", this.getAdditionalParameters());
        }
    }

    private static final class PatchRequestImpl
    extends AbstractRequestImpl<PatchRequest>
    implements PatchRequest {
        private List<PatchOperation> operations;
        private String version;

        private PatchRequestImpl() {
            this.operations = new LinkedList<PatchOperation>();
        }

        private PatchRequestImpl(PatchRequest request) {
            super(request);
            this.operations = new LinkedList<PatchOperation>(request.getPatchOperations());
            this.version = request.getRevision();
        }

        @Override
        public <R, P> R accept(RequestVisitor<R, P> v, P p) {
            return v.visitPatchRequest(p, this);
        }

        @Override
        public String getRevision() {
            return this.version;
        }

        @Override
        public PatchRequest addPatchOperation(PatchOperation ... operations) {
            Collections.addAll(this.operations, operations);
            return this;
        }

        @Override
        public List<PatchOperation> getPatchOperations() {
            return this.operations;
        }

        @Override
        public PatchRequest addPatchOperation(String operation, String field, JsonValue value) {
            this.operations.add(PatchOperation.operation(operation, field, (Object)value));
            return this;
        }

        @Override
        public PatchRequest setRevision(String version) {
            this.version = version;
            return this;
        }

        @Override
        protected PatchRequest getThis() {
            return this;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.PATCH;
        }

        @Override
        public JsonValue toJsonValue() {
            ArrayList<Object> operations = new ArrayList<Object>();
            for (PatchOperation operation : this.getPatchOperations()) {
                operations.add(operation.toJsonValue().getObject());
            }
            return super.toJsonValue().put("revision", (Object)String.valueOf(this.getRevision())).put("patchOperations", operations);
        }
    }

    private static final class DeleteRequestImpl
    extends AbstractRequestImpl<DeleteRequest>
    implements DeleteRequest {
        private String version;

        private DeleteRequestImpl() {
        }

        private DeleteRequestImpl(DeleteRequest request) {
            super(request);
            this.version = request.getRevision();
        }

        @Override
        public <R, P> R accept(RequestVisitor<R, P> v, P p) {
            return v.visitDeleteRequest(p, this);
        }

        @Override
        public String getRevision() {
            return this.version;
        }

        @Override
        public DeleteRequest setRevision(String version) {
            this.version = version;
            return this;
        }

        @Override
        protected DeleteRequest getThis() {
            return this;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.DELETE;
        }

        @Override
        public JsonValue toJsonValue() {
            return super.toJsonValue().put("revision", (Object)String.valueOf(this.getRevision()));
        }
    }

    private static final class CreateRequestImpl
    extends AbstractRequestImpl<CreateRequest>
    implements CreateRequest {
        private JsonValue content;
        private String newResourceId;

        private CreateRequestImpl() {
        }

        private CreateRequestImpl(CreateRequest request) {
            super(request);
            this.content = Requests.copyJsonValue(request.getContent());
            this.newResourceId = request.getNewResourceId();
        }

        @Override
        public <R, P> R accept(RequestVisitor<R, P> v, P p) {
            return v.visitCreateRequest(p, this);
        }

        @Override
        public JsonValue getContent() {
            return this.content;
        }

        @Override
        public String getNewResourceId() {
            return this.newResourceId;
        }

        @Override
        public CreateRequest setContent(JsonValue content) {
            this.content = (JsonValue)Requests.notNull(content);
            return this;
        }

        @Override
        public CreateRequest setNewResourceId(String id) {
            this.newResourceId = id;
            return this;
        }

        @Override
        protected CreateRequest getThis() {
            return this;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.CREATE;
        }

        @Override
        public JsonValue toJsonValue() {
            return super.toJsonValue().put("newResourceId", (Object)this.getNewResourceId()).put("content", this.getContent().getObject());
        }
    }

    private static final class ActionRequestImpl
    extends AbstractRequestImpl<ActionRequest>
    implements ActionRequest {
        private String actionId;
        private JsonValue content;

        private ActionRequestImpl() {
            this.content = new JsonValue(null);
        }

        private ActionRequestImpl(ActionRequest request) {
            super(request);
            this.actionId = request.getAction();
            this.content = Requests.copyJsonValue(request.getContent());
        }

        @Override
        public <R, P> R accept(RequestVisitor<R, P> v, P p) {
            return v.visitActionRequest(p, this);
        }

        @Override
        public String getAction() {
            return this.actionId;
        }

        @Override
        public <T extends Enum<T>> T getActionAsEnum(Class<T> type) {
            return Utils.asEnum(this.getAction(), type);
        }

        @Override
        public JsonValue getContent() {
            return this.content;
        }

        @Override
        public ActionRequest setAction(String id) {
            this.actionId = (String)Requests.notNull(id);
            return this;
        }

        @Override
        public ActionRequest setContent(JsonValue content) {
            this.content = content != null ? content : new JsonValue(null);
            return this;
        }

        @Override
        protected ActionRequest getThis() {
            return this;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.ACTION;
        }

        @Override
        public JsonValue toJsonValue() {
            return super.toJsonValue().put("action", (Object)String.valueOf(this.getAction())).put("content", this.getContent().getObject()).put("additionalParameters", this.getAdditionalParameters());
        }

        @Override
        boolean isReservedParameter(String name) {
            return name.equals("_mimeType");
        }
    }

    private static abstract class AbstractRequestImpl<T extends Request>
    implements Request {
        private final List<JsonPointer> fields = new LinkedList<JsonPointer>();
        private ResourcePath resourcePath;
        private final Map<String, String> parameters = new LinkedHashMap<String, String>(2);
        private Version resourceVersion;
        private PreferredLocales preferredLocales;

        protected AbstractRequestImpl() {
        }

        protected AbstractRequestImpl(Request request) {
            this.resourcePath = request.getResourcePathObject();
            this.fields.addAll(request.getFields());
            this.parameters.putAll(request.getAdditionalParameters());
            this.resourceVersion = request.getResourceVersion();
            this.preferredLocales = request.getPreferredLocales();
        }

        public final T addField(JsonPointer ... fields) {
            for (JsonPointer field : fields) {
                this.fields.add((JsonPointer)Requests.notNull(field));
            }
            return this.getThis();
        }

        public final T addField(String ... fields) {
            try {
                for (String field : fields) {
                    this.fields.add(new JsonPointer(field));
                }
            }
            catch (JsonException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            return this.getThis();
        }

        @Override
        public final List<JsonPointer> getFields() {
            return this.fields;
        }

        @Override
        public final String getResourcePath() {
            return this.resourcePath.toString();
        }

        @Override
        public final ResourcePath getResourcePathObject() {
            return this.resourcePath;
        }

        @Override
        public Map<String, String> getAdditionalParameters() {
            return this.parameters;
        }

        @Override
        public String getAdditionalParameter(String name) {
            return this.parameters.get(name);
        }

        @Override
        public Version getResourceVersion() {
            return this.resourceVersion;
        }

        public final T setResourcePath(String path) {
            this.resourcePath = ResourcePath.valueOf(path);
            return this.getThis();
        }

        public final T setResourcePath(ResourcePath path) {
            this.resourcePath = (ResourcePath)Requests.notNull(path);
            return this.getThis();
        }

        public T setAdditionalParameter(String name, String value) throws BadRequestException {
            if (this.isReservedParameter(name)) {
                throw new BadRequestException("Unrecognized request parameter '" + name + "'");
            }
            this.parameters.put((String)Requests.notNull(name), value);
            return this.getThis();
        }

        public T setResourceVersion(Version resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this.getThis();
        }

        boolean isReservedParameter(String name) {
            return name.startsWith("_");
        }

        protected abstract T getThis();

        @Override
        public JsonValue toJsonValue() {
            return new JsonValue(new HashMap()).put("method", (Object)this.getRequestType().name().toLowerCase()).put("resourcePath", (Object)this.getResourcePath()).put("fields", this.getFields());
        }

        public String toString() {
            return this.toJsonValue().toString();
        }

        @Override
        public PreferredLocales getPreferredLocales() {
            return this.preferredLocales;
        }

        public T setPreferredLocales(PreferredLocales preferredLocales) {
            this.preferredLocales = preferredLocales;
            return this.getThis();
        }
    }
}

