/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwk;

public enum KeyOperation {
    SIGN("sign"),
    VERIFY("verify"),
    ENCRYPT("encrypt"),
    DECRYPT("decrypt"),
    WRAP_KEY("wrapKey"),
    UNWRAP_KEY("unwrapKey"),
    DERIVE_KEY("deriveKey"),
    DERIVE_BITS("deriveBits");

    private String name;

    private KeyOperation(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static KeyOperation getKeyOperations(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (KeyOperation keyOperation : KeyOperation.values()) {
            if (!keyOperation.name.equals(name)) continue;
            return keyOperation;
        }
        throw new IllegalArgumentException("Invalid key operation");
    }

    public String toString() {
        return this.name;
    }
}

