/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwk;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.util.List;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonValue;
import org.forgerock.json.jose.jwk.JWK;
import org.forgerock.json.jose.jwk.KeyType;
import org.forgerock.json.jose.jwk.KeyUse;
import org.forgerock.json.jose.jws.SupportedEllipticCurve;
import org.forgerock.json.jose.utils.BigIntegerUtils;
import org.forgerock.util.Reject;
import org.forgerock.util.encode.Base64url;

public class EcJWK
extends JWK {
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger THREE = BigInteger.valueOf(3L);
    private static final String JSON_KEY_X = "x";
    private static final String JSON_KEY_Y = "y";
    private static final String JSON_KEY_D = "d";
    private static final String JSON_KEY_CURVE = "crv";
    private final SupportedEllipticCurve curve;
    private final String x;
    private final String y;
    private final String d;

    public static Builder builder(SupportedEllipticCurve curve, String x, String y) {
        return new Builder(curve, x, y);
    }

    public static Builder builder(String curve, String x, String y) {
        return new Builder(curve, x, y);
    }

    public static Builder builder(ECPublicKey publicKey) {
        return new Builder(publicKey);
    }

    @Deprecated
    public EcJWK(ECPublicKey publicKey, KeyUse use, String kid) {
        this(publicKey, null, use, kid);
    }

    @Deprecated
    public EcJWK(ECPublicKey publicKey, ECPrivateKey privateKey, KeyUse use, String kid) {
        super(KeyType.EC, use, use == KeyUse.SIG ? SupportedEllipticCurve.forKey(publicKey).getJwsAlgorithm().name() : null, kid);
        int fieldSize = publicKey.getParams().getCurve().getField().getFieldSize();
        this.curve = SupportedEllipticCurve.forKey(publicKey);
        this.x = EcJWK.encodeCoordinate(fieldSize, publicKey.getW().getAffineX());
        this.y = EcJWK.encodeCoordinate(fieldSize, publicKey.getW().getAffineY());
        this.d = privateKey != null ? EcJWK.encodeCoordinate(fieldSize, privateKey.getS()) : null;
    }

    @Deprecated
    public EcJWK(KeyUse use, String alg, String kid, String x, String y, String curve, String x5u, String x5t, List<String> x5c) {
        this(use, alg, kid, x, y, null, curve, x5u, x5t, x5c);
    }

    @Deprecated
    public EcJWK(KeyUse use, String alg, String kid, String x, String y, String d, String curve, String x5u, String x5t, List<String> x5c) {
        super(KeyType.EC, use, alg, kid, x5u, x5t, x5c);
        if (x == null || x.isEmpty()) {
            throw new JsonException("x is required for an EcJWK");
        }
        if (y == null || y.isEmpty()) {
            throw new JsonException("y is required for an EcJWK");
        }
        if (curve == null || curve.isEmpty()) {
            throw new JsonException("curve is required for an EcJWK");
        }
        this.curve = SupportedEllipticCurve.forName(curve);
        this.x = x;
        this.y = y;
        this.d = d;
    }

    private EcJWK(Builder builder) {
        super(KeyType.EC, builder.use, builder.keyOperations, builder.algorithm, builder.keyId, builder.x509url, builder.x509Thumbnail, builder.x509Chain);
        this.curve = builder.curve;
        this.x = builder.x;
        this.y = builder.y;
        this.d = builder.d;
    }

    public String getX() {
        return this.x;
    }

    public String getY() {
        return this.y;
    }

    public String getD() {
        return this.d;
    }

    @Deprecated
    public String getCurve() {
        return this.curve.getStandardName();
    }

    public SupportedEllipticCurve getEllipticCurve() {
        return this.curve;
    }

    public static EcJWK parse(String json) {
        return EcJWK.parse(new JsonValue(EcJWK.toJsonValue(json)));
    }

    public static EcJWK parse(JsonValue json) {
        if (json == null) {
            throw new JsonException("Can't parse EcJWK. No json data.");
        }
        KeyType kty = KeyType.getKeyType(json.get("kty").asString());
        if (!kty.equals((Object)KeyType.EC)) {
            throw new JsonException("Invalid key type '" + (Object)((Object)kty) + "'. Not an EC JWK.");
        }
        String x = json.get(JSON_KEY_X).asString();
        String y = json.get(JSON_KEY_Y).asString();
        String curve = json.get(JSON_KEY_CURVE).asString();
        Builder builder = EcJWK.builder(curve, x, y);
        if (json.get(JSON_KEY_D).isNotNull()) {
            builder.d(json.get(JSON_KEY_D).asString());
        }
        EcJWK.loadJWKFromJson(builder, json);
        return builder.build();
    }

    @Override
    public JsonValue toJsonValue() {
        JsonValue jsonValue = super.toJsonValue();
        jsonValue.put(JSON_KEY_X, (Object)this.x);
        jsonValue.put(JSON_KEY_Y, (Object)this.y);
        jsonValue.put(JSON_KEY_CURVE, (Object)this.curve.getStandardName());
        this.putField(jsonValue, JSON_KEY_D, this.d);
        return jsonValue;
    }

    public ECPublicKey toECPublicKey() {
        try {
            SupportedEllipticCurve curve = SupportedEllipticCurve.forName(this.getCurve());
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            ECPoint point = new ECPoint(BigIntegerUtils.base64UrlDecode(this.getX()), BigIntegerUtils.base64UrlDecode(this.getY()));
            return (ECPublicKey)keyFactory.generatePublic(new ECPublicKeySpec(point, curve.getParameters()));
        }
        catch (GeneralSecurityException e) {
            throw new JsonException("Unable to create EC Public Key", e);
        }
    }

    public ECPrivateKey toECPrivateKey() {
        try {
            SupportedEllipticCurve curve = SupportedEllipticCurve.forName(this.getCurve());
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            BigInteger s = BigIntegerUtils.base64UrlDecode(this.getD());
            return (ECPrivateKey)keyFactory.generatePrivate(new ECPrivateKeySpec(s, curve.getParameters()));
        }
        catch (GeneralSecurityException e) {
            throw new JsonException("Unable to create EC Private Key", e);
        }
    }

    public KeyPair toKeyPair() {
        return new KeyPair(this.toECPublicKey(), this.toECPrivateKey());
    }

    public static BigInteger decodeCoordinate(String encodedCoordinate) {
        return BigIntegerUtils.base64UrlDecode(encodedCoordinate);
    }

    public static String encodeCoordinate(int fieldSize, BigInteger coordinate) {
        int bytesToOutput;
        byte[] bigEndian = BigIntegerUtils.toBytesUnsigned(coordinate);
        if (bigEndian.length > (bytesToOutput = (fieldSize + 7) / 8)) {
            throw new IllegalArgumentException("The EC field size can't be smaller than the actual elliptic curve points bits size.");
        }
        if (bigEndian.length == bytesToOutput) {
            return Base64url.encode(bigEndian);
        }
        byte[] bigEndianWithRightFieldSize = new byte[bytesToOutput];
        System.arraycopy(bigEndian, 0, bigEndianWithRightFieldSize, bytesToOutput - bigEndian.length, bigEndian.length);
        return Base64url.encode(bigEndianWithRightFieldSize);
    }

    public boolean isPublicKeyValid() {
        return EcJWK.isPublicKeyValid(this.toECPublicKey(), this.curve);
    }

    public static boolean isPublicKeyValid(ECPublicKey publicKey, SupportedEllipticCurve curve) {
        BigInteger xCubedPlusAXPlusB;
        EllipticCurve curveParams = curve.getParameters().getCurve();
        if (ECPoint.POINT_INFINITY.equals(publicKey.getW())) {
            return false;
        }
        BigInteger x = publicKey.getW().getAffineX();
        BigInteger y = publicKey.getW().getAffineY();
        BigInteger p = ((ECFieldFp)curveParams.getField()).getP();
        if (x.compareTo(BigInteger.ZERO) < 0 || x.compareTo(p) >= 0 || y.compareTo(BigInteger.ZERO) < 0 || y.compareTo(p) >= 0) {
            return false;
        }
        BigInteger a = curveParams.getA();
        BigInteger b = curveParams.getB();
        BigInteger ySquared = y.modPow(TWO, p);
        if (!ySquared.equals(xCubedPlusAXPlusB = x.modPow(THREE, p).add(a.multiply(x)).add(b).mod(p))) {
            return false;
        }
        Reject.rejectStateIfTrue(curve.getParameters().getCofactor() != 1, "Unexpected curve parameters with cofactor != 1. Aborting incomplete public key validation.");
        return true;
    }

    public static final class Builder
    extends JWK.Builder<Builder> {
        private final SupportedEllipticCurve curve;
        private final String x;
        private final String y;
        private String d;

        private Builder(String curve, String x, String y) {
            this(SupportedEllipticCurve.forName(curve), x, y);
        }

        private Builder(SupportedEllipticCurve curve, String x, String y) {
            super(KeyType.EC);
            if (curve == null) {
                throw new IllegalArgumentException("Curve is a required for an EcJWK");
            }
            if (x == null || x.isEmpty()) {
                throw new IllegalArgumentException("X is a required for an EcJWK");
            }
            if (y == null || y.isEmpty()) {
                throw new IllegalArgumentException("Y is a required for an EcJWK");
            }
            this.curve = curve;
            this.x = x;
            this.y = y;
        }

        private Builder(ECPublicKey publicKey) {
            super(KeyType.EC);
            int fieldSize = publicKey.getParams().getCurve().getField().getFieldSize();
            this.curve = SupportedEllipticCurve.forKey(publicKey);
            this.x = EcJWK.encodeCoordinate(fieldSize, publicKey.getW().getAffineX());
            this.y = EcJWK.encodeCoordinate(fieldSize, publicKey.getW().getAffineY());
        }

        public Builder privateKey(ECPrivateKey privateKey) {
            int fieldSize = privateKey.getParams().getCurve().getField().getFieldSize();
            this.d = EcJWK.encodeCoordinate(fieldSize, privateKey.getS());
            return this;
        }

        public Builder d(String d) {
            this.d = d;
            return this;
        }

        public EcJWK build() {
            return new EcJWK(this);
        }
    }
}

