/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe.handlers.encryption;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.forgerock.json.jose.exceptions.JweEncryptionException;
import org.forgerock.json.jose.jwe.EncryptionMethod;
import org.forgerock.json.jose.jwe.JweEncryption;
import org.forgerock.json.jose.jwe.handlers.encryption.AESCBCHMACSHA2ContentEncryptionHandler;
import org.forgerock.json.jose.jwe.handlers.encryption.AESGCMContentEncryptionHandler;
import org.forgerock.json.jose.jwe.handlers.encryption.ChaCha20Poly1305ContentEncryptionHandler;
import org.forgerock.util.Reject;

abstract class ContentEncryptionHandler {
    private static final String INITIALISATION_VECTOR_ALGORITHM = "SHA1PRNG";

    ContentEncryptionHandler() {
    }

    static ContentEncryptionHandler getInstance(EncryptionMethod method) {
        Reject.ifNull((Object)method, "EncryptionMethod cannot be null");
        switch (method) {
            case A128CBC_HS256: 
            case A192CBC_HS384: 
            case A256CBC_HS512: {
                return new AESCBCHMACSHA2ContentEncryptionHandler(method);
            }
            case A128GCM: 
            case A192GCM: 
            case A256GCM: {
                return new AESGCMContentEncryptionHandler(method);
            }
            case CC20_P1305: 
            case XC20_P1305: {
                return new ChaCha20Poly1305ContentEncryptionHandler(method);
            }
        }
        throw new UnsupportedOperationException("Unsupported encryption method: " + (Object)((Object)method));
    }

    abstract JweEncryption encrypt(Key var1, byte[] var2, byte[] var3, byte[] var4);

    abstract byte[] decrypt(Key var1, byte[] var2, JweEncryption var3, byte[] var4);

    abstract Key generateEncryptionKey();

    byte[] generateInitialisationVector() {
        try {
            int ivByteLength = this.getIVByteLength();
            SecureRandom randomGen = SecureRandom.getInstance(INITIALISATION_VECTOR_ALGORITHM);
            byte[] bytes = new byte[ivByteLength];
            randomGen.nextBytes(bytes);
            return bytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw new JweEncryptionException("Unsupported Algorithm, SHA1PRNG", e);
        }
    }

    int getIVByteLength() {
        return 16;
    }
}

