/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe;

import org.forgerock.json.jose.exceptions.JweException;
import org.forgerock.json.jose.jwe.CompressionAlgorithm;
import org.forgerock.json.jose.jwe.handlers.compression.CompressionHandler;
import org.forgerock.json.jose.jwe.handlers.compression.DeflateCompressionHandler;
import org.forgerock.json.jose.jwe.handlers.compression.NOPCompressionHandler;
import org.forgerock.json.jose.utils.Utils;
import org.forgerock.util.encode.Base64url;

public class CompressionManager {
    public CompressionHandler getCompressionHandler(CompressionAlgorithm algorithm) {
        switch (algorithm) {
            case NONE: {
                return new NOPCompressionHandler();
            }
            case DEF: {
                return new DeflateCompressionHandler();
            }
        }
        throw new JweException("No Compression Handler for unknown compression algorithm, " + (Object)((Object)algorithm) + ".");
    }

    public String compress(CompressionAlgorithm compressionAlgorithm, String data) {
        return Base64url.encode(this.getCompressionHandler(compressionAlgorithm).compress(data.getBytes(Utils.CHARSET)));
    }

    public byte[] decompress(CompressionAlgorithm compressionAlgorithm, String data) {
        return this.getCompressionHandler(compressionAlgorithm).decompress(Base64url.decode(data));
    }
}

