/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.util;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.forgerock.http.header.AcceptLanguageHeader;
import org.forgerock.http.header.MalformedHeaderException;
import org.forgerock.http.protocol.Request;
import org.forgerock.util.i18n.LocalizableString;
import org.forgerock.util.i18n.PreferredLocales;

public final class Json {
    private static final ObjectMapper LENIENT_MAPPER = new ObjectMapper().registerModules(new JsonValueModule(), new LocalizableStringModule());
    private static final ObjectMapper STRICT_MAPPER;
    private static final String PREFERRED_LOCALES_ATTRIBUTE = "PreferredLocales";

    private Json() {
    }

    public static void checkJsonCompatibility(String trail, Object value) {
        if (value == null) {
            return;
        }
        Class<?> type = value.getClass();
        List<Object> object = value;
        if (object instanceof Boolean) {
            return;
        }
        if (object instanceof Character) {
            return;
        }
        if (object instanceof Number) {
            return;
        }
        if (object instanceof CharSequence) {
            return;
        }
        if (type.isArray()) {
            object = Arrays.asList((Object[])value);
        }
        if (object instanceof List) {
            List<Object> list = object;
            for (int i = 0; i < list.size(); ++i) {
                Json.checkJsonCompatibility(String.format("%s[%d]", trail, i), list.get(i));
            }
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)((Object)object);
            for (Map.Entry entry : map.entrySet()) {
                Json.checkJsonCompatibility(String.format("%s/%s", trail, entry.getKey()), entry.getValue());
            }
            return;
        }
        throw new IllegalArgumentException(String.format("The object referenced through '%s' cannot be safely serialized as JSON", trail));
    }

    public static Object readJson(String rawData) throws IOException {
        if (rawData == null) {
            return null;
        }
        return Json.readJson(new StringReader(rawData));
    }

    public static Object readJson(Reader reader) throws IOException {
        return Json.parse(STRICT_MAPPER, reader);
    }

    public static Object readJsonLenient(Reader reader) throws IOException {
        return Json.parse(LENIENT_MAPPER, reader);
    }

    public static Object readJsonLenient(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        return LENIENT_MAPPER.readValue(in, Object.class);
    }

    private static Object parse(ObjectMapper mapper, Reader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        return mapper.readValue(reader, Object.class);
    }

    public static byte[] writeJson(Object objectToWrite) throws IOException {
        return STRICT_MAPPER.writeValueAsBytes(objectToWrite);
    }

    public static ObjectWriter makeLocalizingObjectWriter(ObjectMapper mapper, Request request) throws MalformedHeaderException {
        return Json.makeLocalizingObjectWriter(mapper, request.getHeaders().containsKey("Accept-Language") ? request.getHeaders().get(AcceptLanguageHeader.class).getLocales() : null);
    }

    public static ObjectWriter makeLocalizingObjectWriter(ObjectMapper mapper, PreferredLocales locales) {
        ObjectWriter writer = mapper.writer();
        if (locales != null) {
            writer = writer.withAttribute(PREFERRED_LOCALES_ATTRIBUTE, locales);
        }
        return writer;
    }

    static {
        LENIENT_MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        LENIENT_MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        LENIENT_MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        STRICT_MAPPER = new ObjectMapper().registerModules(new JsonValueModule(), new LocalizableStringModule());
    }

    private static abstract class JsonValueMixin {
        private JsonValueMixin() {
        }

        @JsonValue
        public abstract String getObject();
    }

    public static class JsonValueModule
    extends SimpleModule {
        @Override
        public void setupModule(Module.SetupContext context) {
            context.setMixInAnnotations(org.forgerock.json.JsonValue.class, JsonValueMixin.class);
        }
    }

    public static class LocalizableStringModule
    extends SimpleModule {
        private static final PreferredLocales DEFAULT_PREFERRED_LOCALES = new PreferredLocales();

        public LocalizableStringModule() {
            this.addSerializer(LocalizableString.class, new JsonSerializer<LocalizableString>(){

                @Override
                public void serialize(LocalizableString localizableString, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    PreferredLocales locales = (PreferredLocales)serializerProvider.getAttribute(Json.PREFERRED_LOCALES_ATTRIBUTE);
                    if (locales == null) {
                        locales = DEFAULT_PREFERRED_LOCALES;
                    }
                    jsonGenerator.writeString(localizableString.toTranslatedString(locales));
                }
            });
        }
    }
}

