/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.util;

import java.util.HashMap;
import java.util.Map;
import org.forgerock.util.MapDecorator;

public class CaseInsensitiveMap<V>
extends MapDecorator<String, V> {
    private final Map<String, String> lc = new HashMap<String, String>();

    public CaseInsensitiveMap() {
        super(new HashMap());
    }

    public CaseInsensitiveMap(Map<String, V> map) {
        super(map);
        this.sync();
    }

    private Object translate(Object key) {
        String k;
        if (key instanceof String && (k = this.lc.get(((String)key).toLowerCase())) != null) {
            key = k;
        }
        return key;
    }

    public void sync() {
        this.lc.clear();
        for (String key : this.map.keySet()) {
            this.lc.put(key.toLowerCase(), key);
        }
    }

    @Override
    public void clear() {
        this.lc.clear();
        super.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(this.translate(key));
    }

    @Override
    public V put(String key, V value) {
        V removed = this.remove(key);
        this.lc.put(key.toLowerCase(), key);
        super.put(key, value);
        return removed;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        for (String string : m.keySet()) {
            this.put(string, m.get(string));
        }
    }

    @Override
    public V get(Object key) {
        return super.get(this.translate(key));
    }

    @Override
    public V remove(Object key) {
        Object removed = super.remove(this.translate(key));
        if (key instanceof String) {
            this.lc.remove(((String)key).toLowerCase());
        }
        return removed;
    }
}

