/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.forgerock.api.models.Resource;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.util.Reject;

@JsonDeserialize(builder=Builder.class)
public final class Services {
    private final Map<String, Resource> services;

    private Services(Builder builder) {
        this.services = builder.services;
    }

    @JsonValue
    protected Map<String, Resource> getServices() {
        return this.services;
    }

    @JsonIgnore
    public Resource get(String name) {
        return this.services.get(name);
    }

    @JsonIgnore
    public Set<String> getNames() {
        return this.services.keySet();
    }

    public static Builder services() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Services services1 = (Services)o;
        return Objects.equals(this.services, services1.services);
    }

    public int hashCode() {
        return Objects.hash(this.services);
    }

    public static final class Builder {
        private final Map<String, Resource> services = new TreeMap<String, Resource>();

        private Builder() {
        }

        @JsonAnySetter
        public Builder put(String name, Resource resource) {
            if (ValidationUtil.isEmpty(name) || ValidationUtil.containsWhitespace(name)) {
                throw new IllegalArgumentException("Resource name required and may not contain whitespace");
            }
            if (this.services.containsKey(name) && !this.services.get(name).equals(resource)) {
                throw new IllegalStateException("The give Resource name already exists but the Resource objects are not equal");
            }
            this.services.put(name, Reject.checkNotNull(resource));
            return this;
        }

        public Services build() {
            return new Services(this);
        }
    }
}

