/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo;

import com.forgerock.reactive.ServerConnectionFactoryAdapter;
import com.inwebo.CertificateVerificationMode;
import com.inwebo.InWeboProxyLdapManager;
import com.inwebo.InWeboxProxyLdapBackend;
import com.inwebo.StepUpManager;
import com.inwebo.integrations.auth.InWeboRestAuthenticator;
import com.inwebo.integrations.auth.Property;
import com.inwebo.utils.AESCipherUtil;
import io.reactivex.Flowable;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.forgerock.opendj.ldap.AuthenticationException;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.LdapClientContext;
import org.forgerock.opendj.ldap.LdapConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapListener;
import org.forgerock.opendj.ldap.RequestContext;
import org.forgerock.opendj.ldap.RequestHandler;
import org.forgerock.opendj.ldap.RequestHandlerFactory;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.forgerock.opendj.ldap.SslOptions;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.Response;
import org.forgerock.opendj.security.SslContextBuilder;
import org.forgerock.opendj.security.TrustManagers;
import org.forgerock.util.Options;
import org.forgerock.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InWeboProxyLdap {
    private static final String COMMAND_LINE_OPTION_VERBOSE = "verbose";
    private static final String COMMAND_LINE_OPTION_VALIDATE_CONFIG = "validateConfiguration";
    private static final String COMMAND_LINE_OPTION_VALIDATE_CONFIG_PUSH = "doPush";
    private static final String INWEBO_PROXY_PASSWORD = "inwebo.proxy.password";
    private static final String INWEBO_PROXY_USERNAME = "inwebo.proxy.username";
    private static final String INWEBO_PROXY_PORT = "inwebo.proxy.port";
    private static final String INWEBO_PROXY_HOST = "inwebo.proxy.host";
    private static final String INWEBO_PROXY_HTTPS = "inwebo.proxy.https";
    private static final String INWEBO_BASE_URL = "inwebo.base.url";
    private static final String INWEBO_HTTP_TIMEOUT = "inwebo.client.http.timeout";
    private static final String INWEBO_POOL_HTTP_MAX_TOTAL = "inwebo.pool.http.max.total";
    private static final String INWEBO_POOL_HTTP_DEFAULT_MAX_PER_ROUTE = "inwebo.pool.http.default.max.per.route";
    private static final String INWEBO_SERVICE_CERTIFICATE_PASSPHRASE = "inwebo.service.certificate.passphrase";
    private static final String INWEBO_SERVICE_CERTIFICATE_PATH = "inwebo.service.certificate.path";
    private static final String INWEBO_SERVICE_ID = "inwebo.service.id";
    private static final String INWEBO_CIPHER_AES_SECRET_KEY = "inwebo.cipher.aes.secret.key";
    private static final String LDAP_PROXY_WHITELIST_DN = "ldap.proxy.whitelist.dn";
    private static final String LDAP_PROXY_DO_STEP_UP_FILTER_USER_OBJECT_CLASS = "ldap.proxy.do.step.up.filter.user.object.class";
    private static final String LDAP_PROXY_DO_STEP_UP_FILTER_GROUP_OBJECT_CLASS = "ldap.proxy.do.step.up.filter.group.object.class";
    private static final String LDAP_PROXY_DO_STEP_UP_LOOKUP_ISMEMBEROF_ATTRIBUTE = "ldap.proxy.do.step.up.lookup.ismemberof.attribute";
    private static final String LDAP_PROXY_DO_STEP_UP_LOOKUP_MEMBER_ATTRIBUTE = "ldap.proxy.do.step.up.lookup.member.attribute";
    private static final String LDAP_PROXY_DO_STEP_UP_GROUP_BASE_DN = "ldap.proxy.do.step.up.group.base.dn";
    private static final String LDAP_PROXY_DO_STEP_UP_BY_TYPE = "ldap.proxy.do.step.up.by.type";
    private static final String LDAP_PROXY_LOGIN_ATTRIBUTE = "ldap.proxy.login.attribute";
    private static final String LDAP_SSL_PORT = "ldap.ssl.port";
    private static final String LDAP_PORT = "ldap.port";
    private static final String LDAP_HOST = "ldap.host";
    private static final String LDAP_PROXY_ADDRESSES = "ldap.proxy.addresses";
    private static final String LDAP_PROXY_SSL_PORT = "ldap.proxy.ssl.port";
    private static final String LDAP_PROXY_PORT = "ldap.proxy.port";
    private static final String LDAP_PROXY_SSL_CERTIFICATE_PASSPHRASE = "ldap.proxy.ssl.certificate.passphrase";
    private static final String LDAP_PROXY_SSL_CERTIFICATE_PATH = "ldap.proxy.ssl.certificate.path";
    private static final String LDAP_SSL_CERTIFICATE_VERIFICATION_MODE = "ldap.ssl.certificate.verification.mode";
    private static final String LDAP_SSL_CERTIFICATE_KEYSTORE_PATH = "ldap.ssl.certificate.keystore.path";
    private static final String LDAP_SSL_CERTIFICATE_KEYSTORE_PASSPHRASE = "ldap.ssl.certificate.keystore.passphrase";
    private static final String PROXY_CIPHER_PROTOCOL = "proxy.cipher.protocol";
    private static final String LDAP_PROXY_CIPHER_PROTOCOL = "ldap.proxy.cipher.protocol";
    private static final String LDAP_PROXY_CONNECT_TIMEOUT = "ldap.proxy.connect.timeout";
    private static final String LDAP_PROXY_REQUEST_TIMEOUT = "ldap.proxy.request.timeout";
    private static final String LDAP_PROXY_SELECTOR_THREAD_COUNT = "ldap.proxy.selector.thread.count";
    private static final String LDAP_PROXY_HEARTBEAT_ENABLED = "ldap.proxy.heartbeat.enabled";
    private static final String LDAP_PROXY_HEARTBEAT_INTERVAL = "ldap.proxy.heartbeat.interval";
    private static final String LDAP_PROXY_HEARTBEAT_TIMEOUT = "ldap.proxy.heartbeat.timeout";
    private static final String LDAP_PROXY_MAX_SIMULTANEOUS_PUSH = "ldap.proxy.max.simultaneous.push";
    private static final Logger logger = LoggerFactory.getLogger(InWeboProxyLdap.class.getName());
    private Set<InetSocketAddress> localAddresses;
    private Set<InetSocketAddress> sslLocalAddresses;
    private int localPort;
    private int sslLocalPort;
    private boolean isProxyLDAP;
    private boolean isProxyLDAPS;
    private boolean isLDAPS;
    private String remoteAddress;
    private int remotePort;
    private int sslRemotePort;
    private String ldapProxyCertificate;
    private String ldapProxyCertificatePassphrase;
    private String loginAttribute;
    private String aesSecretKey;
    private Long serviceId;
    private InWeboRestAuthenticator iwAuthenticator;
    private String serviceCertificate;
    private String serviceCertificatePassphrase;
    private String inWeboBaseUrl;
    private String inWeboHttpTimeout;
    private String inWeboPoolHttpMaxTotal;
    private String inWeboPoolHttpDefaultMaxPerRoute;
    private String inWeboProxyHost;
    private String inWeboProxyPort;
    private String inWeboProxyUsername;
    private String inWeboProxyHttps;
    private String inWeboProxyPassword;
    private ServerConnectionFactory<LdapClientContext, Integer> connectionHandler;
    private ServerConnectionFactory<LdapClientContext, Integer> sslConnectionHandler;
    private Options listenerOptions;
    private Options sslListenerOptions;
    private String groupBaseDn;
    private StepUpManager.StepUpType stepUpType;
    private String memberAttribute;
    private String isMemberOfAttribute;
    private String groupObjectClass;
    private String userObjectClass;
    private List<String> whiteListDN;
    private CertificateVerificationMode ldapCertificateVerificationMode;
    private String ldapCertificateKeystore;
    private String ldapCertificatePassphrase;
    private LdapListener listener = null;
    private LdapListener sslListener = null;
    private String proxyCipherProtocol;
    private String ldapProxyCipherProtocol;
    private String ldapProxyRequestTimeout;
    private String ldapProxyConnectTimeout;
    private Integer ldapProxySelectorThreadCount;
    private Boolean ldapProxyHeartbeatEnabled;
    private Long ldapProxyHeartbeatInterval;
    private Long ldapProxyHeartbeatTimeout;
    private int maxSimultaneousPush;
    private ThreadPoolExecutor bindWorker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        org.apache.commons.cli.Options options = new org.apache.commons.cli.Options();
        options.addOption(COMMAND_LINE_OPTION_VERBOSE, false, "Log all authentications requests");
        options.addOption(Option.builder(COMMAND_LINE_OPTION_VALIDATE_CONFIG).desc("Verify the proxy configuration by doing a bind request with a specified DN").hasArg(true).numberOfArgs(1).argName("DN").build());
        options.addOption(Option.builder(COMMAND_LINE_OPTION_VALIDATE_CONFIG_PUSH).desc("Verify the inWebo configuration by doing a push authenticate").hasArg(true).numberOfArgs(1).argName("login").build());
        HelpFormatter formatter = new HelpFormatter();
        StringWriter writer = new StringWriter();
        formatter.printHelp(new PrintWriter(writer), 74, "[options] configuration_file_path", "options:", options, 1, 3, "");
        String usage = writer.getBuffer().toString();
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e1) {
            logger.error(usage);
            System.exit(1);
        }
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            System.out.println(cmdArgs.length);
            logger.error(usage);
            System.exit(1);
        }
        String configurationFile = cmdArgs[0];
        boolean verboseMode = cmd.hasOption(COMMAND_LINE_OPTION_VERBOSE);
        boolean verifyPushConfiguration = cmd.hasOption(COMMAND_LINE_OPTION_VALIDATE_CONFIG_PUSH);
        boolean verifyConfiguration = cmd.hasOption(COMMAND_LINE_OPTION_VALIDATE_CONFIG);
        java.util.logging.Logger bind_logger = java.util.logging.Logger.getLogger("BIND_LOGGER");
        if (verboseMode) {
            logger.info("Verbose mode activated");
            bind_logger.setLevel(Level.INFO);
        } else {
            java.util.logging.Logger proxyBackendlogger = java.util.logging.Logger.getLogger(InWeboxProxyLdapBackend.class.getName());
            bind_logger.setLevel(proxyBackendlogger.getLevel());
        }
        InWeboProxyLdap.setDefaultPerfProperties();
        try (InWeboProxyLdap proxy = new InWeboProxyLdap();){
            proxy.readConfiguration(configurationFile);
            proxy.initIWAuthenticator();
            if (verifyPushConfiguration) {
                try {
                    logger.info("Starting push authenticate for {}", (Object)cmd.getOptionValue(COMMAND_LINE_OPTION_VALIDATE_CONFIG_PUSH));
                    proxy.iwAuthenticator.authorizeByPush(cmd.getOptionValue(COMMAND_LINE_OPTION_VALIDATE_CONFIG_PUSH), 60L, TimeUnit.SECONDS);
                    logger.info("Push authenticate done successfully");
                }
                catch (Throwable t) {
                    logger.error("Authentication InWebo failed : Error while processing InWebo process the authorizeByPush : {}", (Object)t.getMessage());
                }
            } else {
                proxy.initProxy();
                proxy.start();
                if (verifyConfiguration) {
                    String dn = cmd.getOptionValues(COMMAND_LINE_OPTION_VALIDATE_CONFIG)[0];
                    Console console = System.console();
                    String password = "*";
                    if (console != null) {
                        password = new String(console.readPassword("Enter password for %s : ", dn));
                    } else {
                        logger.info("Unable to read password, Bind request will failed");
                    }
                    logger.info("Verify configuration with DN : {}", (Object)dn);
                    if (proxy.verifyConfiguration(dn, password)) {
                        logger.info("Verification done successfully");
                    } else {
                        logger.info("The configuration seems incorrect");
                    }
                } else {
                    proxy.waitTermination();
                }
            }
        }
    }

    private void readConfiguration(String configFile) throws Throwable {
        Properties props = null;
        try {
            props = InWeboProxyLdap.loadConfig(configFile);
        }
        catch (Exception e) {
            logger.error("Error while reading configuration file {}", (Object)configFile);
            throw e;
        }
        this.localPort = Integer.parseInt(props.getProperty(LDAP_PROXY_PORT, "0").trim());
        this.sslLocalPort = Integer.parseInt(props.getProperty(LDAP_PROXY_SSL_PORT, "0").trim());
        if (this.localPort == 0 && this.sslLocalPort == 0) {
            throw new Exception(String.format("%s or %s must be specified", LDAP_PROXY_PORT, LDAP_PROXY_SSL_PORT));
        }
        this.isProxyLDAP = this.localPort != 0;
        this.isProxyLDAPS = this.sslLocalPort != 0;
        String hostAddr = props.getProperty(LDAP_PROXY_ADDRESSES);
        this.localAddresses = new HashSet<InetSocketAddress>();
        if (this.isProxyLDAP) {
            if (hostAddr == null) {
                this.localAddresses.add(new InetSocketAddress(this.localPort));
            } else {
                Arrays.asList(hostAddr.split(";")).stream().map(addr -> new InetSocketAddress(addr.trim(), this.localPort)).forEach(inetAddr -> this.localAddresses.add((InetSocketAddress)inetAddr));
            }
        }
        this.sslLocalAddresses = new HashSet<InetSocketAddress>();
        if (this.isProxyLDAPS) {
            if (hostAddr == null) {
                this.sslLocalAddresses.add(new InetSocketAddress(this.sslLocalPort));
            } else {
                Arrays.asList(hostAddr.split(";")).stream().map(addr -> new InetSocketAddress(addr.trim(), this.sslLocalPort)).forEach(inetAddr -> this.sslLocalAddresses.add((InetSocketAddress)inetAddr));
            }
        }
        this.remoteAddress = props.getProperty(LDAP_HOST);
        if (InWeboProxyLdap.isEmpty(this.remoteAddress)) {
            throw new Exception(String.format("%s must be specified", LDAP_HOST));
        }
        this.remotePort = Integer.parseInt(props.getProperty(LDAP_PORT, "0").trim());
        this.sslRemotePort = Integer.parseInt(props.getProperty(LDAP_SSL_PORT, "0").trim());
        if (this.remotePort == 0 && this.sslRemotePort == 0) {
            throw new Exception(String.format("%s or %s must be specified", LDAP_PORT, LDAP_SSL_PORT));
        }
        this.isLDAPS = this.sslRemotePort != 0;
        this.loginAttribute = props.getProperty(LDAP_PROXY_LOGIN_ATTRIBUTE, "uid").trim();
        String stepUpByType = props.getProperty(LDAP_PROXY_DO_STEP_UP_BY_TYPE, "all").trim();
        try {
            this.stepUpType = StepUpManager.StepUpType.valueOf(stepUpByType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new Exception(String.format("%s must be 'user', 'group', 'all' or 'none, current value : %s", LDAP_PROXY_DO_STEP_UP_BY_TYPE, stepUpByType));
        }
        this.groupBaseDn = props.getProperty(LDAP_PROXY_DO_STEP_UP_GROUP_BASE_DN);
        if (InWeboProxyLdap.isEmpty(this.groupBaseDn) && (StepUpManager.StepUpType.GROUP.equals((Object)this.stepUpType) || StepUpManager.StepUpType.USER.equals((Object)this.stepUpType))) {
            throw new Exception(String.format("%s must be specified", LDAP_PROXY_DO_STEP_UP_GROUP_BASE_DN));
        }
        this.memberAttribute = props.getProperty(LDAP_PROXY_DO_STEP_UP_LOOKUP_MEMBER_ATTRIBUTE, "member");
        if (InWeboProxyLdap.isEmpty(this.memberAttribute) && StepUpManager.StepUpType.GROUP.equals((Object)this.stepUpType)) {
            throw new Exception(String.format("%s must be specified", LDAP_PROXY_DO_STEP_UP_LOOKUP_MEMBER_ATTRIBUTE));
        }
        this.isMemberOfAttribute = props.getProperty(LDAP_PROXY_DO_STEP_UP_LOOKUP_ISMEMBEROF_ATTRIBUTE, "isMemberOf");
        if (InWeboProxyLdap.isEmpty(this.isMemberOfAttribute) && StepUpManager.StepUpType.USER.equals((Object)this.stepUpType)) {
            throw new Exception(String.format("%s must be specified", LDAP_PROXY_DO_STEP_UP_LOOKUP_ISMEMBEROF_ATTRIBUTE));
        }
        this.groupObjectClass = props.getProperty(LDAP_PROXY_DO_STEP_UP_FILTER_GROUP_OBJECT_CLASS, "groupOfNames");
        if (InWeboProxyLdap.isEmpty(this.groupObjectClass)) {
            throw new Exception(String.format("%s must be specified", LDAP_PROXY_DO_STEP_UP_FILTER_GROUP_OBJECT_CLASS));
        }
        this.userObjectClass = props.getProperty(LDAP_PROXY_DO_STEP_UP_FILTER_USER_OBJECT_CLASS, "person");
        if (InWeboProxyLdap.isEmpty(this.userObjectClass)) {
            throw new Exception(String.format("%s must be specified", LDAP_PROXY_DO_STEP_UP_FILTER_USER_OBJECT_CLASS));
        }
        this.whiteListDN = new ArrayList<String>();
        Arrays.asList(props.getProperty(LDAP_PROXY_WHITELIST_DN, "").split(";")).stream().map(String::toLowerCase).forEach(dn -> this.whiteListDN.add((String)dn));
        this.aesSecretKey = props.getProperty(INWEBO_CIPHER_AES_SECRET_KEY);
        this.serviceId = Long.valueOf(props.getProperty(INWEBO_SERVICE_ID, "0").trim());
        if (this.serviceId == 0L) {
            throw new Exception(String.format("%s must be specified", INWEBO_SERVICE_ID));
        }
        this.serviceCertificate = props.getProperty(INWEBO_SERVICE_CERTIFICATE_PATH);
        if (InWeboProxyLdap.isEmpty(this.serviceCertificate)) {
            throw new Exception(String.format("%s must be specified", INWEBO_SERVICE_CERTIFICATE_PATH));
        }
        this.serviceCertificatePassphrase = props.getProperty(INWEBO_SERVICE_CERTIFICATE_PASSPHRASE);
        if (InWeboProxyLdap.isEmpty(this.serviceCertificatePassphrase)) {
            throw new Exception(String.format("%s must be specified", INWEBO_SERVICE_CERTIFICATE_PASSPHRASE));
        }
        this.ldapProxyCertificate = props.getProperty(LDAP_PROXY_SSL_CERTIFICATE_PATH);
        this.ldapProxyCertificatePassphrase = props.getProperty(LDAP_PROXY_SSL_CERTIFICATE_PASSPHRASE);
        if (!InWeboProxyLdap.isEmpty(this.ldapProxyCertificate) && InWeboProxyLdap.isEmpty(this.ldapProxyCertificatePassphrase)) {
            throw new Exception(String.format("%s must be specified when %s is", LDAP_PROXY_SSL_CERTIFICATE_PASSPHRASE, LDAP_PROXY_SSL_CERTIFICATE_PATH));
        }
        if (InWeboProxyLdap.isEmpty(this.ldapProxyCertificate)) {
            this.ldapProxyCertificate = this.serviceCertificate;
            this.ldapProxyCertificatePassphrase = this.serviceCertificatePassphrase;
        }
        String mode = props.getProperty(LDAP_SSL_CERTIFICATE_VERIFICATION_MODE, CertificateVerificationMode.NONE.name().toLowerCase());
        try {
            this.ldapCertificateVerificationMode = CertificateVerificationMode.valueOf(mode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new Exception(String.format("%s must be 'jvm', 'keystore' or 'none, current value : %s", LDAP_SSL_CERTIFICATE_VERIFICATION_MODE, mode));
        }
        this.ldapCertificateKeystore = props.getProperty(LDAP_SSL_CERTIFICATE_KEYSTORE_PATH);
        this.ldapCertificatePassphrase = props.getProperty(LDAP_SSL_CERTIFICATE_KEYSTORE_PASSPHRASE);
        if (CertificateVerificationMode.KEYSTORE.equals((Object)this.ldapCertificateVerificationMode) && (InWeboProxyLdap.isEmpty(this.ldapCertificateKeystore) || InWeboProxyLdap.isEmpty(this.ldapCertificatePassphrase))) {
            throw new Exception(String.format("%s must be specified when %s = %s", LDAP_SSL_CERTIFICATE_KEYSTORE_PATH, LDAP_SSL_CERTIFICATE_VERIFICATION_MODE, CertificateVerificationMode.KEYSTORE.name().toLowerCase()));
        }
        this.maxSimultaneousPush = Integer.parseInt(props.getProperty(LDAP_PROXY_MAX_SIMULTANEOUS_PUSH, "100").trim());
        if (this.maxSimultaneousPush < 1) {
            throw new Exception(String.format("%s must be gretter or equals to 1, current value : %d\"", LDAP_PROXY_MAX_SIMULTANEOUS_PUSH, this.maxSimultaneousPush));
        }
        this.inWeboBaseUrl = props.getProperty(INWEBO_BASE_URL);
        this.inWeboHttpTimeout = props.getProperty(INWEBO_HTTP_TIMEOUT);
        this.inWeboPoolHttpMaxTotal = props.getProperty(INWEBO_POOL_HTTP_MAX_TOTAL);
        this.inWeboPoolHttpDefaultMaxPerRoute = props.getProperty(INWEBO_POOL_HTTP_DEFAULT_MAX_PER_ROUTE);
        this.inWeboProxyHttps = props.getProperty(INWEBO_PROXY_HTTPS);
        this.inWeboProxyHost = props.getProperty(INWEBO_PROXY_HOST);
        this.inWeboProxyPort = props.getProperty(INWEBO_PROXY_PORT);
        this.inWeboProxyUsername = props.getProperty(INWEBO_PROXY_USERNAME);
        this.inWeboProxyPassword = props.getProperty(INWEBO_PROXY_PASSWORD);
        String defaultLDAPProxyCipherProtocol = "TLS";
        this.ldapProxyCipherProtocol = props.getProperty(LDAP_PROXY_CIPHER_PROTOCOL, defaultLDAPProxyCipherProtocol);
        if (InWeboProxyLdap.isEmpty(this.ldapProxyCipherProtocol)) {
            this.ldapProxyCipherProtocol = defaultLDAPProxyCipherProtocol;
        }
        logger.info(String.format("Using %s for the connection to the proxy", this.ldapProxyCipherProtocol));
        String defaultProxyCipherProtocol = "TLSv1";
        this.proxyCipherProtocol = props.getProperty(PROXY_CIPHER_PROTOCOL, defaultProxyCipherProtocol);
        if (InWeboProxyLdap.isEmpty(this.proxyCipherProtocol)) {
            this.proxyCipherProtocol = defaultProxyCipherProtocol;
        }
        logger.info(String.format("Using %s for the final LDAP connection", this.proxyCipherProtocol));
        this.ldapProxyRequestTimeout = props.getProperty(LDAP_PROXY_REQUEST_TIMEOUT, "0");
        this.ldapProxyConnectTimeout = props.getProperty(LDAP_PROXY_CONNECT_TIMEOUT, "10000");
        if (props.getProperty(LDAP_PROXY_SELECTOR_THREAD_COUNT) != null) {
            this.ldapProxySelectorThreadCount = Integer.valueOf(props.getProperty(LDAP_PROXY_SELECTOR_THREAD_COUNT).trim());
        }
        this.ldapProxyHeartbeatEnabled = Boolean.parseBoolean(props.getProperty(LDAP_PROXY_HEARTBEAT_ENABLED, "false"));
        this.ldapProxyHeartbeatInterval = Long.valueOf(props.getProperty(LDAP_PROXY_HEARTBEAT_INTERVAL, "10000"));
        this.ldapProxyHeartbeatTimeout = Long.valueOf(props.getProperty(LDAP_PROXY_HEARTBEAT_TIMEOUT, "3000"));
    }

    private static Properties loadConfig(String configFile) throws Exception {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(configFile, new String[0]), new OpenOption[0]), Charset.forName("UTF-8")));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line.replace("\\", "\\\\")).append(System.getProperty("line.separator"));
            }
            Properties props = new Properties();
            props.load(new StringReader(sb.toString()));
            Properties properties = props;
            return properties;
        }
    }

    private void initIWAuthenticator() throws Throwable {
        Properties iwProperties = new Properties();
        iwProperties.setProperty(Property.CERTIFICATE_PASSWORD.key(), this.serviceCertificatePassphrase);
        iwProperties.setProperty(Property.CERTIFICATE_PATH.key(), this.serviceCertificate);
        iwProperties.setProperty(Property.SERVICE_ID.key(), String.valueOf(this.serviceId));
        if (this.inWeboBaseUrl != null) {
            iwProperties.setProperty(Property.BASE_URL.key(), this.inWeboBaseUrl);
        }
        if (this.inWeboHttpTimeout != null) {
            iwProperties.setProperty(Property.CLIENT_HTTP_TIMEOUT.key(), this.inWeboHttpTimeout);
        }
        if (this.inWeboPoolHttpMaxTotal != null) {
            iwProperties.setProperty(Property.POOL_HTTP_MAX_TOTAL.key(), this.inWeboPoolHttpMaxTotal);
        }
        if (this.inWeboPoolHttpDefaultMaxPerRoute != null) {
            iwProperties.setProperty(Property.POOL_HTTP_DEFAULT_MAX_PER_ROUTE.key(), this.inWeboPoolHttpDefaultMaxPerRoute);
        }
        if (this.inWeboProxyHttps != null) {
            iwProperties.setProperty(Property.PROXY_HTTPS.key(), this.inWeboProxyHttps);
        }
        if (this.inWeboProxyHost != null) {
            iwProperties.setProperty(Property.PROXY_HOST.key(), this.inWeboProxyHost);
        }
        if (this.inWeboProxyPort != null) {
            iwProperties.setProperty(Property.PROXY_PORT.key(), this.inWeboProxyPort);
        }
        if (this.inWeboProxyUsername != null) {
            iwProperties.setProperty(Property.PROXY_USER.key(), this.inWeboProxyUsername);
        }
        if (this.inWeboProxyPassword != null) {
            iwProperties.setProperty(Property.PROXY_PASSWORD.key(), this.inWeboProxyPassword);
        }
        try {
            this.iwAuthenticator = new InWeboRestAuthenticator(iwProperties);
        }
        catch (Exception e) {
            logger.error("Unable to initialize the InWebo client : {}", (Object)e.getMessage());
            throw e;
        }
    }

    private void initProxy() throws Throwable {
        InWeboProxyLdapManagerImpl proxyManager = new InWeboProxyLdapManagerImpl(this.iwAuthenticator, this.aesSecretKey, this.whiteListDN);
        TrustManager trustManager = this.isLDAPS ? InWeboProxyLdap.getTrustManager(this.ldapCertificateVerificationMode, this.remoteAddress, this.ldapCertificateKeystore, this.ldapCertificatePassphrase) : null;
        this.bindWorker = new ThreadPoolExecutor(this.maxSimultaneousPush / 2, this.maxSimultaneousPush, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.bindWorker.setRejectedExecutionHandler((r, executor) -> {
            logger.info("No worker available, the maximum simultaneous push is {}, Change {} property value if needed", (Object)this.maxSimultaneousPush, (Object)LDAP_PROXY_MAX_SIMULTANEOUS_PUSH);
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("Producer interrupted", e);
            }
        });
        if (this.isProxyLDAP) {
            try {
                this.connectionHandler = InWeboProxyLdap.buildServerConnectionFactory(this.isLDAPS, trustManager, this.remoteAddress, this.isLDAPS ? this.sslRemotePort : this.remotePort, proxyManager, this.proxyCipherProtocol, this.ldapProxyRequestTimeout, this.ldapProxyConnectTimeout, this.ldapProxyHeartbeatEnabled, this.ldapProxyHeartbeatInterval, this.ldapProxyHeartbeatTimeout, this.bindWorker);
            }
            catch (GeneralSecurityException e) {
                logger.error("Error while initializing the LDAP connection factory configuration for {}:{}", (Object)this.remoteAddress, (Object)(this.isLDAPS ? this.sslRemotePort : this.remotePort));
                throw e;
            }
            this.listenerOptions = Options.defaultOptions().set(LdapListener.CONNECT_MAX_BACKLOG, 4096);
            if (this.ldapProxySelectorThreadCount != null) {
                this.listenerOptions = this.listenerOptions.set(LdapListener.SELECTOR_THREAD_COUNT, this.ldapProxySelectorThreadCount);
            }
        }
        if (this.isProxyLDAPS) {
            try {
                this.sslConnectionHandler = InWeboProxyLdap.buildServerConnectionFactory(this.isLDAPS, trustManager, this.remoteAddress, this.isLDAPS ? this.sslRemotePort : this.remotePort, proxyManager, this.proxyCipherProtocol, this.ldapProxyRequestTimeout, this.ldapProxyConnectTimeout, this.ldapProxyHeartbeatEnabled, this.ldapProxyHeartbeatInterval, this.ldapProxyHeartbeatTimeout, this.bindWorker);
            }
            catch (GeneralSecurityException e) {
                logger.error("Error while initializing the LDAPS connection factory configuration for {}:{}", (Object)this.remoteAddress, (Object)(this.isLDAPS ? this.sslRemotePort : this.remotePort));
                throw e;
            }
            try {
                this.sslListenerOptions = Options.defaultOptions().set(LdapListener.CONNECT_MAX_BACKLOG, 4096);
                if (this.ldapProxySelectorThreadCount != null) {
                    this.sslListenerOptions = this.sslListenerOptions.set(LdapListener.SELECTOR_THREAD_COUNT, this.ldapProxySelectorThreadCount);
                }
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                try (FileInputStream keyInput = new FileInputStream(this.ldapProxyCertificate);){
                    keyStore.load(keyInput, this.ldapProxyCertificatePassphrase.toCharArray());
                    keyManagerFactory.init(keyStore, this.ldapProxyCertificatePassphrase.toCharArray());
                    SSLContext sslContext = SSLContext.getInstance(this.ldapProxyCipherProtocol);
                    sslContext.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
                    SslOptions sslOptions = SslOptions.newDefaultSslOptions();
                    sslOptions.setSslContext(sslContext);
                    this.sslListenerOptions.set(LdapListener.SSL_OPTIONS, sslOptions);
                }
                catch (FileNotFoundException e) {
                    logger.error("Certificate file {} doesn't exists", (Object)this.ldapProxyCertificate);
                    throw e;
                }
                catch (IOException e) {
                    logger.error("Error while reading certificate file {}", (Object)this.ldapProxyCertificate);
                    throw e;
                }
                catch (KeyManagementException | UnrecoverableKeyException | CertificateException e) {
                    logger.error("Error while loading certificate file {}", (Object)this.ldapProxyCertificate);
                    throw e;
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                logger.error("Error while initializing SSL engine");
                throw e;
            }
        }
    }

    private void start() throws Throwable {
        try {
            if (this.isProxyLDAP) {
                this.listener = new LdapListener(this.localAddresses, (Function<LdapClientContext, BiFunction<Integer, Request, Flowable<Response>>>)new ServerConnectionFactoryAdapter(this.connectionHandler), this.listenerOptions);
            }
            if (this.isProxyLDAPS) {
                this.sslListener = new LdapListener(this.sslLocalAddresses, (Function<LdapClientContext, BiFunction<Integer, Request, Flowable<Response>>>)new ServerConnectionFactoryAdapter(this.sslConnectionHandler), this.sslListenerOptions);
            }
            logger.info("Proxy LDAP is up :");
            if (this.isProxyLDAP) {
                this.listener.getSocketAddresses().stream().forEach(a -> logger.info("\tForwarding all LDAP requets received on {}:{} to {}:{}", a.getHostName(), a.getPort(), this.remoteAddress, this.isLDAPS ? this.sslRemotePort : this.remotePort));
            }
            if (this.isProxyLDAPS) {
                this.sslListener.getSocketAddresses().stream().forEach(a -> logger.info("\tForwarding all LDAPS requets received on {}:{} to {}:{}", a.getHostName(), a.getPort(), this.remoteAddress, this.isLDAPS ? this.sslRemotePort : this.remotePort));
            }
            logger.info("The service {} is associated with the certificate {}", (Object)this.serviceId, (Object)this.serviceCertificate);
            switch (this.stepUpType) {
                case ALL: {
                    logger.info("All bindRequest will be associated with an InWebo authentication");
                    break;
                }
                case NONE: {
                    logger.info("No InWebo authentication are configured");
                    break;
                }
                case GROUP: {
                    logger.info("All bindRequest for users members of {} group will be associated with an InWebo authentication", (Object)this.groupBaseDn);
                    break;
                }
                case USER: {
                    logger.info("All bindRequest for users members of {} group will be associated with an InWebo authentication", (Object)this.groupBaseDn);
                }
            }
        }
        catch (IOException e) {
            logger.error("Error listening on :" + this.localPort, e);
            throw e;
        }
    }

    private void waitTermination() {
        try {
            File lockFile = new File("./proxy_ldap.lock");
            if (!lockFile.createNewFile()) {
                logger.info("proxy_ldap.lock alreaydy exists");
            }
            while (lockFile.exists()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException e) {
            logger.error("Error while creating lock file", e);
        }
        this.bindWorker.shutdown();
    }

    private void close() {
        logger.info("Proxy LDAP is shutting down ...");
        if (this.listener != null) {
            this.listener.close();
        }
        if (this.sslListener != null) {
            this.sslListener.close();
        }
        logger.info("Proxy LDAP is down");
    }

    private boolean verifyConfiguration(String dn, String password) throws GeneralSecurityException {
        Throwable throwable;
        Connection connection;
        boolean res = true;
        LdapConnectionFactory factory = null;
        LdapConnectionFactory sslFactory = null;
        if (this.isProxyLDAP) {
            factory = new LdapConnectionFactory(((InetSocketAddress)this.localAddresses.stream().findFirst().get()).getHostName(), this.localPort);
        }
        if (this.isProxyLDAPS) {
            Options options = Options.defaultOptions();
            SSLContext sslContext = new SslContextBuilder().protocol(this.proxyCipherProtocol).trustManager(TrustManagers.trustAll()).build();
            options.set(LdapConnectionFactory.SSL_OPTIONS, SslOptions.newSslOptions(sslContext));
            options.set(LdapConnectionFactory.SSL_USE_STARTTLS, false);
            sslFactory = new LdapConnectionFactory(((InetSocketAddress)this.sslLocalAddresses.stream().findFirst().get()).getHostName(), this.sslLocalPort, options);
        }
        if (factory != null) {
            try {
                connection = factory.getConnection();
                throwable = null;
                try {
                    connection.bind(dn, password.toCharArray());
                    res &= true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (connection != null) {
                        if (throwable != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            connection.close();
                        }
                    }
                }
            }
            catch (AuthenticationException t) {
                res &= true;
            }
            catch (Throwable t) {
                res = false;
                logger.error("Error while sending a LDAP bind request", t);
            }
        }
        if (sslFactory != null) {
            try {
                connection = sslFactory.getConnection();
                throwable = null;
                try {
                    BindResult bindRes = connection.bind(dn, password.toCharArray());
                    res &= true;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (connection != null) {
                        if (throwable != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            connection.close();
                        }
                    }
                }
            }
            catch (AuthenticationException t) {
                res &= true;
            }
            catch (Throwable t) {
                res = false;
                logger.error("Error while sending a LDAPS bind request", t);
            }
        }
        return res;
    }

    private static boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().equals("");
    }

    private InWeboProxyLdap() {
    }

    private static TrustManager getTrustManager(CertificateVerificationMode ldapCertificateVerificationMode, String hostname, String keystore, String storepass) throws GeneralSecurityException, IOException {
        if (CertificateVerificationMode.NONE.equals((Object)ldapCertificateVerificationMode)) {
            return TrustManagers.trustAll();
        }
        if (CertificateVerificationMode.KEYSTORE.equals((Object)ldapCertificateVerificationMode)) {
            try {
                return TrustManagers.checkValidityDates(TrustManagers.checkHostName(hostname, TrustManagers.checkUsingTrustStore(keystore, storepass.toCharArray(), null)));
            }
            catch (IOException | GeneralSecurityException e) {
                logger.error("Error while loading keystore file {}", (Object)keystore);
                throw e;
            }
        }
        return null;
    }

    private static ServerConnectionFactory<LdapClientContext, Integer> buildServerConnectionFactory(boolean isSSL, TrustManager trustManager, String remoteAddress, int remotePort, final InWeboProxyLdapManager proxyManager, String protocol, String requestTimeOut, String connectTimeOut, Boolean heartbeatEnabled, Long heartbeatInterval, Long heartbeatTimeout, final ThreadPoolExecutor bindWorker) throws GeneralSecurityException {
        Options connectionFactoryOptions = Options.defaultOptions().set(LdapConnectionFactory.HEARTBEAT_ENABLED, heartbeatEnabled).set(LdapConnectionFactory.HEARTBEAT_INTERVAL, Duration.duration(heartbeatInterval, TimeUnit.MILLISECONDS)).set(LdapConnectionFactory.HEARTBEAT_TIMEOUT, Duration.duration(heartbeatTimeout, TimeUnit.MILLISECONDS)).set(LdapConnectionFactory.REQUEST_TIMEOUT, Duration.duration(Long.parseLong(requestTimeOut), TimeUnit.MILLISECONDS)).set(LdapConnectionFactory.CONNECT_TIMEOUT, Duration.duration(Long.parseLong(connectTimeOut), TimeUnit.MILLISECONDS));
        if (isSSL) {
            SSLContext sslContext = new SslContextBuilder().protocol(protocol).trustManager(trustManager).build();
            connectionFactoryOptions.set(LdapConnectionFactory.SSL_OPTIONS, SslOptions.newSslOptions(sslContext));
            connectionFactoryOptions.set(LdapConnectionFactory.SSL_USE_STARTTLS, false);
        }
        final LdapConnectionFactory remoteConnectionFactory = new LdapConnectionFactory(remoteAddress, remotePort, connectionFactoryOptions);
        RequestHandlerFactory<LdapClientContext, RequestContext> proxyFactory = new RequestHandlerFactory<LdapClientContext, RequestContext>(){

            @Override
            public RequestHandler<RequestContext> handleAccept(LdapClientContext clientContext) throws LdapException {
                try {
                    InWeboxProxyLdapBackend proxyBackend = new InWeboxProxyLdapBackend(remoteConnectionFactory, proxyManager, bindWorker);
                    clientContext.addListener(proxyBackend);
                    return proxyBackend;
                }
                catch (Exception e) {
                    throw LdapException.newLdapException(ResultCode.OTHER, e);
                }
            }
        };
        return Connections.newServerConnectionFactory(proxyFactory);
    }

    private static void setDefaultPerfProperties() {
        if (System.getProperty("org.forgerock.opendj.transport.useWorkerThreads") == null) {
            System.setProperty("org.forgerock.opendj.transport.useWorkerThreads", "false");
        }
    }

    private final class InWeboProxyLdapManagerImpl
    implements InWeboProxyLdapManager {
        private InWeboRestAuthenticator iwAuthenticator = null;
        private AESCipherUtil cipher;
        private List<String> whitelistDN;

        InWeboProxyLdapManagerImpl(InWeboRestAuthenticator iwAuthenticator, String aesSecretKey, List<String> whitelistDN) {
            this.iwAuthenticator = iwAuthenticator;
            this.cipher = aesSecretKey != null ? new AESCipherUtil(aesSecretKey) : null;
            this.whitelistDN = whitelistDN;
        }

        @Override
        public boolean doStepUp(String userDn, StepUpManager stepUpManager) throws Exception {
            return stepUpManager.doStepUp(userDn, InWeboProxyLdap.this.groupBaseDn, InWeboProxyLdap.this.stepUpType, InWeboProxyLdap.this.memberAttribute, InWeboProxyLdap.this.isMemberOfAttribute, InWeboProxyLdap.this.groupObjectClass, InWeboProxyLdap.this.userObjectClass);
        }

        @Override
        public InWeboRestAuthenticator getInWeboRestAuthenticator() {
            return this.iwAuthenticator;
        }

        @Override
        public String getInWeboLoginAttribute() {
            return InWeboProxyLdap.this.loginAttribute;
        }

        @Override
        public String cipherLogin(String login) {
            if (this.cipher != null) {
                return this.cipher.encrypt(login);
            }
            return login;
        }

        @Override
        public boolean isWhitelistedDN(String dn) {
            return this.whitelistDN.contains(dn.toLowerCase());
        }
    }
}

