/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import org.forgerock.util.Reject;

public class SubstringReader {
    private final String source;
    private int pos;
    private int mark;
    private final int length;

    public SubstringReader(String s) {
        Reject.ifNull(s);
        this.source = s;
        this.length = s.length();
        this.pos = 0;
        this.mark = 0;
    }

    public String getString() {
        return this.source;
    }

    public void mark() {
        this.mark = this.pos;
    }

    public int pos() {
        return this.pos;
    }

    public char read() {
        if (this.pos >= this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        return this.source.charAt(this.pos++);
    }

    public String read(int length) {
        if (length > this.length || this.pos + length > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        String substring = this.source.substring(this.pos, this.pos + length);
        this.pos += length;
        return substring;
    }

    public int remaining() {
        return this.length - this.pos;
    }

    public void reset() {
        this.pos = this.mark;
    }

    public int skipWhitespaces() {
        int skipped = 0;
        while (this.pos < this.length && this.source.charAt(this.pos) == ' ') {
            ++skipped;
            ++this.pos;
        }
        return skipped;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "source=" + this.source + ", remaining=" + this.source.substring(this.pos, this.length) + ")";
    }
}

