/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.i18n;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.MissingResourceException;
import java.util.Objects;
import org.forgerock.util.i18n.PreferredLocales;

public class LocalizableString {
    public static final String TRANSLATION_KEY_PREFIX = "i18n:";
    private final ClassLoader loader;
    private final String value;
    private final URI resource;
    private final LocalizableString defaultValue;

    public LocalizableString(String value) {
        this(value, (ClassLoader)null);
    }

    public LocalizableString(String value, Class<?> type) {
        this(value.replace(":#", ":" + type.getName().replace(".", "/") + "#"), type.getClassLoader());
    }

    public LocalizableString(String value, ClassLoader loader) {
        this(value, loader, null);
    }

    public LocalizableString(String key, ClassLoader loader, LocalizableString defaultValue) {
        this.loader = loader;
        this.value = key;
        this.defaultValue = defaultValue;
        URI resource = null;
        if (this.value != null && this.value.startsWith(TRANSLATION_KEY_PREFIX) && loader != null) {
            try {
                resource = new URI(this.value);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        this.resource = resource;
    }

    public String toTranslatedString(PreferredLocales locales) {
        if (this.resource == null) {
            return this.value;
        }
        try {
            return locales.getBundleInPreferredLocale(this.resource.getSchemeSpecificPart(), this.loader).getString(this.resource.getFragment());
        }
        catch (MissingResourceException e) {
            return this.defaultValue == null ? this.resource.getFragment() : this.defaultValue.toTranslatedString(locales);
        }
    }

    public String toString() {
        return this.defaultValue == null ? this.value : "[" + this.value + "], default [" + this.defaultValue + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalizableString that = (LocalizableString)o;
        return this.value.equals(that.value) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.defaultValue);
    }
}

