/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.services.context;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.forgerock.json.JsonValue;
import org.forgerock.services.context.AbstractContext;
import org.forgerock.services.context.Context;
import org.forgerock.util.encode.Base64;

public final class ClientContext
extends AbstractContext {
    private static final String ATTR_REMOTE_USER = "remoteUser";
    private static final String ATTR_REMOTE_ADDRESS = "remoteAddress";
    private static final String ATTR_REMOTE_PORT = "remotePort";
    private static final String ATTR_CERTIFICATES = "certificates";
    private static final String ATTR_USER_AGENT = "userAgent";
    private static final String ATTR_IS_SECURE = "isSecure";
    private static final String ATTR_IS_EXTERNAL = "isExternal";
    private static final String X509_TYPE = "X.509";
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private static final String ATTR_LOCAL_ADDRESS = "localAddress";
    private static final String ATTR_LOCAL_PORT = "localPort";
    private final Collection<? extends Certificate> certificates;

    public static Builder buildExternalClientContext(Context parent) {
        return new Builder(parent);
    }

    public static ClientContext newInternalClientContext(Context parent) {
        return new ClientContext(parent, "", "", -1, Collections.emptyList(), "", false, true, "", -1);
    }

    public ClientContext(JsonValue savedContext, ClassLoader classLoader) {
        super(savedContext, classLoader);
        try {
            this.certificates = Collections.unmodifiableCollection(CertificateFactory.getInstance(X509_TYPE).generateCertificates(new ByteArrayInputStream(this.data.get(ATTR_CERTIFICATES).asString().getBytes("UTF8"))));
        }
        catch (UnsupportedEncodingException | CertificateException e) {
            throw new IllegalStateException("Unable to deserialize certificates", e);
        }
    }

    private ClientContext(Context parent, String remoteUser, String remoteAddress, int remotePort, List<? extends Certificate> certificates, String userAgent, boolean isExternal, boolean isSecure, String localAddress, int localPort) {
        super(parent, "client");
        this.certificates = certificates;
        this.data.put(ATTR_REMOTE_USER, (Object)remoteUser);
        this.data.put(ATTR_REMOTE_ADDRESS, (Object)remoteAddress);
        this.data.put(ATTR_REMOTE_PORT, (Object)remotePort);
        this.data.put(ATTR_CERTIFICATES, (Object)this.serializeCertificates(certificates));
        this.data.put(ATTR_USER_AGENT, (Object)userAgent);
        this.data.put(ATTR_IS_EXTERNAL, (Object)isExternal);
        this.data.put(ATTR_IS_SECURE, (Object)isSecure);
        this.data.put(ATTR_LOCAL_ADDRESS, (Object)localAddress);
        this.data.put(ATTR_LOCAL_PORT, (Object)localPort);
    }

    private String serializeCertificates(List<? extends Certificate> certificates) {
        StringBuilder builder = new StringBuilder();
        for (Certificate certificate : certificates) {
            try {
                builder.append(BEGIN_CERTIFICATE).append(Base64.encode(certificate.getEncoded())).append(END_CERTIFICATE);
            }
            catch (CertificateEncodingException e) {
                throw new IllegalStateException("Unable to serialize certificates", e);
            }
        }
        return builder.toString();
    }

    public String getRemoteUser() {
        return this.data.get(ATTR_REMOTE_USER).asString();
    }

    public String getRemoteAddress() {
        return this.data.get(ATTR_REMOTE_ADDRESS).asString();
    }

    public int getRemotePort() {
        return this.data.get(ATTR_REMOTE_PORT).asInteger();
    }

    public Collection<? extends Certificate> getCertificates() {
        return this.certificates;
    }

    public String getUserAgent() {
        return this.data.get(ATTR_USER_AGENT).asString();
    }

    public boolean isExternal() {
        return this.data.get(ATTR_IS_EXTERNAL).asBoolean();
    }

    public boolean isSecure() {
        return this.data.get(ATTR_IS_SECURE).asBoolean();
    }

    public String getLocalAddress() {
        return this.data.get(ATTR_LOCAL_ADDRESS).asString();
    }

    public int getLocalPort() {
        return this.data.get(ATTR_LOCAL_PORT).asInteger();
    }

    public static final class Builder {
        private final Context parent;
        private String remoteUser = "";
        private String remoteAddress = "";
        private int remotePort = -1;
        private List<? extends Certificate> certificates = Collections.emptyList();
        private String userAgent = "";
        private boolean isSecure;
        private String localAddress = "";
        private int localPort = -1;

        private Builder(Context parent) {
            this.parent = parent;
        }

        public Builder remoteUser(String remoteUser) {
            this.remoteUser = remoteUser;
            return this;
        }

        public Builder remoteAddress(String remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }

        public Builder remotePort(int remotePort) {
            this.remotePort = remotePort;
            return this;
        }

        public Builder certificates(Certificate ... certificates) {
            if (certificates != null) {
                return this.certificates(Arrays.asList(certificates));
            }
            return this.certificates(Collections.emptyList());
        }

        public Builder certificates(List<Certificate> certificates) {
            this.certificates = certificates;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder secure(boolean isSecure) {
            this.isSecure = isSecure;
            return this;
        }

        public Builder localAddress(String localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public Builder localPort(int localPort) {
            this.localPort = localPort;
            return this;
        }

        public ClientContext build() {
            if (this.certificates == null) {
                this.certificates = Collections.emptyList();
            }
            return new ClientContext(this.parent, this.remoteUser, this.remoteAddress, this.remotePort, this.certificates, this.userAgent, true, this.isSecure, this.localAddress, this.localPort);
        }
    }
}

