/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.http.oauth2.AccessTokenException;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Status;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.rest2ldap.Rest2Ldap;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

final class Utils {
    private static final AsyncFunction<LdapException, Response, NeverThrowsException> HANDLE_CONNECTION_FAILURE = new AsyncFunction<LdapException, Response, NeverThrowsException>(){

        @Override
        public Promise<Response, NeverThrowsException> apply(LdapException exception) {
            return Utils.asErrorResponse(exception);
        }
    };

    private Utils() {
    }

    static IllegalArgumentException newIllegalArgumentException(LocalizableMessage message) {
        return new IllegalArgumentException(message.toString());
    }

    static AccessTokenException newAccessTokenException(LocalizableMessage message) {
        return Utils.newAccessTokenException(message, null);
    }

    static AccessTokenException newAccessTokenException(LocalizableMessage message, Exception cause) {
        return new AccessTokenException(message.toString(), cause);
    }

    static Runnable close(final AtomicReference<? extends Closeable> holder) {
        return new Runnable(){

            @Override
            public void run() {
                org.forgerock.util.Utils.closeSilently((Closeable)holder.get());
            }
        };
    }

    static AsyncFunction<LdapException, Response, NeverThrowsException> handleConnectionFailure() {
        return HANDLE_CONNECTION_FAILURE;
    }

    static Promise<Response, NeverThrowsException> asErrorResponse(Throwable t) {
        ResourceException e = Rest2Ldap.asResourceException(t);
        Response response = new Response(Status.valueOf(e.getCode())).setEntity(e.toJsonValue().getObject());
        if (response.getStatus() == Status.UNAUTHORIZED) {
            response.getHeaders().put("WWW-Authenticate", (Object)"Basic");
        }
        return Promises.newResultPromise(response);
    }
}

