/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.Rdn;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaValidationPolicy;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.opendj.ldif.AbstractLdifReader;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ChangeRecordReader;
import org.forgerock.opendj.ldif.RejectedLdifListener;
import org.forgerock.util.Reject;

public final class LdifChangeRecordReader
extends AbstractLdifReader
implements ChangeRecordReader {
    private static final Pattern CONTROL_REGEX = Pattern.compile("^\\s*(\\d+(.\\d+)*)(\\s+((true)|(false)))?\\s*(:(:)?\\s*?\\S+)?\\s*$");
    private static final ChangeRecord EOF = Requests.newAddRequest(Dn.rootDn());
    private ChangeRecord nextChangeRecord;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ChangeRecord valueOfLdifChangeRecord(String ... ldifLines) {
        try (LdifChangeRecordReader reader = new LdifChangeRecordReader(ldifLines);){
            if (!reader.hasNext()) {
                LocalizableMessage message = CoreMessages.WARN_READ_LDIF_RECORD_NO_CHANGE_RECORD_FOUND.get();
                throw new LocalizedIllegalArgumentException(message);
            }
            ChangeRecord record = reader.readChangeRecord();
            if (reader.hasNext()) {
                LocalizableMessage message = CoreMessages.WARN_READ_LDIF_RECORD_MULTIPLE_CHANGE_RECORDS_FOUND.get();
                throw new LocalizedIllegalArgumentException(message);
            }
            ChangeRecord changeRecord = record;
            return changeRecord;
        }
        catch (DecodeException e) {
            throw new LocalizedIllegalArgumentException(e.getMessageObject());
        }
        catch (IOException e) {
            LocalizableMessage message = CoreMessages.WARN_READ_LDIF_RECORD_UNEXPECTED_IO_ERROR.get(e.getMessage());
            throw new LocalizedIllegalArgumentException(message);
        }
    }

    public LdifChangeRecordReader(InputStream in) {
        super(in);
    }

    public LdifChangeRecordReader(List<String> ldifLines) {
        super(ldifLines);
    }

    public LdifChangeRecordReader(Reader reader) {
        super(reader);
    }

    public LdifChangeRecordReader(String ... ldifLines) {
        super(Arrays.asList(ldifLines));
    }

    @Override
    public void close() throws IOException {
        this.close0();
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.getNextChangeRecord() != EOF;
    }

    @Override
    public ChangeRecord readChangeRecord() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ChangeRecord changeRecord = this.nextChangeRecord;
        this.nextChangeRecord = null;
        return changeRecord;
    }

    public LdifChangeRecordReader setExcludeAllOperationalAttributes(boolean excludeOperationalAttributes) {
        this.excludeOperationalAttributes = excludeOperationalAttributes;
        return this;
    }

    public LdifChangeRecordReader setExcludeAllUserAttributes(boolean excludeUserAttributes) {
        this.excludeUserAttributes = excludeUserAttributes;
        return this;
    }

    public LdifChangeRecordReader setExcludeAttribute(AttributeDescription attributeDescription) {
        Reject.ifNull(attributeDescription);
        this.excludeAttributes.add(attributeDescription);
        return this;
    }

    public LdifChangeRecordReader setExcludeBranch(Dn excludeBranch) {
        Reject.ifNull(excludeBranch);
        this.excludeBranches.add(excludeBranch);
        return this;
    }

    public LdifChangeRecordReader setIncludeAttribute(AttributeDescription attributeDescription) {
        Reject.ifNull(attributeDescription);
        this.includeAttributes.add(attributeDescription);
        return this;
    }

    public LdifChangeRecordReader setIncludeBranch(Dn includeBranch) {
        Reject.ifNull(includeBranch);
        this.includeBranches.add(includeBranch);
        return this;
    }

    public LdifChangeRecordReader setRejectedLdifListener(RejectedLdifListener listener) {
        this.rejectedRecordListener = listener;
        return this;
    }

    public LdifChangeRecordReader setSchema(Schema schema) {
        Reject.ifNull(schema);
        this.schema = this.schemaValidationPolicy.adaptSchemaForValidation(schema);
        return this;
    }

    public LdifChangeRecordReader setSchemaValidationPolicy(SchemaValidationPolicy policy) {
        this.schemaValidationPolicy = SchemaValidationPolicy.copyOf(policy);
        this.schema = this.schemaValidationPolicy.adaptSchemaForValidation(this.schema);
        return this;
    }

    private ChangeRecord getNextChangeRecord() throws IOException {
        while (this.nextChangeRecord == null) {
            AbstractLdifReader.LdifRecord record = this.readLdifRecord();
            if (record == null) {
                this.nextChangeRecord = EOF;
                break;
            }
            try {
                String ldifLine;
                AbstractLdifReader.KeyValuePair pair;
                Dn entryDN = this.readLdifRecordDn(record);
                if (entryDN == null) continue;
                if (this.isBranchExcluded(entryDN)) {
                    LocalizableMessage message = CoreMessages.ERR_LDIF_CHANGE_EXCLUDED_BY_DN.get(record.lineNumber, entryDN);
                    this.handleSkippedRecord(record, message);
                    continue;
                }
                LinkedList<Control> controls = null;
                while (true) {
                    if (!record.iterator.hasNext()) {
                        throw DecodeException.error(CoreMessages.ERR_LDIF_NO_CHANGE_TYPE.get(record.lineNumber, entryDN));
                    }
                    pair = new AbstractLdifReader.KeyValuePair();
                    ldifLine = this.readLdifRecordKeyValuePair(record, pair, false);
                    if (pair.key == null) {
                        throw DecodeException.error(CoreMessages.ERR_LDIF_MALFORMED_CHANGE_TYPE.get(record.lineNumber, entryDN, ldifLine));
                    }
                    if (!"control".equals(StaticUtils.toLowerCase(pair.key))) break;
                    if (controls == null) {
                        controls = new LinkedList<Control>();
                    }
                    controls.add(this.parseControl(entryDN, record, ldifLine, pair.value));
                }
                if (!"changetype".equals(StaticUtils.toLowerCase(pair.key))) {
                    this.nextChangeRecord = this.parseAddChangeRecordEntry(entryDN, ldifLine, record);
                    continue;
                }
                String changeType = StaticUtils.toLowerCase(pair.value);
                if ("add".equals(changeType)) {
                    this.nextChangeRecord = this.parseAddChangeRecordEntry(entryDN, null, record);
                } else if ("delete".equals(changeType)) {
                    this.nextChangeRecord = this.parseDeleteChangeRecordEntry(entryDN, record);
                } else if ("modify".equals(changeType)) {
                    this.nextChangeRecord = this.parseModifyChangeRecordEntry(entryDN, record);
                } else if ("modrdn".equals(changeType)) {
                    this.nextChangeRecord = this.parseModifyDnChangeRecordEntry(entryDN, record);
                } else if ("moddn".equals(changeType)) {
                    this.nextChangeRecord = this.parseModifyDnChangeRecordEntry(entryDN, record);
                } else {
                    throw DecodeException.error(CoreMessages.ERR_LDIF_BAD_CHANGE_TYPE.get(record.lineNumber, entryDN, pair.value));
                }
                if (controls == null) continue;
                for (Control control : controls) {
                    this.nextChangeRecord.addControl(control);
                }
            }
            catch (DecodeException e) {
                this.handleMalformedRecord(record, e);
            }
        }
        return this.nextChangeRecord;
    }

    private ChangeRecord parseAddChangeRecordEntry(Dn entryDN, String lastLDIFLine, AbstractLdifReader.LdifRecord record) throws DecodeException {
        LinkedHashMapEntry entry = new LinkedHashMapEntry(entryDN);
        boolean schemaValidationFailure = false;
        LinkedList<LocalizableMessage> schemaErrors = new LinkedList<LocalizableMessage>();
        if (lastLDIFLine != null && !this.readLdifRecordAttributeValue(record, lastLDIFLine, entry, schemaErrors)) {
            schemaValidationFailure = true;
        }
        while (record.iterator.hasNext()) {
            String ldifLine = record.iterator.next();
            if (this.readLdifRecordAttributeValue(record, ldifLine, entry, schemaErrors)) continue;
            schemaValidationFailure = true;
        }
        if (!this.schema.validateEntry(entry, this.schemaValidationPolicy, schemaErrors)) {
            schemaValidationFailure = true;
        }
        if (schemaValidationFailure) {
            this.handleSchemaValidationFailure(record, schemaErrors);
            return null;
        }
        if (!schemaErrors.isEmpty()) {
            this.handleSchemaValidationWarning(record, schemaErrors);
        }
        return Requests.newAddRequest(entry);
    }

    private Control parseControl(Dn entryDN, AbstractLdifReader.LdifRecord record, String ldifLine, String value) throws DecodeException {
        Matcher matcher = CONTROL_REGEX.matcher(value);
        if (!matcher.matches()) {
            throw DecodeException.error(CoreMessages.ERR_LDIF_MALFORMED_CONTROL.get(record.lineNumber, entryDN, ldifLine));
        }
        String oid = matcher.group(1);
        boolean isCritical = matcher.group(5) != null;
        String controlValueString = matcher.group(7);
        ByteString controlValue = null;
        if (controlValueString != null) {
            controlValue = this.parseSingleValue(record, ldifLine, entryDN, ldifLine.indexOf(58, 8), oid);
        }
        return GenericControl.newControl(oid, isCritical, controlValue);
    }

    private ChangeRecord parseDeleteChangeRecordEntry(Dn entryDN, AbstractLdifReader.LdifRecord record) throws DecodeException {
        if (record.iterator.hasNext()) {
            throw DecodeException.error(CoreMessages.ERR_LDIF_MALFORMED_DELETE.get(record.lineNumber, entryDN));
        }
        return Requests.newDeleteRequest(entryDN);
    }

    private ChangeRecord parseModifyChangeRecordEntry(Dn entryDN, AbstractLdifReader.LdifRecord record) throws DecodeException {
        ModifyRequest modifyRequest = Requests.newModifyRequest(entryDN);
        AbstractLdifReader.KeyValuePair pair = new AbstractLdifReader.KeyValuePair();
        ArrayList<ByteString> attributeValues = new ArrayList<ByteString>();
        boolean schemaValidationFailure = false;
        LinkedList<LocalizableMessage> schemaErrors = new LinkedList<LocalizableMessage>();
        block9: while (record.iterator.hasNext()) {
            LocalizableMessage message;
            AttributeDescription attributeDescription;
            ModificationType modType;
            String ldifLine = this.readLdifRecordKeyValuePair(record, pair, false);
            if (pair.key == null) {
                throw DecodeException.error(CoreMessages.ERR_LDIF_MALFORMED_MODIFICATION_TYPE.get(record.lineNumber, entryDN, ldifLine));
            }
            String changeType = StaticUtils.toLowerCase(pair.key);
            if ("add".equals(changeType)) {
                modType = ModificationType.ADD;
            } else if ("delete".equals(changeType)) {
                modType = ModificationType.DELETE;
            } else if ("replace".equals(changeType)) {
                modType = ModificationType.REPLACE;
            } else if ("increment".equals(changeType)) {
                modType = ModificationType.INCREMENT;
            } else {
                throw DecodeException.error(CoreMessages.ERR_LDIF_BAD_MODIFICATION_TYPE.get(record.lineNumber, entryDN, pair.key));
            }
            try {
                attributeDescription = AttributeDescription.valueOf(pair.value, this.schema);
            }
            catch (UnknownSchemaElementException e) {
                message = CoreMessages.ERR_LDIF_UNKNOWN_ATTRIBUTE_TYPE.get(record.lineNumber, entryDN, pair.value);
                switch (this.schemaValidationPolicy.checkAttributesAndObjectClasses()) {
                    case REJECT: {
                        schemaValidationFailure = true;
                        schemaErrors.add(message);
                        continue block9;
                    }
                    case WARN: {
                        schemaErrors.add(message);
                        continue block9;
                    }
                }
                throw new IllegalStateException("Schema is not consistent with policy", e);
            }
            catch (LocalizedIllegalArgumentException e) {
                throw DecodeException.error(CoreMessages.ERR_LDIF_MALFORMED_ATTRIBUTE_NAME.get(record.lineNumber, entryDN, pair.value));
            }
            if (this.isAttributeExcluded(attributeDescription)) continue;
            Syntax syntax = attributeDescription.getAttributeType().getSyntax();
            if (!syntax.isBerEncodingRequired()) {
                if (this.schemaValidationPolicy.checkAttributeValues().needsChecking() && attributeDescription.hasOption("binary")) {
                    message = CoreMessages.ERR_LDIF_UNEXPECTED_BINARY_OPTION.get(record.lineNumber, entryDN, pair.value);
                    if (this.schemaValidationPolicy.checkAttributeValues().isReject()) {
                        schemaValidationFailure = true;
                    }
                    schemaErrors.add(message);
                    continue;
                }
            } else {
                attributeDescription = attributeDescription.withOption("binary");
            }
            attributeValues.clear();
            while (record.iterator.hasNext() && !"-".equals(ldifLine = record.iterator.next())) {
                LocalizableMessageBuilder builder;
                AttributeDescription attributeDescription2;
                int colonPos = this.parseColonPosition(record, ldifLine);
                String attrDescr = ldifLine.substring(0, colonPos);
                try {
                    attributeDescription2 = AttributeDescription.valueOf(attrDescr, this.schema);
                }
                catch (LocalizedIllegalArgumentException e) {
                    throw DecodeException.error(CoreMessages.ERR_LDIF_MALFORMED_ATTRIBUTE_NAME.get(record.lineNumber, entryDN, attrDescr));
                }
                if (attributeDescription.getAttributeType().getSyntax().isBerEncodingRequired()) {
                    attributeDescription2 = attributeDescription2.withOption("binary");
                }
                if (!attributeDescription2.equals(attributeDescription)) {
                    throw DecodeException.error(CoreMessages.ERR_LDIF_ATTRIBUTE_NAME_MISMATCH.get(record.lineNumber, entryDN, attributeDescription2, attributeDescription));
                }
                ByteString value = this.parseSingleValue(record, ldifLine, entryDN, colonPos, attrDescr);
                if (this.schemaValidationPolicy.checkAttributeValues().needsChecking() && !syntax.valueIsAcceptable(value, builder = new LocalizableMessageBuilder())) {
                    if (this.schemaValidationPolicy.checkAttributeValues().isReject()) {
                        schemaValidationFailure = true;
                    }
                    schemaErrors.add(builder.toMessage());
                }
                attributeValues.add(value);
            }
            Modification change = new Modification(modType, new LinkedAttribute(attributeDescription, attributeValues));
            modifyRequest.addModification(change);
        }
        if (schemaValidationFailure) {
            this.handleSchemaValidationFailure(record, schemaErrors);
            return null;
        }
        if (!schemaErrors.isEmpty()) {
            this.handleSchemaValidationWarning(record, schemaErrors);
        }
        return modifyRequest;
    }

    private ChangeRecord parseModifyDnChangeRecordEntry(Dn entryDN, AbstractLdifReader.LdifRecord record) throws DecodeException {
        LocalizableMessage message;
        ModifyDnRequest modifyDNRequest;
        if (!record.iterator.hasNext()) {
            throw DecodeException.error(CoreMessages.ERR_LDIF_NO_NEW_RDN.get(record.lineNumber, entryDN));
        }
        AbstractLdifReader.KeyValuePair pair = new AbstractLdifReader.KeyValuePair();
        String ldifLine = this.readLdifRecordKeyValuePair(record, pair, true);
        if (pair.key == null || !"newrdn".equals(StaticUtils.toLowerCase(pair.key))) {
            throw DecodeException.error(CoreMessages.ERR_LDIF_MALFORMED_NEW_RDN.get(record.lineNumber, entryDN, ldifLine));
        }
        try {
            Rdn newRDN = Rdn.valueOf(pair.value, this.schema);
            modifyDNRequest = Requests.newModifyDnRequest(entryDN, newRDN);
        }
        catch (LocalizedIllegalArgumentException e) {
            throw DecodeException.error(CoreMessages.ERR_LDIF_MALFORMED_NEW_RDN.get(record.lineNumber, entryDN, pair.value));
        }
        if (!record.iterator.hasNext()) {
            message = CoreMessages.ERR_LDIF_NO_DELETE_OLD_RDN.get(record.lineNumber, entryDN.toString());
            throw DecodeException.error(message);
        }
        ldifLine = this.readLdifRecordKeyValuePair(record, pair, true);
        if (pair.key == null || !"deleteoldrdn".equals(StaticUtils.toLowerCase(pair.key))) {
            message = CoreMessages.ERR_LDIF_MALFORMED_DELETE_OLD_RDN.get(record.lineNumber, entryDN.toString(), ldifLine);
            throw DecodeException.error(message);
        }
        String delStr = StaticUtils.toLowerCase(pair.value);
        if ("false".equals(delStr) || "no".equals(delStr) || "0".equals(delStr)) {
            modifyDNRequest.setDeleteOldRdn(false);
        } else if ("true".equals(delStr) || "yes".equals(delStr) || "1".equals(delStr)) {
            modifyDNRequest.setDeleteOldRdn(true);
        } else {
            LocalizableMessage message2 = CoreMessages.ERR_LDIF_MALFORMED_DELETE_OLD_RDN.get(record.lineNumber, entryDN.toString(), pair.value);
            throw DecodeException.error(message2);
        }
        if (record.iterator.hasNext()) {
            ldifLine = this.readLdifRecordKeyValuePair(record, pair, true);
            if (pair.key == null || !"newsuperior".equals(StaticUtils.toLowerCase(pair.key)) || "".equals(pair.value)) {
                throw DecodeException.error(CoreMessages.ERR_LDIF_MALFORMED_NEW_SUPERIOR.get(record.lineNumber, entryDN, ldifLine));
            }
            try {
                Dn newSuperiorDN = Dn.valueOf(pair.value, this.schema);
                modifyDNRequest.setNewSuperior(newSuperiorDN.toString());
            }
            catch (LocalizedIllegalArgumentException e) {
                LocalizableMessage message3 = CoreMessages.ERR_LDIF_MALFORMED_NEW_SUPERIOR.get(record.lineNumber, entryDN.toString(), pair.value);
                throw DecodeException.error(message3);
            }
        }
        return modifyDNRequest;
    }
}

