/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.schema.AbstractSchemaElement;
import org.forgerock.opendj.ldap.schema.EnumOrderingMatchingRule;
import org.forgerock.opendj.ldap.schema.EnumSyntaxImpl;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.RegexSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.SyntaxImpl;
import org.forgerock.util.Reject;

public final class Syntax
extends AbstractSchemaElement {
    private final String oid;
    private MatchingRule equalityMatchingRule;
    private MatchingRule orderingMatchingRule;
    private MatchingRule substringMatchingRule;
    private MatchingRule approximateMatchingRule;
    private Schema schema;
    private SyntaxImpl impl;

    private Syntax(Builder builder) {
        super(builder);
        if (builder.oid == null || builder.oid.isEmpty()) {
            throw new IllegalArgumentException("An OID must be specified.");
        }
        this.oid = builder.oid;
        this.impl = builder.impl;
    }

    Syntax(Schema schema, String oid) {
        super("", Collections.singletonMap("X-SUBST", Collections.singletonList(schema.getDefaultSyntax().getOid())), null);
        Reject.ifNull(oid);
        this.oid = oid;
        this.schema = schema;
        Syntax defaultSyntax = schema.getDefaultSyntax();
        this.impl = defaultSyntax.impl;
        this.approximateMatchingRule = defaultSyntax.getApproximateMatchingRule();
        this.equalityMatchingRule = defaultSyntax.getEqualityMatchingRule();
        this.orderingMatchingRule = defaultSyntax.getOrderingMatchingRule();
        this.substringMatchingRule = defaultSyntax.getSubstringMatchingRule();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Syntax) {
            Syntax other = (Syntax)o;
            return this.oid.equals(other.oid);
        }
        return false;
    }

    public MatchingRule getApproximateMatchingRule() {
        return this.approximateMatchingRule;
    }

    public MatchingRule getEqualityMatchingRule() {
        return this.equalityMatchingRule;
    }

    public String getOid() {
        return this.oid;
    }

    public String getName() {
        return this.impl.getName();
    }

    public MatchingRule getOrderingMatchingRule() {
        return this.orderingMatchingRule;
    }

    public MatchingRule getSubstringMatchingRule() {
        return this.substringMatchingRule;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    public boolean isBerEncodingRequired() {
        return this.impl.isBerEncodingRequired();
    }

    public boolean isHumanReadable() {
        return this.impl.isHumanReadable();
    }

    public boolean valueIsAcceptable(ByteSequence value, LocalizableMessageBuilder invalidReason) {
        return this.impl.valueIsAcceptable(this.schema, value, invalidReason);
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        buffer.append(this.oid);
        this.appendDescription(buffer);
    }

    void validate(Schema schema, List<LocalizableMessage> warnings) throws SchemaException {
        LocalizableMessage message;
        this.schema = schema;
        if (this.impl == null) {
            for (Map.Entry<String, List<String>> property : this.getExtraProperties().entrySet()) {
                String value;
                Iterator<String> values;
                if ("x-subst".equalsIgnoreCase(property.getKey())) {
                    values = property.getValue().iterator();
                    if (!values.hasNext()) continue;
                    value = values.next();
                    if (value.equals(this.oid)) {
                        throw new SchemaException(CoreMessages.ERR_ATTR_SYNTAX_CYCLIC_SUB_SYNTAX.get(this.oid));
                    }
                    if (!schema.hasSyntax(value)) {
                        throw new SchemaException(CoreMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUB_SYNTAX.get(this.oid, value));
                    }
                    Syntax subSyntax = schema.getSyntax(value);
                    if (subSyntax.impl == null) {
                        subSyntax.validate(schema, warnings);
                    }
                    this.impl = subSyntax.impl;
                    continue;
                }
                if (!"x-pattern".equalsIgnoreCase(property.getKey()) || !(values = property.getValue().iterator()).hasNext()) continue;
                value = values.next();
                try {
                    Pattern pattern = Pattern.compile(value);
                    this.impl = new RegexSyntaxImpl(pattern);
                }
                catch (Exception e) {
                    throw new SchemaException(CoreMessages.WARN_ATTR_SYNTAX_LDAPSYNTAX_REGEX_INVALID_PATTERN.get(this.oid, value));
                }
            }
            if (this.impl == null && Schema.getDefaultSchema().hasSyntax(this.oid)) {
                this.impl = Schema.getDefaultSchema().getSyntax((String)this.oid).impl;
            }
            if (this.impl == null && Schema.getCoreSchema().hasSyntax(this.oid)) {
                this.impl = Schema.getCoreSchema().getSyntax((String)this.oid).impl;
            }
            if (this.impl == null) {
                Syntax defaultSyntax = schema.getDefaultSyntax();
                if (defaultSyntax.impl == null) {
                    defaultSyntax.validate(schema, warnings);
                }
                this.impl = defaultSyntax.impl;
                LocalizableMessage message2 = CoreMessages.WARN_ATTR_SYNTAX_NOT_IMPLEMENTED1.get(this.getDescription(), this.oid, schema.getDefaultSyntax().getOid());
                warnings.add(message2);
            }
        }
        if (this.impl.getEqualityMatchingRule() != null) {
            if (schema.hasMatchingRule(this.impl.getEqualityMatchingRule())) {
                this.equalityMatchingRule = schema.getMatchingRule(this.impl.getEqualityMatchingRule());
            } else {
                message = CoreMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get(this.impl.getEqualityMatchingRule(), this.impl.getName());
                warnings.add(message);
            }
        }
        if (this.impl.getOrderingMatchingRule() != null) {
            if (schema.hasMatchingRule(this.impl.getOrderingMatchingRule())) {
                this.orderingMatchingRule = schema.getMatchingRule(this.impl.getOrderingMatchingRule());
            } else {
                message = CoreMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get(this.impl.getOrderingMatchingRule(), this.impl.getName());
                warnings.add(message);
            }
        }
        if (this.impl.getSubstringMatchingRule() != null) {
            if (schema.hasMatchingRule(this.impl.getSubstringMatchingRule())) {
                this.substringMatchingRule = schema.getMatchingRule(this.impl.getSubstringMatchingRule());
            } else {
                message = CoreMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get(this.impl.getSubstringMatchingRule(), this.impl.getName());
                warnings.add(message);
            }
        }
        if (this.impl.getApproximateMatchingRule() != null) {
            if (schema.hasMatchingRule(this.impl.getApproximateMatchingRule())) {
                this.approximateMatchingRule = schema.getMatchingRule(this.impl.getApproximateMatchingRule());
            } else {
                message = CoreMessages.ERR_ATTR_SYNTAX_UNKNOWN_APPROXIMATE_MATCHING_RULE.get(this.impl.getApproximateMatchingRule(), this.impl.getName());
                warnings.add(message);
            }
        }
    }

    boolean isValidated() {
        return this.schema != null;
    }

    public static final class Builder
    extends AbstractSchemaElement.SchemaElementBuilder<Builder> {
        private String oid;
        private SyntaxImpl impl;

        Builder(Syntax syntax, SchemaBuilder builder) {
            super(builder, syntax);
            this.oid = syntax.oid;
            this.impl = syntax.impl;
        }

        Builder(String oid, SchemaBuilder builder) {
            super(builder);
            this.oid(oid);
        }

        public SchemaBuilder addToSchema() {
            return this.addToSchema(false);
        }

        public SchemaBuilder addToSchemaOverwrite() {
            return this.addToSchema(true);
        }

        SchemaBuilder addToSchema(boolean overwrite) {
            for (Map.Entry<String, List<String>> property : this.getExtraProperties().entrySet()) {
                if (!"x-enum".equalsIgnoreCase(property.getKey())) continue;
                EnumSyntaxImpl enumSyntaxImpl = new EnumSyntaxImpl(this.oid, property.getValue());
                this.implementation(enumSyntaxImpl);
                return this.getSchemaBuilder().addSyntax(new Syntax(this), overwrite).buildMatchingRule(enumSyntaxImpl.getOrderingMatchingRule()).description(this.getDescription() + " enumeration ordering matching rule").syntaxOid(this.oid).extraProperties("X-ORIGIN", "OpenDJ X-ENUM Syntax").implementation(new EnumOrderingMatchingRule(enumSyntaxImpl)).addToSchemaOverwrite();
            }
            return this.getSchemaBuilder().addSyntax(new Syntax(this), overwrite);
        }

        @Override
        public Builder description(String description) {
            return (Builder)this.description0(description);
        }

        @Override
        public Builder extraProperties(Map<String, List<String>> extraProperties) {
            return (Builder)this.extraProperties0(extraProperties);
        }

        @Override
        public Builder extraProperties(String extensionName, String ... extensionValues) {
            return (Builder)this.extraProperties0(extensionName, extensionValues);
        }

        public Builder oid(String oid) {
            this.oid = oid;
            return this;
        }

        @Override
        public Builder removeAllExtraProperties() {
            return (Builder)this.removeAllExtraProperties0();
        }

        @Override
        public Builder removeExtraProperty(String extensionName, String ... extensionValues) {
            return (Builder)this.removeExtraProperty0(extensionName, extensionValues);
        }

        public Builder implementation(SyntaxImpl implementation) {
            this.impl = implementation;
            return this;
        }

        @Override
        Builder getThis() {
            return this;
        }
    }
}

