/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.SubstringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.messages.SearchResultEntry;
import org.forgerock.opendj.ldap.schema.AbstractSchemaElement;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.AttributeUsage;
import org.forgerock.opendj.ldap.schema.ConflictingSchemaElementException;
import org.forgerock.opendj.ldap.schema.DitContentRule;
import org.forgerock.opendj.ldap.schema.DitStructureRule;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleUse;
import org.forgerock.opendj.ldap.schema.NameForm;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaElement;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.SchemaUtils;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;

public final class SchemaBuilder {
    private static final String ATTR_SUBSCHEMA_SUBENTRY = "subschemaSubentry";
    private static final String[] SUBSCHEMA_ATTRS = new String[]{"ldapSyntaxes", "attributeTypes", "dITContentRules", "dITStructureRules", "matchingRuleUse", "matchingRules", "nameForms", "objectClasses"};
    private static final Filter SUBSCHEMA_FILTER = Filter.valueOf("(objectClass=subschema)");
    private static final String[] SUBSCHEMA_SUBENTRY_ATTRS = new String[]{"subschemaSubentry"};
    private Map<Integer, DitStructureRule> id2StructureRules;
    private Map<String, List<AttributeType>> name2AttributeTypes;
    private Map<String, List<DitContentRule>> name2ContentRules;
    private Map<String, List<MatchingRule>> name2MatchingRules;
    private Map<String, List<MatchingRuleUse>> name2MatchingRuleUses;
    private Map<String, List<NameForm>> name2NameForms;
    private Map<String, List<ObjectClass>> name2ObjectClasses;
    private Map<String, List<DitStructureRule>> name2StructureRules;
    private Map<String, List<DitStructureRule>> nameForm2StructureRules;
    private Map<String, AttributeType> numericOid2AttributeTypes;
    private Map<String, DitContentRule> numericOid2ContentRules;
    private Map<String, MatchingRule> numericOid2MatchingRules;
    private Map<String, MatchingRuleUse> numericOid2MatchingRuleUses;
    private Map<String, NameForm> numericOid2NameForms;
    private Map<String, ObjectClass> numericOid2ObjectClasses;
    private Map<String, Syntax> numericOid2Syntaxes;
    private Map<String, List<NameForm>> objectClass2NameForms;
    private String schemaName;
    private List<LocalizableMessage> warnings;
    private Options options;
    private Schema copyOnWriteSchema;
    private static final AtomicInteger NEXT_SCHEMA_ID = new AtomicInteger();

    private static SearchRequest getReadSchemaForEntrySearchRequest(Dn dn) {
        return Requests.newSearchRequest(dn, SearchScope.BASE_OBJECT, Filter.objectClassPresent(), SUBSCHEMA_SUBENTRY_ATTRS);
    }

    private static SearchRequest getReadSchemaSearchRequest(Dn dn) {
        return Requests.newSearchRequest(dn, SearchScope.BASE_OBJECT, SUBSCHEMA_FILTER, SUBSCHEMA_ATTRS);
    }

    private static Dn getSubschemaSubentryDn(Dn name, Entry entry) throws LdapException {
        Dn subschemaDN;
        Attribute subentryAttr = entry.getAttribute(ATTR_SUBSCHEMA_SUBENTRY);
        if (subentryAttr == null || subentryAttr.isEmpty()) {
            throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_NO_RESULTS_RETURNED, CoreMessages.ERR_NO_SUBSCHEMA_SUBENTRY_ATTR.get(name).toString());
        }
        String dnString = subentryAttr.iterator().next().toString();
        try {
            subschemaDN = Dn.valueOf(dnString);
        }
        catch (LocalizedIllegalArgumentException e) {
            throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_NO_RESULTS_RETURNED, CoreMessages.ERR_INVALID_SUBSCHEMA_SUBENTRY_ATTR.get(name, dnString, e.getMessageObject()).toString());
        }
        return subschemaDN;
    }

    public SchemaBuilder() {
        this.preLazyInitBuilder(null, null);
    }

    public SchemaBuilder(Entry entry) {
        this.preLazyInitBuilder(entry.getName().toString(), null);
        this.addSchema(entry, true, null);
    }

    public SchemaBuilder(Schema schema) {
        this.preLazyInitBuilder(schema.getSchemaName(), schema);
    }

    public SchemaBuilder(String schemaName) {
        this.preLazyInitBuilder(schemaName, null);
    }

    private Boolean allowsMalformedNamesAndOptions() {
        return this.options.get(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS);
    }

    public SchemaBuilder addAttributeType(String definition, boolean overwrite) {
        return this.addAttributeType(definition, overwrite, null);
    }

    SchemaBuilder addAttributeType(String definition, boolean overwrite, SchemaBuilderHook hook) {
        Reject.ifNull(definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_ATTRTYPE_EMPTY_VALUE1.get(definition));
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ATTRTYPE_EXPECTED_OPEN_PARENTHESIS.get(definition, reader.pos() - 1, String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            String oid = SchemaUtils.readOid(reader, this.allowsMalformedNamesAndOptions());
            AttributeType.Builder atBuilder = new AttributeType.Builder(oid, this);
            atBuilder.definition(definition);
            String superiorType = null;
            String syntax = null;
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    atBuilder.names(SchemaUtils.readNameDescriptors(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    atBuilder.description(SchemaUtils.readQuotedString(reader));
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) {
                    atBuilder.obsolete(true);
                    continue;
                }
                if ("sup".equalsIgnoreCase(tokenName)) {
                    superiorType = SchemaUtils.readOid(reader, this.allowsMalformedNamesAndOptions());
                    continue;
                }
                if ("equality".equalsIgnoreCase(tokenName)) {
                    atBuilder.equalityMatchingRule(SchemaUtils.readOid(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("ordering".equalsIgnoreCase(tokenName)) {
                    atBuilder.orderingMatchingRule(SchemaUtils.readOid(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("substr".equalsIgnoreCase(tokenName)) {
                    atBuilder.substringMatchingRule(SchemaUtils.readOid(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("syntax".equalsIgnoreCase(tokenName)) {
                    syntax = SchemaUtils.readOidLen(reader, this.allowsMalformedNamesAndOptions());
                    continue;
                }
                if ("single-value".equalsIgnoreCase(tokenName)) {
                    atBuilder.singleValue(true);
                    continue;
                }
                if ("collective".equalsIgnoreCase(tokenName)) {
                    atBuilder.collective(true);
                    continue;
                }
                if ("no-user-modification".equalsIgnoreCase(tokenName)) {
                    atBuilder.noUserModification(true);
                    continue;
                }
                if ("usage".equalsIgnoreCase(tokenName)) {
                    int length = 0;
                    reader.skipWhitespaces();
                    reader.mark();
                    while (" )".indexOf(reader.read()) == -1) {
                        ++length;
                    }
                    reader.reset();
                    String usageStr = reader.read(length);
                    if ("userapplications".equalsIgnoreCase(usageStr)) {
                        atBuilder.usage(AttributeUsage.USER_APPLICATIONS);
                        continue;
                    }
                    if ("directoryoperation".equalsIgnoreCase(usageStr)) {
                        atBuilder.usage(AttributeUsage.DIRECTORY_OPERATION);
                        continue;
                    }
                    if ("distributedoperation".equalsIgnoreCase(usageStr)) {
                        atBuilder.usage(AttributeUsage.DISTRIBUTED_OPERATION);
                        continue;
                    }
                    if ("dsaoperation".equalsIgnoreCase(usageStr)) {
                        atBuilder.usage(AttributeUsage.DSA_OPERATION);
                        continue;
                    }
                    throw new LocalizedIllegalArgumentException(CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_INVALID_ATTRIBUTE_USAGE1.get(definition, usageStr));
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    atBuilder.extraProperties(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_TOKEN1.get(definition, tokenName));
            }
            List<String> approxRules = atBuilder.getExtraProperties().get("X-APPROX");
            if (approxRules != null && !approxRules.isEmpty()) {
                atBuilder.approximateMatchingRule(approxRules.get(0));
            }
            if (superiorType == null && syntax == null && !this.options.get(SchemaOptions.ALLOW_ATTRIBUTE_TYPES_WITH_NO_SUP_OR_SYNTAX).booleanValue()) {
                throw new LocalizedIllegalArgumentException(CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_MISSING_SYNTAX_AND_SUPERIOR.get(definition));
            }
            atBuilder.superiorType(superiorType).syntax(syntax);
            if (hook != null) {
                hook.beforeAddAttribute(atBuilder);
            }
            return atBuilder.addToSchema(overwrite);
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_ATTRTYPE_INVALID1.get(definition, e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
    }

    public SchemaBuilder addDitContentRule(String definition, boolean overwrite) {
        return this.addDitContentRule(definition, overwrite, null);
    }

    SchemaBuilder addDitContentRule(String definition, boolean overwrite, SchemaBuilderHook hook) {
        Reject.ifNull(definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DCR_EMPTY_VALUE1.get(definition));
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_EXPECTED_OPEN_PARENTHESIS.get(definition, reader.pos() - 1, String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            DitContentRule.Builder contentRuleBuilder = this.buildDitContentRule(SchemaUtils.readOid(reader, this.allowsMalformedNamesAndOptions()));
            contentRuleBuilder.definition(definition);
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    contentRuleBuilder.names(SchemaUtils.readNameDescriptors(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    contentRuleBuilder.description(SchemaUtils.readQuotedString(reader));
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) {
                    contentRuleBuilder.obsolete(true);
                    continue;
                }
                if ("aux".equalsIgnoreCase(tokenName)) {
                    contentRuleBuilder.auxiliaryObjectClasses(SchemaUtils.readOids(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("must".equalsIgnoreCase(tokenName)) {
                    contentRuleBuilder.requiredAttributes(SchemaUtils.readOids(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("may".equalsIgnoreCase(tokenName)) {
                    contentRuleBuilder.optionalAttributes(SchemaUtils.readOids(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("not".equalsIgnoreCase(tokenName)) {
                    contentRuleBuilder.prohibitedAttributes(SchemaUtils.readOids(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    contentRuleBuilder.extraProperties(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DCR_ILLEGAL_TOKEN1.get(definition, tokenName));
            }
            if (hook != null) {
                hook.beforeAddDitContentRule(contentRuleBuilder);
            }
            return contentRuleBuilder.addToSchema(overwrite);
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_DCR_INVALID1.get(definition, e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
    }

    public SchemaBuilder addDitStructureRule(String definition, boolean overwrite) {
        return this.addDitStructureRule(definition, overwrite, null);
    }

    SchemaBuilder addDitStructureRule(String definition, boolean overwrite, SchemaBuilderHook hook) {
        Reject.ifNull(definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DSR_EMPTY_VALUE1.get(definition));
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DSR_EXPECTED_OPEN_PARENTHESIS.get(definition, reader.pos() - 1, String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            DitStructureRule.Builder ruleBuilder = new DitStructureRule.Builder(SchemaUtils.readRuleId(reader), this);
            String nameForm = null;
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    ruleBuilder.names(SchemaUtils.readNameDescriptors(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    ruleBuilder.description(SchemaUtils.readQuotedString(reader));
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) {
                    ruleBuilder.obsolete(true);
                    continue;
                }
                if ("form".equalsIgnoreCase(tokenName)) {
                    nameForm = SchemaUtils.readOid(reader, this.allowsMalformedNamesAndOptions());
                    continue;
                }
                if ("sup".equalsIgnoreCase(tokenName)) {
                    ruleBuilder.superiorRules(SchemaUtils.readRuleIds(reader));
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    ruleBuilder.extraProperties(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DSR_ILLEGAL_TOKEN1.get(definition, tokenName));
            }
            if (nameForm == null) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DSR_NO_NAME_FORM.get(definition));
            }
            ruleBuilder.nameForm(nameForm);
            if (hook != null) {
                hook.beforeAddDitStructureRule(ruleBuilder);
            }
            return ruleBuilder.addToSchema(overwrite);
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_DSR_INVALID1.get(definition, e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
    }

    public SchemaBuilder addEnumerationSyntax(String oid, String description, boolean overwrite, String ... enumerations) {
        Reject.ifNull(enumerations);
        return this.buildSyntax(oid).description(description).extraProperties("X-ENUM", enumerations).addToSchema(overwrite);
    }

    public SchemaBuilder addMatchingRule(String definition, boolean overwrite) {
        return this.addMatchingRule(definition, overwrite, null);
    }

    SchemaBuilder addMatchingRule(String definition, boolean overwrite, SchemaBuilderHook hook) {
        Reject.ifNull(definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_MR_EMPTY_VALUE1.get(definition));
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MR_EXPECTED_OPEN_PARENTHESIS.get(definition, reader.pos() - 1, String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            MatchingRule.Builder matchingRuleBuilder = new MatchingRule.Builder(SchemaUtils.readOid(reader, this.allowsMalformedNamesAndOptions()), this);
            matchingRuleBuilder.definition(definition);
            String syntax = null;
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    matchingRuleBuilder.names(SchemaUtils.readNameDescriptors(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    matchingRuleBuilder.description(SchemaUtils.readQuotedString(reader));
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) {
                    matchingRuleBuilder.obsolete(true);
                    continue;
                }
                if ("syntax".equalsIgnoreCase(tokenName)) {
                    syntax = SchemaUtils.readOid(reader, this.allowsMalformedNamesAndOptions());
                    matchingRuleBuilder.syntaxOid(syntax);
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    matchingRuleBuilder.extraProperties(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_MR_ILLEGAL_TOKEN1.get(definition, tokenName));
            }
            if (syntax == null) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_MR_NO_SYNTAX.get(definition));
            }
            if (hook != null) {
                hook.beforeAddMatchingRule(matchingRuleBuilder);
            }
            matchingRuleBuilder.addToSchema(overwrite);
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_MR_INVALID1.get(definition, e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
        return this;
    }

    public SchemaBuilder addMatchingRuleUse(String definition, boolean overwrite) {
        return this.addMatchingRuleUse(definition, overwrite, null);
    }

    SchemaBuilder addMatchingRuleUse(String definition, boolean overwrite, SchemaBuilderHook hook) {
        Reject.ifNull(definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_MRUSE_EMPTY_VALUE1.get(definition));
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MRUSE_EXPECTED_OPEN_PARENTHESIS.get(definition, reader.pos() - 1, String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            MatchingRuleUse.Builder useBuilder = this.buildMatchingRuleUse(SchemaUtils.readOid(reader, this.allowsMalformedNamesAndOptions()));
            Set<String> attributes = null;
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    useBuilder.names(SchemaUtils.readNameDescriptors(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    useBuilder.description(SchemaUtils.readQuotedString(reader));
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) {
                    useBuilder.obsolete(true);
                    continue;
                }
                if ("applies".equalsIgnoreCase(tokenName)) {
                    attributes = SchemaUtils.readOids(reader, this.allowsMalformedNamesAndOptions());
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    useBuilder.extraProperties(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_TOKEN1.get(definition, tokenName));
            }
            if (attributes == null || attributes.isEmpty()) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_MRUSE_NO_ATTR.get(definition));
            }
            useBuilder.attributes((Collection<String>)attributes);
            if (hook != null) {
                hook.beforeAddMatchingRuleUse(useBuilder);
            }
            return useBuilder.addToSchema(overwrite);
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_MRUSE_INVALID1.get(definition, e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
    }

    public AttributeType.Builder buildAttributeType(String oid) {
        this.lazyInitBuilder();
        return new AttributeType.Builder(oid, this);
    }

    public DitStructureRule.Builder buildDitStructureRule(int ruleId) {
        this.lazyInitBuilder();
        return new DitStructureRule.Builder(ruleId, this);
    }

    public MatchingRule.Builder buildMatchingRule(String oid) {
        this.lazyInitBuilder();
        return new MatchingRule.Builder(oid, this);
    }

    public MatchingRuleUse.Builder buildMatchingRuleUse(String oid) {
        this.lazyInitBuilder();
        return new MatchingRuleUse.Builder(oid, this);
    }

    public SchemaBuilder addNameForm(String definition, boolean overwrite) {
        return this.addNameForm(definition, overwrite, null);
    }

    SchemaBuilder addNameForm(String definition, boolean overwrite, SchemaBuilderHook hook) {
        Reject.ifNull(definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_EMPTY_VALUE1.get(definition));
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_EXPECTED_OPEN_PARENTHESIS.get(definition, reader.pos() - 1, Character.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            NameForm.Builder nameFormBuilder = new NameForm.Builder(SchemaUtils.readOid(reader, this.allowsMalformedNamesAndOptions()), this);
            nameFormBuilder.definition(definition);
            String structuralOID = null;
            List<String> requiredAttributes = Collections.emptyList();
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    nameFormBuilder.names(SchemaUtils.readNameDescriptors(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    nameFormBuilder.description(SchemaUtils.readQuotedString(reader));
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) {
                    nameFormBuilder.obsolete(true);
                    continue;
                }
                if ("oc".equalsIgnoreCase(tokenName)) {
                    structuralOID = SchemaUtils.readOid(reader, this.allowsMalformedNamesAndOptions());
                    nameFormBuilder.structuralObjectClassOid(structuralOID);
                    continue;
                }
                if ("must".equalsIgnoreCase(tokenName)) {
                    requiredAttributes = SchemaUtils.readOids(reader, this.allowsMalformedNamesAndOptions());
                    nameFormBuilder.requiredAttributes(requiredAttributes);
                    continue;
                }
                if ("may".equalsIgnoreCase(tokenName)) {
                    nameFormBuilder.optionalAttributes(SchemaUtils.readOids(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    nameFormBuilder.extraProperties(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_ILLEGAL_TOKEN1.get(definition, tokenName));
            }
            if (structuralOID == null) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_NO_STRUCTURAL_CLASS1.get(definition));
            }
            if (requiredAttributes.isEmpty()) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_NO_REQUIRED_ATTR.get(definition));
            }
            if (hook != null) {
                hook.beforeAddNameForm(nameFormBuilder);
            }
            nameFormBuilder.addToSchema(overwrite);
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_INVALID1.get(definition, e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
        return this;
    }

    public DitContentRule.Builder buildDitContentRule(String structuralClassOid) {
        this.lazyInitBuilder();
        return new DitContentRule.Builder(structuralClassOid, this);
    }

    public NameForm.Builder buildNameForm(String oid) {
        this.lazyInitBuilder();
        return new NameForm.Builder(oid, this);
    }

    public ObjectClass.Builder buildObjectClass(String oid) {
        this.lazyInitBuilder();
        return new ObjectClass.Builder(oid, this);
    }

    public Syntax.Builder buildSyntax(String oid) {
        this.lazyInitBuilder();
        return new Syntax.Builder(oid, this);
    }

    public AttributeType.Builder buildAttributeType(AttributeType attributeType) {
        this.lazyInitBuilder();
        return new AttributeType.Builder(attributeType, this);
    }

    public DitContentRule.Builder buildDitContentRule(DitContentRule contentRule) {
        this.lazyInitBuilder();
        return new DitContentRule.Builder(contentRule, this);
    }

    public DitStructureRule.Builder buildDitStructureRule(DitStructureRule structureRule) {
        this.lazyInitBuilder();
        return new DitStructureRule.Builder(structureRule, this);
    }

    public MatchingRule.Builder buildMatchingRule(MatchingRule matchingRule) {
        this.lazyInitBuilder();
        return new MatchingRule.Builder(matchingRule, this);
    }

    public MatchingRuleUse.Builder buildMatchingRuleUse(MatchingRuleUse matchingRuleUse) {
        this.lazyInitBuilder();
        return new MatchingRuleUse.Builder(matchingRuleUse, this);
    }

    public NameForm.Builder buildNameForm(NameForm nameForm) {
        this.lazyInitBuilder();
        return new NameForm.Builder(nameForm, this);
    }

    public ObjectClass.Builder buildObjectClass(ObjectClass objectClass) {
        this.lazyInitBuilder();
        return new ObjectClass.Builder(objectClass, this);
    }

    public Syntax.Builder buildSyntax(Syntax syntax) {
        this.lazyInitBuilder();
        return new Syntax.Builder(syntax, this);
    }

    public SchemaBuilder addObjectClass(String definition, boolean overwrite) {
        return this.addObjectClass(definition, overwrite, null);
    }

    SchemaBuilder addObjectClass(String definition, boolean overwrite, SchemaBuilderHook hook) {
        Reject.ifNull(definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_EMPTY_VALUE1.get(definition));
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_EXPECTED_OPEN_PARENTHESIS1.get(definition, reader.pos() - 1, String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            String oid = SchemaUtils.readOid(reader, this.allowsMalformedNamesAndOptions());
            Set<String> superiorClasses = Collections.emptySet();
            ObjectClassType ocType = null;
            ObjectClass.Builder ocBuilder = (ObjectClass.Builder)new ObjectClass.Builder(oid, this).definition(definition);
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    ocBuilder.names(SchemaUtils.readNameDescriptors(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    ocBuilder.description(SchemaUtils.readQuotedString(reader));
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) {
                    ocBuilder.obsolete(true);
                    continue;
                }
                if ("sup".equalsIgnoreCase(tokenName)) {
                    superiorClasses = SchemaUtils.readOids(reader, this.allowsMalformedNamesAndOptions());
                    continue;
                }
                if ("abstract".equalsIgnoreCase(tokenName)) {
                    ocType = ObjectClassType.ABSTRACT;
                    continue;
                }
                if ("structural".equalsIgnoreCase(tokenName)) {
                    ocType = ObjectClassType.STRUCTURAL;
                    continue;
                }
                if ("auxiliary".equalsIgnoreCase(tokenName)) {
                    ocType = ObjectClassType.AUXILIARY;
                    continue;
                }
                if ("must".equalsIgnoreCase(tokenName)) {
                    ocBuilder.requiredAttributes(SchemaUtils.readOids(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("may".equalsIgnoreCase(tokenName)) {
                    ocBuilder.optionalAttributes(SchemaUtils.readOids(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    ocBuilder.extraProperties(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_ILLEGAL_TOKEN1.get(definition, tokenName));
            }
            if (hook != null) {
                hook.beforeAddObjectClass(ocBuilder);
            }
            if ("1.3.6.1.4.1.1466.101.120.111".equals(oid)) {
                this.addObjectClass(ObjectClass.newExtensibleObjectObjectClass(ocBuilder.getDescription(), ocBuilder.getExtraProperties(), this), overwrite);
                return this;
            }
            ocType = ocType != null ? ocType : ObjectClassType.STRUCTURAL;
            ocBuilder.superiorObjectClasses(superiorClasses).type(ocType);
            return ocBuilder.addToSchema(overwrite);
        }
        catch (DecodeException e) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_INVALID1.get(definition, e.getMessageObject()), e.getCause());
        }
    }

    public SchemaBuilder addPatternSyntax(String oid, String description, Pattern pattern, boolean overwrite) {
        Reject.ifNull(pattern);
        return this.buildSyntax(oid).description(description).extraProperties("X-PATTERN", pattern.toString()).addToSchema(overwrite);
    }

    public SchemaBuilder addSchema(Connection connection, Dn name, boolean overwrite) throws LdapException {
        SearchRequest request = SchemaBuilder.getReadSchemaSearchRequest(name);
        SearchResultEntry entry = connection.searchSingleEntry(request);
        return this.addSchema(entry, overwrite, null);
    }

    public SchemaBuilder addSchema(Entry entry, boolean overwrite) {
        return this.addSchema(entry, overwrite, null);
    }

    public SchemaBuilder addSchema(Entry entry, boolean overwrite, SchemaBuilderHook hook) {
        Reject.ifNull(entry);
        this.lazyInitBuilder();
        Attribute attr = entry.getAttribute("ldapSyntaxes");
        if (attr != null) {
            for (ByteString def : attr) {
                try {
                    this.addSyntax(def.toString(), overwrite, hook);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("attributeTypes")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addAttributeType(def.toString(), overwrite, hook);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("objectClasses")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addObjectClass(def.toString(), overwrite, hook);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("matchingRuleUse")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addMatchingRuleUse(def.toString(), overwrite, hook);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("matchingRules")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addMatchingRule(def.toString(), overwrite, hook);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("dITContentRules")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addDitContentRule(def.toString(), overwrite, hook);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("dITStructureRules")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addDitStructureRule(def.toString(), overwrite, hook);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("nameForms")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addNameForm(def.toString(), overwrite, hook);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        return this;
    }

    public SchemaBuilder addSchema(Schema schema, boolean overwrite) {
        Reject.ifNull(schema);
        this.lazyInitBuilder();
        this.addSchema0(schema, overwrite);
        return this;
    }

    public LdapPromise<SchemaBuilder> addSchemaAsync(Connection connection, Dn name, final boolean overwrite) {
        return connection.searchSingleEntryAsync(SchemaBuilder.getReadSchemaSearchRequest(name)).then(new Function<SearchResultEntry, SchemaBuilder, LdapException>(){

            @Override
            public SchemaBuilder apply(SearchResultEntry result) throws LdapException {
                SchemaBuilder.this.addSchema(result, overwrite, null);
                return SchemaBuilder.this;
            }
        });
    }

    public SchemaBuilder addSchemaForEntry(Connection connection, Dn name, boolean overwrite) throws LdapException {
        SearchRequest request = SchemaBuilder.getReadSchemaForEntrySearchRequest(name);
        SearchResultEntry entry = connection.searchSingleEntry(request);
        Dn subschemaDN = SchemaBuilder.getSubschemaSubentryDn(name, entry);
        return this.addSchema(connection, subschemaDN, overwrite);
    }

    public LdapPromise<SchemaBuilder> addSchemaForEntryAsync(final Connection connection, final Dn name, final boolean overwrite) {
        return connection.searchSingleEntryAsync(SchemaBuilder.getReadSchemaForEntrySearchRequest(name)).thenAsync(new AsyncFunction<SearchResultEntry, SchemaBuilder, LdapException>(){

            @Override
            public Promise<SchemaBuilder, LdapException> apply(SearchResultEntry result) throws LdapException {
                Dn subschemaDN = SchemaBuilder.getSubschemaSubentryDn(name, result);
                return SchemaBuilder.this.addSchemaAsync(connection, subschemaDN, overwrite);
            }
        });
    }

    public SchemaBuilder addSubstitutionSyntax(String oid, String description, String substituteSyntax, boolean overwrite) {
        Reject.ifNull(substituteSyntax);
        return this.buildSyntax(oid).description(description).extraProperties("X-SUBST", substituteSyntax).addToSchema(overwrite);
    }

    public SchemaBuilder addSyntax(String definition, boolean overwrite) {
        return this.addSyntax(definition, overwrite, null);
    }

    SchemaBuilder addSyntax(String definition, boolean overwrite, SchemaBuilderHook hook) {
        Reject.ifNull(definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EMPTY_VALUE1.get(definition));
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXPECTED_OPEN_PARENTHESIS.get(definition, reader.pos() - 1, String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            String oid = SchemaUtils.readOid(reader, this.allowsMalformedNamesAndOptions());
            Syntax.Builder syntaxBuilder = (Syntax.Builder)new Syntax.Builder(oid, this).definition(definition);
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("desc".equalsIgnoreCase(tokenName)) {
                    syntaxBuilder.description(SchemaUtils.readQuotedString(reader));
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    syntaxBuilder.extraProperties(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_ILLEGAL_TOKEN1.get(definition, tokenName));
            }
            if (hook != null) {
                hook.beforeAddSyntax(syntaxBuilder);
            }
            syntaxBuilder.addToSchema(overwrite);
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_INVALID1.get(definition, e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
        return this;
    }

    Options getOptions() {
        this.lazyInitBuilder();
        return this.options;
    }

    public boolean removeAttributeType(String nameOrOid) {
        this.lazyInitBuilder();
        AttributeType element = this.numericOid2AttributeTypes.get(nameOrOid);
        if (element != null) {
            this.removeAttributeType(element, null);
            return true;
        }
        List<AttributeType> elements = this.name2AttributeTypes.get(StaticUtils.toLowerCase(nameOrOid));
        if (elements != null) {
            for (AttributeType e : elements) {
                this.removeAttributeType(e, null);
            }
            return true;
        }
        return false;
    }

    public boolean removeDitContentRule(String nameOrOid) {
        this.lazyInitBuilder();
        DitContentRule element = this.numericOid2ContentRules.get(nameOrOid);
        if (element != null) {
            this.removeDitContentRule(element, null);
            return true;
        }
        List<DitContentRule> elements = this.name2ContentRules.get(StaticUtils.toLowerCase(nameOrOid));
        if (elements != null) {
            for (DitContentRule e : elements) {
                this.removeDitContentRule(e, null);
            }
            return true;
        }
        return false;
    }

    public boolean removeDitStructureRule(int ruleId) {
        this.lazyInitBuilder();
        DitStructureRule element = this.id2StructureRules.get(ruleId);
        if (element != null) {
            this.removeDitStructureRule(element, null);
            return true;
        }
        return false;
    }

    public boolean removeMatchingRule(String nameOrOid) {
        this.lazyInitBuilder();
        MatchingRule element = this.numericOid2MatchingRules.get(nameOrOid);
        if (element != null) {
            this.removeMatchingRule(element, null);
            return true;
        }
        List<MatchingRule> elements = this.name2MatchingRules.get(StaticUtils.toLowerCase(nameOrOid));
        if (elements != null) {
            for (MatchingRule e : elements) {
                this.removeMatchingRule(e, null);
            }
            return true;
        }
        return false;
    }

    public boolean removeMatchingRuleUse(String nameOrOid) {
        this.lazyInitBuilder();
        MatchingRuleUse element = this.numericOid2MatchingRuleUses.get(nameOrOid);
        if (element != null) {
            this.removeMatchingRuleUse(element, null);
            return true;
        }
        List<MatchingRuleUse> elements = this.name2MatchingRuleUses.get(StaticUtils.toLowerCase(nameOrOid));
        if (elements != null) {
            for (MatchingRuleUse e : elements) {
                this.removeMatchingRuleUse(e, null);
            }
            return true;
        }
        return false;
    }

    public boolean removeNameForm(String nameOrOid) {
        this.lazyInitBuilder();
        NameForm element = this.numericOid2NameForms.get(nameOrOid);
        if (element != null) {
            this.removeNameForm(element, null);
            return true;
        }
        List<NameForm> elements = this.name2NameForms.get(StaticUtils.toLowerCase(nameOrOid));
        if (elements != null) {
            for (NameForm e : elements) {
                this.removeNameForm(e, null);
            }
            return true;
        }
        return false;
    }

    public boolean removeObjectClass(String nameOrOid) {
        this.lazyInitBuilder();
        ObjectClass element = this.numericOid2ObjectClasses.get(nameOrOid);
        if (element != null) {
            this.removeObjectClass(element, null);
            return true;
        }
        List<ObjectClass> elements = this.name2ObjectClasses.get(StaticUtils.toLowerCase(nameOrOid));
        if (elements != null) {
            for (ObjectClass e : elements) {
                this.removeObjectClass(e, null);
            }
            return true;
        }
        return false;
    }

    public boolean removeSyntax(String numericOid) {
        this.lazyInitBuilder();
        Syntax element = this.numericOid2Syntaxes.get(numericOid);
        if (element != null) {
            this.removeSyntax(element, null);
            return true;
        }
        return false;
    }

    public <T> SchemaBuilder setOption(Option<T> option, T value) {
        this.getOptions().set(option, value);
        return this;
    }

    public Schema toSchema() {
        MatchingRule defaultMatchingRule;
        if (this.copyOnWriteSchema != null) {
            return this.copyOnWriteSchema;
        }
        this.lazyInitBuilder();
        String localSchemaName = this.schemaName != null ? this.schemaName + "-" + NEXT_SCHEMA_ID.getAndIncrement() : "Schema#" + NEXT_SCHEMA_ID.getAndIncrement();
        Syntax defaultSyntax = this.numericOid2Syntaxes.get(this.options.get(SchemaOptions.DEFAULT_SYNTAX_OID));
        if (defaultSyntax == null) {
            defaultSyntax = Schema.getCoreSchema().getDefaultSyntax();
        }
        if ((defaultMatchingRule = this.numericOid2MatchingRules.get(this.options.get(SchemaOptions.DEFAULT_MATCHING_RULE_OID))) == null) {
            defaultMatchingRule = Schema.getCoreSchema().getDefaultMatchingRule();
        }
        NamesMapping names = new NamesMapping(this.removeDuplicateMatchingRulesNames(), this.removeDuplicateMatchingRuleUsesNames(), this.removeDuplicateAttributeTypesNames(), this.removeDuplicateObjectClassesNames(), this.removeDuplicateNameFormsNames(), this.removeDuplicateDitContentRulesNames(), this.removeDuplicateDitStructureRulesNames());
        Schema schema = new Schema.StrictImpl(localSchemaName, this.options, defaultSyntax, defaultMatchingRule, this.numericOid2Syntaxes, this.numericOid2MatchingRules, this.numericOid2MatchingRuleUses, this.numericOid2AttributeTypes, this.numericOid2ObjectClasses, this.numericOid2NameForms, this.numericOid2ContentRules, this.id2StructureRules, names.name2MatchingRules, names.name2MatchingRuleUses, names.name2AttributeTypes, names.name2ObjectClasses, names.name2NameForms, names.name2ContentRules, names.name2StructureRules, this.objectClass2NameForms, this.nameForm2StructureRules, this.warnings).asStrictSchema();
        this.validate(schema, names);
        this.preLazyInitBuilder(this.schemaName, schema);
        return schema;
    }

    SchemaBuilder addAttributeType(AttributeType attribute, boolean overwrite) {
        if (this.numericOid2AttributeTypes.containsKey(attribute.getOid())) {
            AttributeType conflictingAttribute = this.numericOid2AttributeTypes.get(attribute.getOid());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_ATTRIBUTE_OID.get(attribute.getNameOrOid(), attribute.getOid(), conflictingAttribute.getNameOrOid());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeAttributeType(conflictingAttribute, null);
        }
        this.numericOid2AttributeTypes.put(attribute.getOid(), attribute);
        for (String name : attribute.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<AttributeType> attrs = this.name2AttributeTypes.get(lowerName);
            if (attrs == null) {
                this.name2AttributeTypes.put(lowerName, Collections.singletonList(attribute));
                continue;
            }
            if (attrs.size() == 1) {
                attrs = new ArrayList<AttributeType>(attrs);
                attrs.add(attribute);
                this.name2AttributeTypes.put(lowerName, attrs);
                continue;
            }
            attrs.add(attribute);
        }
        return this;
    }

    SchemaBuilder addDitContentRule(DitContentRule rule, boolean overwrite) {
        if (this.numericOid2ContentRules.containsKey(rule.getStructuralClassOid())) {
            DitContentRule conflictingRule = this.numericOid2ContentRules.get(rule.getStructuralClassOid());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_DIT_CONTENT_RULE1.get(rule.getNameOrOid(), rule.getStructuralClassOid(), conflictingRule.getNameOrOid());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeDitContentRule(conflictingRule, null);
        }
        this.numericOid2ContentRules.put(rule.getStructuralClassOid(), rule);
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<DitContentRule> rules = this.name2ContentRules.get(lowerName);
            if (rules == null) {
                this.name2ContentRules.put(lowerName, Collections.singletonList(rule));
                continue;
            }
            if (rules.size() == 1) {
                rules = new ArrayList<DitContentRule>(rules);
                rules.add(rule);
                this.name2ContentRules.put(lowerName, rules);
                continue;
            }
            rules.add(rule);
        }
        return this;
    }

    SchemaBuilder addDitStructureRule(DitStructureRule rule, boolean overwrite) {
        if (this.id2StructureRules.containsKey(rule.getRuleId())) {
            DitStructureRule conflictingRule = this.id2StructureRules.get(rule.getRuleId());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_DIT_STRUCTURE_RULE_ID.get(rule.getNameOrRuleId(), rule.getRuleId(), conflictingRule.getNameOrRuleId());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeDitStructureRule(conflictingRule, null);
        }
        this.id2StructureRules.put(rule.getRuleId(), rule);
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<DitStructureRule> rules = this.name2StructureRules.get(lowerName);
            if (rules == null) {
                this.name2StructureRules.put(lowerName, Collections.singletonList(rule));
                continue;
            }
            if (rules.size() == 1) {
                rules = new ArrayList<DitStructureRule>(rules);
                rules.add(rule);
                this.name2StructureRules.put(lowerName, rules);
                continue;
            }
            rules.add(rule);
        }
        return this;
    }

    SchemaBuilder addMatchingRuleUse(MatchingRuleUse use, boolean overwrite) {
        if (this.numericOid2MatchingRuleUses.containsKey(use.getMatchingRuleOid())) {
            MatchingRuleUse conflictingUse = this.numericOid2MatchingRuleUses.get(use.getMatchingRuleOid());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_MATCHING_RULE_USE.get(use.getNameOrOid(), use.getMatchingRuleOid(), conflictingUse.getNameOrOid());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeMatchingRuleUse(conflictingUse, null);
        }
        this.numericOid2MatchingRuleUses.put(use.getMatchingRuleOid(), use);
        for (String name : use.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<MatchingRuleUse> uses = this.name2MatchingRuleUses.get(lowerName);
            if (uses == null) {
                this.name2MatchingRuleUses.put(lowerName, Collections.singletonList(use));
                continue;
            }
            if (uses.size() == 1) {
                uses = new ArrayList<MatchingRuleUse>(uses);
                uses.add(use);
                this.name2MatchingRuleUses.put(lowerName, uses);
                continue;
            }
            uses.add(use);
        }
        return this;
    }

    SchemaBuilder addMatchingRule(MatchingRule rule, boolean overwrite) {
        Reject.ifTrue(rule.isValidated(), "Matching rule has already been validated, it can't be added");
        if (this.numericOid2MatchingRules.containsKey(rule.getOid())) {
            MatchingRule conflictingRule = this.numericOid2MatchingRules.get(rule.getOid());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_MR_OID.get(rule.getNameOrOid(), rule.getOid(), conflictingRule.getNameOrOid());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeMatchingRule(conflictingRule, null);
        }
        this.numericOid2MatchingRules.put(rule.getOid(), rule);
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<MatchingRule> rules = this.name2MatchingRules.get(lowerName);
            if (rules == null) {
                this.name2MatchingRules.put(lowerName, Collections.singletonList(rule));
                continue;
            }
            if (rules.size() == 1) {
                rules = new ArrayList<MatchingRule>(rules);
                rules.add(rule);
                this.name2MatchingRules.put(lowerName, rules);
                continue;
            }
            rules.add(rule);
        }
        return this;
    }

    SchemaBuilder addNameForm(NameForm form, boolean overwrite) {
        if (this.numericOid2NameForms.containsKey(form.getOid())) {
            NameForm conflictingForm = this.numericOid2NameForms.get(form.getOid());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_NAME_FORM_OID.get(form.getNameOrOid(), form.getOid(), conflictingForm.getNameOrOid());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeNameForm(conflictingForm, null);
        }
        this.numericOid2NameForms.put(form.getOid(), form);
        for (String name : form.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<NameForm> forms = this.name2NameForms.get(lowerName);
            if (forms == null) {
                this.name2NameForms.put(lowerName, Collections.singletonList(form));
                continue;
            }
            if (forms.size() == 1) {
                forms = new ArrayList<NameForm>(forms);
                forms.add(form);
                this.name2NameForms.put(lowerName, forms);
                continue;
            }
            forms.add(form);
        }
        return this;
    }

    SchemaBuilder addObjectClass(ObjectClass oc, boolean overwrite) {
        if (this.numericOid2ObjectClasses.containsKey(oc.getOid())) {
            ObjectClass conflictingOC = this.numericOid2ObjectClasses.get(oc.getOid());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_OBJECTCLASS_OID1.get(oc.getNameOrOid(), oc.getOid(), conflictingOC.getNameOrOid());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeObjectClass(conflictingOC, null);
        }
        this.numericOid2ObjectClasses.put(oc.getOid(), oc);
        for (String name : oc.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<ObjectClass> classes = this.name2ObjectClasses.get(lowerName);
            if (classes == null) {
                this.name2ObjectClasses.put(lowerName, Collections.singletonList(oc));
                continue;
            }
            if (classes.size() == 1) {
                classes = new ArrayList<ObjectClass>(classes);
                classes.add(oc);
                this.name2ObjectClasses.put(lowerName, classes);
                continue;
            }
            classes.add(oc);
        }
        return this;
    }

    private void addSchema0(Schema schema, boolean overwrite) {
        for (Syntax syntax : schema.getSyntaxes()) {
            this.buildSyntax(syntax).addToSchema(overwrite);
        }
        for (MatchingRule matchingRule : schema.getMatchingRules()) {
            this.buildMatchingRule(matchingRule).addToSchema(overwrite);
        }
        for (MatchingRuleUse matchingRuleUse : schema.getMatchingRuleUses()) {
            this.buildMatchingRuleUse(matchingRuleUse).addToSchema(overwrite);
        }
        for (AttributeType attributeType : schema.getAttributeTypes()) {
            this.buildAttributeType(attributeType).addToSchema(overwrite);
        }
        for (ObjectClass objectClass : schema.getObjectClasses()) {
            this.buildObjectClass(objectClass).addToSchema(overwrite);
        }
        for (NameForm nameForm : schema.getNameForms()) {
            this.buildNameForm(nameForm).addToSchema(overwrite);
        }
        for (DitContentRule contentRule : schema.getDitContentRules()) {
            this.buildDitContentRule(contentRule).addToSchema(overwrite);
        }
        for (DitStructureRule structureRule : schema.getDitStuctureRules()) {
            this.buildDitStructureRule(structureRule).addToSchema(overwrite);
        }
    }

    SchemaBuilder addSyntax(Syntax syntax, boolean overwrite) {
        Reject.ifTrue(syntax.isValidated(), "Syntax has already been validated, it can't be added");
        if (this.numericOid2Syntaxes.containsKey(syntax.getOid())) {
            Syntax conflictingSyntax = this.numericOid2Syntaxes.get(syntax.getOid());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_SYNTAX_OID.get(syntax, syntax.getOid(), conflictingSyntax.getOid());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeSyntax(conflictingSyntax, null);
        }
        this.numericOid2Syntaxes.put(syntax.getOid(), syntax);
        return this;
    }

    private void lazyInitBuilder() {
        if (this.numericOid2Syntaxes == null) {
            this.options = Options.defaultOptions();
            this.numericOid2Syntaxes = new LinkedHashMap<String, Syntax>();
            this.numericOid2MatchingRules = new LinkedHashMap<String, MatchingRule>();
            this.numericOid2MatchingRuleUses = new LinkedHashMap<String, MatchingRuleUse>();
            this.numericOid2AttributeTypes = new LinkedHashMap<String, AttributeType>();
            this.numericOid2ObjectClasses = new LinkedHashMap<String, ObjectClass>();
            this.numericOid2NameForms = new LinkedHashMap<String, NameForm>();
            this.numericOid2ContentRules = new LinkedHashMap<String, DitContentRule>();
            this.id2StructureRules = new LinkedHashMap<Integer, DitStructureRule>();
            this.name2MatchingRules = new LinkedHashMap<String, List<MatchingRule>>();
            this.name2MatchingRuleUses = new LinkedHashMap<String, List<MatchingRuleUse>>();
            this.name2AttributeTypes = new LinkedHashMap<String, List<AttributeType>>();
            this.name2ObjectClasses = new LinkedHashMap<String, List<ObjectClass>>();
            this.name2NameForms = new LinkedHashMap<String, List<NameForm>>();
            this.name2ContentRules = new LinkedHashMap<String, List<DitContentRule>>();
            this.name2StructureRules = new LinkedHashMap<String, List<DitStructureRule>>();
            this.objectClass2NameForms = new HashMap<String, List<NameForm>>();
            this.nameForm2StructureRules = new HashMap<String, List<DitStructureRule>>();
            this.warnings = new LinkedList<LocalizableMessage>();
            if (this.copyOnWriteSchema != null) {
                this.addSchema0(this.copyOnWriteSchema, true);
                this.options = Options.copyOf(this.copyOnWriteSchema.getOptions());
                this.copyOnWriteSchema = null;
            }
        }
    }

    private void preLazyInitBuilder(String schemaName, Schema copyOnWriteSchema) {
        this.schemaName = schemaName;
        this.copyOnWriteSchema = copyOnWriteSchema;
        this.options = null;
        this.numericOid2Syntaxes = null;
        this.numericOid2MatchingRules = null;
        this.numericOid2MatchingRuleUses = null;
        this.numericOid2AttributeTypes = null;
        this.numericOid2ObjectClasses = null;
        this.numericOid2NameForms = null;
        this.numericOid2ContentRules = null;
        this.id2StructureRules = null;
        this.name2MatchingRules = null;
        this.name2MatchingRuleUses = null;
        this.name2AttributeTypes = null;
        this.name2ObjectClasses = null;
        this.name2NameForms = null;
        this.name2ContentRules = null;
        this.name2StructureRules = null;
        this.objectClass2NameForms = null;
        this.nameForm2StructureRules = null;
        this.warnings = null;
    }

    private void removeAttributeType(AttributeType attributeType, NamesMapping names) {
        this.numericOid2AttributeTypes.remove(attributeType.getOid());
        for (String name : attributeType.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<AttributeType> attributes = this.name2AttributeTypes.get(lowerName);
            if (attributes != null && attributes.contains(attributeType)) {
                if (attributes.size() <= 1) {
                    this.name2AttributeTypes.remove(lowerName);
                } else {
                    attributes.remove(attributeType);
                }
            }
            if (names == null) continue;
            names.name2AttributeTypes.remove(lowerName);
        }
    }

    private void removeDitContentRule(DitContentRule rule, NamesMapping names) {
        this.numericOid2ContentRules.remove(rule.getStructuralClassOid());
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<DitContentRule> rules = this.name2ContentRules.get(lowerName);
            if (rules != null && rules.contains(rule)) {
                if (rules.size() <= 1) {
                    this.name2ContentRules.remove(lowerName);
                } else {
                    rules.remove(rule);
                }
            }
            if (names == null) continue;
            names.name2ContentRules.remove(lowerName);
        }
    }

    private void removeDitStructureRule(DitStructureRule rule, NamesMapping names) {
        this.id2StructureRules.remove(rule.getRuleId());
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<DitStructureRule> rules = this.name2StructureRules.get(lowerName);
            if (rules != null && rules.contains(rule)) {
                if (rules.size() <= 1) {
                    this.name2StructureRules.remove(lowerName);
                } else {
                    rules.remove(rule);
                }
            }
            if (names == null) continue;
            names.name2StructureRules.remove(lowerName);
        }
    }

    private void removeMatchingRule(MatchingRule rule, NamesMapping names) {
        this.numericOid2MatchingRules.remove(rule.getOid());
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<MatchingRule> rules = this.name2MatchingRules.get(lowerName);
            if (rules != null && rules.contains(rule)) {
                if (rules.size() <= 1) {
                    this.name2MatchingRules.remove(lowerName);
                } else {
                    rules.remove(rule);
                }
            }
            if (names == null) continue;
            names.name2MatchingRules.remove(lowerName);
        }
    }

    private void removeMatchingRuleUse(MatchingRuleUse use, NamesMapping names) {
        this.numericOid2MatchingRuleUses.remove(use.getMatchingRuleOid());
        for (String name : use.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<MatchingRuleUse> uses = this.name2MatchingRuleUses.get(lowerName);
            if (uses != null && uses.contains(use)) {
                if (uses.size() <= 1) {
                    this.name2MatchingRuleUses.remove(lowerName);
                } else {
                    uses.remove(use);
                }
            }
            if (names == null) continue;
            names.name2MatchingRuleUses.remove(lowerName);
        }
    }

    private void removeNameForm(NameForm form, NamesMapping names) {
        this.numericOid2NameForms.remove(form.getOid());
        this.name2NameForms.remove(form.getOid());
        for (String name : form.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<NameForm> forms = this.name2NameForms.get(lowerName);
            if (forms != null && forms.contains(form)) {
                if (forms.size() <= 1) {
                    this.name2NameForms.remove(lowerName);
                } else {
                    forms.remove(form);
                }
            }
            if (names == null) continue;
            names.name2NameForms.remove(lowerName);
        }
    }

    private void removeObjectClass(ObjectClass oc, NamesMapping names) {
        this.numericOid2ObjectClasses.remove(oc.getOid());
        this.name2ObjectClasses.remove(oc.getOid());
        for (String name : oc.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<ObjectClass> classes = this.name2ObjectClasses.get(lowerName);
            if (classes != null && classes.contains(oc)) {
                if (classes.size() <= 1) {
                    this.name2ObjectClasses.remove(lowerName);
                } else {
                    classes.remove(oc);
                }
            }
            if (names == null) continue;
            names.name2ObjectClasses.remove(lowerName);
        }
    }

    private void removeSyntax(Syntax syntax, NamesMapping names) {
        for (Map.Entry<String, List<String>> property : syntax.getExtraProperties().entrySet()) {
            if (!"x-enum".equalsIgnoreCase(property.getKey())) continue;
            this.removeMatchingRule("1.3.6.1.4.1.26027.1.4.8." + syntax.getOid());
            break;
        }
        this.numericOid2Syntaxes.remove(syntax.getOid());
    }

    private void validate(Schema schema, NamesMapping names) {
        for (Syntax syntax : this.numericOid2Syntaxes.values().toArray(new Syntax[this.numericOid2Syntaxes.values().size()])) {
            try {
                syntax.validate(schema, this.warnings);
            }
            catch (SchemaException e) {
                this.removeSyntax(syntax, names);
                this.warnings.add(CoreMessages.ERR_SYNTAX_VALIDATION_FAIL.get(syntax, e.getMessageObject()));
            }
        }
        for (AbstractSchemaElement abstractSchemaElement : this.numericOid2MatchingRules.values().toArray(new MatchingRule[this.numericOid2MatchingRules.values().size()])) {
            try {
                ((MatchingRule)abstractSchemaElement).validate(schema, this.warnings);
            }
            catch (SchemaException e) {
                this.removeMatchingRule((MatchingRule)abstractSchemaElement, names);
                this.warnings.add(CoreMessages.ERR_MR_VALIDATION_FAIL.get(abstractSchemaElement, e.getMessageObject()));
            }
        }
        LinkedList<AttributeType> invalidAttributeTypes = new LinkedList<AttributeType>();
        for (AttributeType attributeType : this.numericOid2AttributeTypes.values()) {
            attributeType.validate(schema, invalidAttributeTypes, this.warnings);
        }
        for (AttributeType attributeType : invalidAttributeTypes) {
            this.removeAttributeType(attributeType, names);
        }
        LinkedList<ObjectClass> invalidObjectClasses = new LinkedList<ObjectClass>();
        for (ObjectClass objectClass : this.numericOid2ObjectClasses.values()) {
            objectClass.validate(schema, invalidObjectClasses, this.warnings);
        }
        for (ObjectClass objectClass : invalidObjectClasses) {
            this.removeObjectClass(objectClass, names);
        }
        for (MatchingRuleUse matchingRuleUse : this.numericOid2MatchingRuleUses.values().toArray(new MatchingRuleUse[this.numericOid2MatchingRuleUses.values().size()])) {
            try {
                matchingRuleUse.validate(schema, this.warnings);
            }
            catch (SchemaException e) {
                this.removeMatchingRuleUse(matchingRuleUse, names);
                this.warnings.add(CoreMessages.ERR_MRU_VALIDATION_FAIL.get(matchingRuleUse, e.getMessageObject()));
            }
        }
        for (AbstractSchemaElement abstractSchemaElement : this.numericOid2NameForms.values().toArray(new NameForm[this.numericOid2NameForms.values().size()])) {
            try {
                ((NameForm)abstractSchemaElement).validate(schema, this.warnings);
                String ocOID = ((NameForm)abstractSchemaElement).getStructuralClass().getOid();
                List<NameForm> forms = this.objectClass2NameForms.get(ocOID);
                if (forms == null) {
                    this.objectClass2NameForms.put(ocOID, Collections.singletonList(abstractSchemaElement));
                    continue;
                }
                if (forms.size() == 1) {
                    forms = new ArrayList<NameForm>(forms);
                    forms.add((NameForm)abstractSchemaElement);
                    this.objectClass2NameForms.put(ocOID, forms);
                    continue;
                }
                forms.add((NameForm)abstractSchemaElement);
            }
            catch (SchemaException e) {
                this.removeNameForm((NameForm)abstractSchemaElement, names);
                this.warnings.add(CoreMessages.ERR_NAMEFORM_VALIDATION_FAIL.get(abstractSchemaElement, e.getMessageObject()));
            }
        }
        for (AbstractSchemaElement abstractSchemaElement : this.numericOid2ContentRules.values().toArray(new DitContentRule[this.numericOid2ContentRules.values().size()])) {
            try {
                ((DitContentRule)abstractSchemaElement).validate(schema, this.warnings);
            }
            catch (SchemaException e) {
                this.removeDitContentRule((DitContentRule)abstractSchemaElement, names);
                this.warnings.add(CoreMessages.ERR_DCR_VALIDATION_FAIL.get(abstractSchemaElement, e.getMessageObject()));
            }
        }
        LinkedList<DitStructureRule> invalidStructureRules = new LinkedList<DitStructureRule>();
        for (DitStructureRule rule : this.id2StructureRules.values()) {
            rule.validate(schema, invalidStructureRules, this.warnings);
        }
        for (DitStructureRule rule : invalidStructureRules) {
            this.removeDitStructureRule(rule, names);
        }
        for (DitStructureRule rule : this.id2StructureRules.values()) {
            String string = rule.getNameForm().getOid();
            List<DitStructureRule> rules = this.nameForm2StructureRules.get(string);
            if (rules == null) {
                this.nameForm2StructureRules.put(string, Collections.singletonList(rule));
                continue;
            }
            if (rules.size() == 1) {
                rules = new ArrayList<DitStructureRule>(rules);
                rules.add(rule);
                this.nameForm2StructureRules.put(string, rules);
                continue;
            }
            rules.add(rule);
        }
    }

    private Map<String, MatchingRule> removeDuplicateMatchingRulesNames() {
        Map<String, MatchingRule> names = this.newMap(this.name2MatchingRules.size());
        for (Map.Entry<String, List<MatchingRule>> entry : this.name2MatchingRules.entrySet()) {
            List<MatchingRule> rules = entry.getValue();
            if (rules.size() > 1) {
                StringBuilder oids = new StringBuilder();
                for (MatchingRule attr : rules) {
                    if (oids.length() > 0) {
                        oids.append(", ");
                    }
                    oids.append(attr.getOid());
                }
                String name = entry.getKey();
                this.warnings.add(CoreMessages.WARN_MATCHING_RULES_DUPLICATED_NAME.get(oids, name, name, rules.get(0).getOid()));
            }
            if (rules.isEmpty()) continue;
            names.put(entry.getKey(), rules.get(0));
        }
        return names;
    }

    private Map<String, MatchingRuleUse> removeDuplicateMatchingRuleUsesNames() {
        Map<String, MatchingRuleUse> names = this.newMap(this.name2MatchingRuleUses.size());
        for (Map.Entry<String, List<MatchingRuleUse>> entry : this.name2MatchingRuleUses.entrySet()) {
            List<MatchingRuleUse> uses = entry.getValue();
            if (uses.size() > 1) {
                StringBuilder oids = new StringBuilder();
                for (MatchingRuleUse attr : uses) {
                    if (oids.length() > 0) {
                        oids.append(", ");
                    }
                    oids.append(attr.getMatchingRuleOid());
                }
                String name = entry.getKey();
                this.warnings.add(CoreMessages.WARN_MATCHING_RULE_USES_DUPLICATED_NAME.get(oids, name, name, uses.get(0).getMatchingRuleOid()));
            }
            if (uses.isEmpty()) continue;
            names.put(entry.getKey(), uses.get(0));
        }
        return names;
    }

    private Map<String, AttributeType> removeDuplicateAttributeTypesNames() {
        Map<String, AttributeType> names = this.newMap(this.name2AttributeTypes.size());
        for (Map.Entry<String, List<AttributeType>> entry : this.name2AttributeTypes.entrySet()) {
            List<AttributeType> types = entry.getValue();
            if (types.size() > 1) {
                StringBuilder oids = new StringBuilder();
                for (AttributeType attr : types) {
                    if (oids.length() > 0) {
                        oids.append(", ");
                    }
                    oids.append(attr.getOid());
                }
                String name = entry.getKey();
                this.warnings.add(CoreMessages.WARN_ATTR_TYPES_DUPLICATED_NAME.get(oids, name, name, types.get(0).getOid()));
            }
            if (types.isEmpty()) continue;
            names.put(entry.getKey(), types.get(0));
        }
        return names;
    }

    private Map<String, ObjectClass> removeDuplicateObjectClassesNames() {
        Map<String, ObjectClass> names = this.newMap(this.name2ObjectClasses.size());
        for (Map.Entry<String, List<ObjectClass>> entry : this.name2ObjectClasses.entrySet()) {
            List<ObjectClass> classes = entry.getValue();
            if (classes.size() > 1) {
                StringBuilder oids = new StringBuilder();
                for (ObjectClass attr : classes) {
                    if (oids.length() > 0) {
                        oids.append(", ");
                    }
                    oids.append(attr.getOid());
                }
                String name = entry.getKey();
                this.warnings.add(CoreMessages.WARN_CLASSES_DUPLICATED_NAME.get(oids, name, name, classes.get(0).getOid()));
            }
            if (classes.isEmpty()) continue;
            names.put(entry.getKey(), classes.get(0));
        }
        return names;
    }

    private Map<String, NameForm> removeDuplicateNameFormsNames() {
        Map<String, NameForm> names = this.newMap(this.name2NameForms.size());
        for (Map.Entry<String, List<NameForm>> entry : this.name2NameForms.entrySet()) {
            List<NameForm> forms = entry.getValue();
            if (forms.size() > 1) {
                StringBuilder oids = new StringBuilder();
                for (NameForm attr : forms) {
                    if (oids.length() > 0) {
                        oids.append(", ");
                    }
                    oids.append(attr.getOid());
                }
                String name = entry.getKey();
                this.warnings.add(CoreMessages.WARN_NAME_FORMS_DUPLICATED_NAME.get(oids, name, name, forms.get(0).getOid()));
            }
            if (forms.isEmpty()) continue;
            names.put(entry.getKey(), forms.get(0));
        }
        return names;
    }

    private Map<String, DitStructureRule> removeDuplicateDitStructureRulesNames() {
        Map<String, DitStructureRule> names = this.newMap(this.name2StructureRules.size());
        for (Map.Entry<String, List<DitStructureRule>> entry : this.name2StructureRules.entrySet()) {
            List<DitStructureRule> rules = entry.getValue();
            if (rules.size() > 1) {
                StringBuilder ids = new StringBuilder();
                for (DitStructureRule attr : rules) {
                    if (ids.length() > 0) {
                        ids.append(", ");
                    }
                    ids.append(attr.getRuleId());
                }
                String name = entry.getKey();
                this.warnings.add(CoreMessages.WARN_DIT_SR_DUPLICATED_NAME.get(ids, name, name, rules.get(0).getRuleId()));
            }
            if (rules.isEmpty()) continue;
            names.put(entry.getKey(), rules.get(0));
        }
        return names;
    }

    private Map<String, DitContentRule> removeDuplicateDitContentRulesNames() {
        Map<String, DitContentRule> names = this.newMap(this.name2ContentRules.size());
        for (Map.Entry<String, List<DitContentRule>> entry : this.name2ContentRules.entrySet()) {
            List<DitContentRule> rules = entry.getValue();
            if (rules.size() > 1) {
                StringBuilder ids = new StringBuilder();
                for (DitContentRule attr : rules) {
                    if (ids.length() > 0) {
                        ids.append(", ");
                    }
                    ids.append(attr.getStructuralClassOid());
                }
                String name = entry.getKey();
                this.warnings.add(CoreMessages.WARN_DIT_CR_DUPLICATED_NAME.get(ids, name, name, rules.get(0).getStructuralClassOid()));
            }
            if (rules.isEmpty()) continue;
            names.put(entry.getKey(), rules.get(0));
        }
        return names;
    }

    private <T extends SchemaElement> Map<String, T> newMap(int size) {
        return new HashMap((int)((double)size / 0.75 + 1.0));
    }

    private static final class NamesMapping {
        final Map<String, MatchingRule> name2MatchingRules;
        final Map<String, MatchingRuleUse> name2MatchingRuleUses;
        final Map<String, AttributeType> name2AttributeTypes;
        final Map<String, ObjectClass> name2ObjectClasses;
        final Map<String, NameForm> name2NameForms;
        final Map<String, DitContentRule> name2ContentRules;
        final Map<String, DitStructureRule> name2StructureRules;

        NamesMapping(Map<String, MatchingRule> name2MatchingRules, Map<String, MatchingRuleUse> name2MatchingRuleUses, Map<String, AttributeType> name2AttributeTypes, Map<String, ObjectClass> name2ObjectClasses, Map<String, NameForm> name2NameForms, Map<String, DitContentRule> name2ContentRules, Map<String, DitStructureRule> name2StructureRules) {
            this.name2MatchingRules = name2MatchingRules;
            this.name2MatchingRuleUses = name2MatchingRuleUses;
            this.name2AttributeTypes = name2AttributeTypes;
            this.name2ObjectClasses = name2ObjectClasses;
            this.name2NameForms = name2NameForms;
            this.name2ContentRules = name2ContentRules;
            this.name2StructureRules = name2StructureRules;
        }
    }

    public static interface SchemaBuilderHook {
        public void beforeAddSyntax(Syntax.Builder var1);

        public void beforeAddAttribute(AttributeType.Builder var1);

        public void beforeAddObjectClass(ObjectClass.Builder var1);

        public void beforeAddMatchingRuleUse(MatchingRuleUse.Builder var1);

        public void beforeAddMatchingRule(MatchingRule.Builder var1);

        public void beforeAddDitContentRule(DitContentRule.Builder var1);

        public void beforeAddDitStructureRule(DitStructureRule.Builder var1);

        public void beforeAddNameForm(NameForm.Builder var1);
    }
}

