/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.util.HashSet;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.PrintableStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class FacsimileNumberSyntaxImpl
extends AbstractSyntaxImpl {
    public static final HashSet<String> ALLOWED_FAX_PARAMETERS = new HashSet(7);

    FacsimileNumberSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.2";
    }

    @Override
    public String getName() {
        return "FacsimileTelephoneNumber";
    }

    @Override
    public String getOrderingMatchingRule() {
        return "2.5.13.3";
    }

    @Override
    public String getSubstringMatchingRule() {
        return "2.5.13.4";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String paramStr;
        int pos;
        String valueString = StaticUtils.toLowerCase(value.toString());
        int valueLength = valueString.length();
        if (valueLength == 0) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_FAXNUMBER_EMPTY.get());
            return false;
        }
        char c = valueString.charAt(0);
        if (!PrintableStringSyntaxImpl.isPrintableCharacter(c)) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_FAXNUMBER_NOT_PRINTABLE.get(valueString, String.valueOf(c), 0));
            return false;
        }
        for (pos = 1; pos < valueLength; ++pos) {
            c = valueString.charAt(pos);
            if (c == '$') {
                ++pos;
                break;
            }
            if (PrintableStringSyntaxImpl.isPrintableCharacter(c)) continue;
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_FAXNUMBER_NOT_PRINTABLE.get(valueString, Character.valueOf(c), pos));
        }
        if (pos >= valueLength) {
            if (c == '$') {
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_FAXNUMBER_END_WITH_DOLLAR.get(valueString));
                return false;
            }
            return true;
        }
        int paramStartPos = pos;
        while (pos < valueLength) {
            if ((c = valueString.charAt(pos++)) != '$') continue;
            paramStr = valueString.substring(paramStartPos, pos);
            if (!ALLOWED_FAX_PARAMETERS.contains(paramStr)) {
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_FAXNUMBER_ILLEGAL_PARAMETER.get(valueString, paramStr, paramStartPos, pos - 1));
                return false;
            }
            paramStartPos = pos;
        }
        paramStr = valueString.substring(paramStartPos);
        if (!ALLOWED_FAX_PARAMETERS.contains(paramStr)) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_FAXNUMBER_ILLEGAL_PARAMETER.get(valueString, paramStr, paramStartPos, pos - 1));
            return false;
        }
        return true;
    }

    static {
        ALLOWED_FAX_PARAMETERS.add("twodimensional");
        ALLOWED_FAX_PARAMETERS.add("fineresolution");
        ALLOWED_FAX_PARAMETERS.add("unlimitedlength");
        ALLOWED_FAX_PARAMETERS.add("b4length");
        ALLOWED_FAX_PARAMETERS.add("a3width");
        ALLOWED_FAX_PARAMETERS.add("b4width");
        ALLOWED_FAX_PARAMETERS.add("uncompressed");
    }
}

