/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.SubstringReader;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class DitContentRuleSyntaxImpl
extends AbstractSyntaxImpl {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();

    DitContentRuleSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "objectIdentifierFirstComponentMatch";
    }

    @Override
    public String getName() {
        return "DITContentRuleDescription";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String definition = value.toString();
        try {
            String tokenName;
            char c;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                SchemaUtils.throwDecodeException(logger, CoreMessages.ERR_ATTR_SYNTAX_DCR_EMPTY_VALUE1.get(definition));
            }
            if ((c = reader.read()) != '(') {
                SchemaUtils.throwDecodeException(logger, CoreMessages.ERR_ATTR_SYNTAX_DCR_EXPECTED_OPEN_PARENTHESIS.get(definition, reader.pos() - 1, Character.valueOf(c)));
            }
            reader.skipWhitespaces();
            boolean allowMalformedNamesAndOptions = schema.getOption(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS);
            SchemaUtils.readOid(reader, allowMalformedNamesAndOptions);
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readNameDescriptors(reader, allowMalformedNamesAndOptions);
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readQuotedString(reader);
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) continue;
                if ("aux".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readOids(reader, allowMalformedNamesAndOptions);
                    continue;
                }
                if ("must".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readOids(reader, allowMalformedNamesAndOptions);
                    continue;
                }
                if ("may".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readOids(reader, allowMalformedNamesAndOptions);
                    continue;
                }
                if ("not".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readOids(reader, allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    SchemaUtils.readExtensions(reader);
                    continue;
                }
                SchemaUtils.throwDecodeException(logger, CoreMessages.ERR_ATTR_SYNTAX_DCR_ILLEGAL_TOKEN1.get(definition, tokenName));
            }
            return true;
        }
        catch (DecodeException de) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_DCR_INVALID1.get(definition, de.getMessageObject()));
            return false;
        }
    }
}

