/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.SubstringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.forgerock.opendj.ldap.spi.Indexer;
import org.forgerock.opendj.ldap.spi.IndexingOptions;

abstract class AbstractSubstringMatchingRuleImpl
extends AbstractMatchingRuleImpl {
    private static final int BACKSLASH = 92;
    private final String substringIndexId;
    private final String equalityIndexId;

    AbstractSubstringMatchingRuleImpl(String substringIndexId, String equalityIndexId) {
        this.substringIndexId = substringIndexId;
        this.equalityIndexId = equalityIndexId;
    }

    @Override
    String keyToHumanReadableString(ByteSequence key) {
        return key.toString();
    }

    @Override
    public final Assertion getAssertion(Schema schema, ByteSequence assertionValue) throws DecodeException {
        LinkedList<ByteString> anyStrings;
        ByteString finalString;
        ByteString initialString;
        block7: {
            if (assertionValue.length() == 0) {
                throw DecodeException.error(CoreMessages.WARN_ATTR_SYNTAX_SUBSTRING_EMPTY.get());
            }
            initialString = null;
            finalString = null;
            anyStrings = null;
            String valueString = assertionValue.toString();
            if (valueString.length() == 1 && valueString.charAt(0) == '*') {
                return this.getSubstringAssertion(schema, initialString, anyStrings, finalString);
            }
            SubstringReader reader = new SubstringReader(valueString);
            char[] escapeChars = new char[]{'*'};
            ByteString bytes = this.evaluateEscapes(reader, escapeChars);
            if (bytes.length() > 0) {
                initialString = bytes;
            }
            if (reader.remaining() == 0) {
                throw DecodeException.error(CoreMessages.WARN_ATTR_SYNTAX_SUBSTRING_NO_WILDCARDS.get(assertionValue));
            }
            while (true) {
                reader.read();
                bytes = this.evaluateEscapes(reader, escapeChars);
                if (reader.remaining() <= 0) break;
                if (bytes.length() == 0) {
                    throw DecodeException.error(CoreMessages.WARN_ATTR_SYNTAX_SUBSTRING_CONSECUTIVE_WILDCARDS.get(assertionValue, reader.pos()));
                }
                if (anyStrings == null) {
                    anyStrings = new LinkedList<ByteString>();
                }
                anyStrings.add(bytes);
            }
            if (bytes.length() <= 0) break block7;
            finalString = bytes;
        }
        return this.getSubstringAssertion(schema, initialString, anyStrings, finalString);
    }

    @Override
    public final Assertion getSubstringAssertion(Schema schema, ByteSequence subInitial, List<? extends ByteSequence> subAnyElements, ByteSequence subFinal) throws DecodeException {
        ByteString normInitial = subInitial == null ? null : this.normalizeSubString(schema, subInitial);
        ByteString[] normAnys = null;
        if (subAnyElements != null && !subAnyElements.isEmpty()) {
            normAnys = new ByteString[subAnyElements.size()];
            for (int i = 0; i < subAnyElements.size(); ++i) {
                normAnys[i] = this.normalizeSubString(schema, subAnyElements.get(i));
            }
        }
        ByteString normFinal = subFinal == null ? null : this.normalizeSubString(schema, subFinal);
        return new DefaultSubstringAssertion(normInitial, normAnys, normFinal);
    }

    ByteString normalizeSubString(Schema schema, ByteSequence value) throws DecodeException {
        return this.normalizeAttributeValue(schema, value);
    }

    private byte evaluateEscapedChar(SubstringReader reader, char[] escapeChars) throws DecodeException {
        byte b;
        char c1 = reader.read();
        switch (c1) {
            case '0': {
                b = 0;
                break;
            }
            case '1': {
                b = 16;
                break;
            }
            case '2': {
                b = 32;
                break;
            }
            case '3': {
                b = 48;
                break;
            }
            case '4': {
                b = 64;
                break;
            }
            case '5': {
                b = 80;
                break;
            }
            case '6': {
                b = 96;
                break;
            }
            case '7': {
                b = 112;
                break;
            }
            case '8': {
                b = -128;
                break;
            }
            case '9': {
                b = -112;
                break;
            }
            case 'A': 
            case 'a': {
                b = -96;
                break;
            }
            case 'B': 
            case 'b': {
                b = -80;
                break;
            }
            case 'C': 
            case 'c': {
                b = -64;
                break;
            }
            case 'D': 
            case 'd': {
                b = -48;
                break;
            }
            case 'E': 
            case 'e': {
                b = -32;
                break;
            }
            case 'F': 
            case 'f': {
                b = -16;
                break;
            }
            default: {
                if (c1 == '\\') {
                    return (byte)c1;
                }
                if (escapeChars != null) {
                    for (char escapeChar : escapeChars) {
                        if (c1 != escapeChar) continue;
                        return (byte)c1;
                    }
                }
                throw DecodeException.error(CoreMessages.ERR_INVALID_ESCAPE_CHAR.get(reader.getString(), Character.valueOf(c1)));
            }
        }
        if (reader.remaining() == 0) {
            throw DecodeException.error(CoreMessages.ERR_HEX_DECODE_INVALID_LENGTH.get(reader.getString()));
        }
        char c2 = reader.read();
        switch (c2) {
            case '0': {
                break;
            }
            case '1': {
                b = (byte)(b | 1);
                break;
            }
            case '2': {
                b = (byte)(b | 2);
                break;
            }
            case '3': {
                b = (byte)(b | 3);
                break;
            }
            case '4': {
                b = (byte)(b | 4);
                break;
            }
            case '5': {
                b = (byte)(b | 5);
                break;
            }
            case '6': {
                b = (byte)(b | 6);
                break;
            }
            case '7': {
                b = (byte)(b | 7);
                break;
            }
            case '8': {
                b = (byte)(b | 8);
                break;
            }
            case '9': {
                b = (byte)(b | 9);
                break;
            }
            case 'A': 
            case 'a': {
                b = (byte)(b | 0xA);
                break;
            }
            case 'B': 
            case 'b': {
                b = (byte)(b | 0xB);
                break;
            }
            case 'C': 
            case 'c': {
                b = (byte)(b | 0xC);
                break;
            }
            case 'D': 
            case 'd': {
                b = (byte)(b | 0xD);
                break;
            }
            case 'E': 
            case 'e': {
                b = (byte)(b | 0xE);
                break;
            }
            case 'F': 
            case 'f': {
                b = (byte)(b | 0xF);
                break;
            }
            default: {
                throw DecodeException.error(CoreMessages.ERR_HEX_DECODE_INVALID_CHARACTER.get(new String(new char[]{c1, c2}), Character.valueOf(c1)));
            }
        }
        return b;
    }

    private ByteString evaluateEscapes(SubstringReader reader, char[] escapeChars) throws DecodeException {
        return this.evaluateEscapes(reader, escapeChars, escapeChars);
    }

    private ByteString evaluateEscapes(SubstringReader reader, char[] escapeChars, char[] delimiterChars) throws DecodeException {
        int length = 0;
        ByteStringBuilder valueBuffer = null;
        reader.mark();
        while (reader.remaining() > 0) {
            char c = reader.read();
            if (c == '\\') {
                if (valueBuffer == null) {
                    valueBuffer = new ByteStringBuilder();
                }
                valueBuffer.appendUtf8(reader.read(length));
                valueBuffer.appendByte(this.evaluateEscapedChar(reader, escapeChars));
                reader.mark();
                length = 0;
                continue;
            }
            if (delimiterChars != null) {
                for (char delimiterChar : delimiterChars) {
                    if (c != delimiterChar) continue;
                    return this.evaluateEscapes0(reader, length, valueBuffer);
                }
            }
            ++length;
        }
        return this.evaluateEscapes0(reader, length, valueBuffer);
    }

    private ByteString evaluateEscapes0(SubstringReader reader, int length, ByteStringBuilder valueBuffer) {
        reader.reset();
        if (valueBuffer != null) {
            valueBuffer.appendUtf8(reader.read(length));
            return valueBuffer.toByteString();
        }
        if (length > 0) {
            return ByteString.valueOfUtf8(reader.read(length));
        }
        return ByteString.empty();
    }

    @Override
    public final Collection<? extends Indexer> createIndexers(IndexingOptions options) {
        return Collections.singleton(new SubstringIndexer(options.substringKeySize()));
    }

    private final class SubstringIndexer
    implements Indexer {
        private final String indexId;
        private final int substringKeySize;

        private SubstringIndexer(int substringKeySize) {
            this.substringKeySize = substringKeySize;
            this.indexId = AbstractSubstringMatchingRuleImpl.this.substringIndexId + ":" + this.substringKeySize;
        }

        @Override
        public void createKeys(Schema schema, ByteSequence value, Collection<ByteString> keys) throws DecodeException {
            ByteString normValue = AbstractSubstringMatchingRuleImpl.this.normalizeAttributeValue(schema, value);
            int i = 0;
            for (int remain = normValue.length(); remain > 0; --remain) {
                int len = Math.min(this.substringKeySize, remain);
                keys.add(normValue.subSequence(i, i + len));
                ++i;
            }
        }

        @Override
        public String keyToHumanReadableString(ByteSequence key) {
            return AbstractSubstringMatchingRuleImpl.this.keyToHumanReadableString(key);
        }

        @Override
        public String getIndexId() {
            return this.indexId;
        }
    }

    final class DefaultSubstringAssertion
    implements Assertion {
        private final ByteString normInitial;
        private final ByteString[] normAnys;
        private final ByteString normFinal;

        private DefaultSubstringAssertion(ByteString normInitial, ByteString[] normAnys, ByteString normFinal) {
            this.normInitial = normInitial;
            this.normAnys = normAnys;
            this.normFinal = normFinal;
        }

        @Override
        public ConditionResult matches(ByteSequence normalizedAttributeValue) {
            int pos;
            int valueLength = normalizedAttributeValue.length();
            if (this.normInitial != null) {
                int initialLength = this.normInitial.length();
                if (initialLength > valueLength) {
                    return ConditionResult.FALSE;
                }
                for (pos = 0; pos < initialLength; ++pos) {
                    if (this.normInitial.byteAt(pos) == normalizedAttributeValue.byteAt(pos)) continue;
                    return ConditionResult.FALSE;
                }
            }
            if (this.normAnys != null) {
                block1: for (ByteString element : this.normAnys) {
                    int anyLength = element.length();
                    int end = valueLength - anyLength;
                    while (pos <= end) {
                        block12: {
                            for (int i = 0; i < anyLength; ++i) {
                                if (element.byteAt(i) == normalizedAttributeValue.byteAt(pos + i)) {
                                    continue;
                                }
                                break block12;
                            }
                            pos += anyLength;
                            continue block1;
                        }
                        ++pos;
                    }
                    return ConditionResult.FALSE;
                }
            }
            if (this.normFinal != null) {
                int finalLength = this.normFinal.length();
                if (valueLength - finalLength < pos) {
                    return ConditionResult.FALSE;
                }
                pos = valueLength - finalLength;
                int i = 0;
                while (i < finalLength) {
                    if (this.normFinal.byteAt(i) != normalizedAttributeValue.byteAt(pos)) {
                        return ConditionResult.FALSE;
                    }
                    ++i;
                    ++pos;
                }
            }
            return ConditionResult.TRUE;
        }

        @Override
        public <T> T createIndexQuery(IndexQueryFactory<T> factory) throws DecodeException {
            if (this.normInitial == null && (this.normAnys == null || this.normAnys.length == 0) && this.normFinal == null) {
                return factory.createMatchAllQuery();
            }
            LinkedList<T> subqueries = new LinkedList<T>();
            if (this.normInitial != null) {
                subqueries.add(this.rangeMatch(factory, AbstractSubstringMatchingRuleImpl.this.equalityIndexId, this.normInitial));
            }
            if (this.normAnys != null) {
                for (ByteString normAny : this.normAnys) {
                    this.substringMatch(factory, normAny, subqueries);
                }
            }
            if (this.normFinal != null) {
                this.substringMatch(factory, this.normFinal, subqueries);
            }
            if (this.normInitial != null) {
                this.substringMatch(factory, this.normInitial, subqueries);
            }
            return factory.createIntersectionQuery(subqueries);
        }

        private <T> T rangeMatch(IndexQueryFactory<T> factory, String indexID, ByteSequence lower) {
            ByteStringBuilder upper = new ByteStringBuilder(lower);
            for (int i = upper.length() - 1; i >= 0; --i) {
                if (upper.byteAt(i) != -1) {
                    upper.setByte(i, (byte)(upper.byteAt(i) + 1));
                    break;
                }
                upper.setByte(i, (byte)0);
            }
            return factory.createRangeMatchQuery(indexID, lower, upper, true, false);
        }

        /*
         * WARNING - void declaration
         */
        private <T> void substringMatch(IndexQueryFactory<T> factory, ByteString normSubstring, Collection<T> subqueries) {
            int substrLength = factory.getIndexingOptions().substringKeySize();
            String indexId = AbstractSubstringMatchingRuleImpl.this.substringIndexId + ":" + substrLength;
            if (normSubstring.length() < substrLength) {
                subqueries.add(this.rangeMatch(factory, indexId, normSubstring));
            } else {
                void var8_10;
                TreeSet<ByteString> substringKeys = new TreeSet<ByteString>();
                int first = 0;
                int n = substrLength;
                while (var8_10 <= normSubstring.length()) {
                    substringKeys.add(normSubstring.subSequence(first, first + substrLength));
                    ++first;
                    ++var8_10;
                }
                for (ByteSequence byteSequence : substringKeys) {
                    subqueries.add(factory.createExactMatchQuery(indexId, byteSequence));
                }
            }
        }
    }
}

