/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SslOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.messages.AbstractExtendedRequest;
import org.forgerock.opendj.ldap.messages.AbstractExtendedResultDecoder;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequestDecoder;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.ExtendedResultDecoder;
import org.forgerock.opendj.ldap.messages.GenericExtendedResult;
import org.forgerock.opendj.ldap.messages.Responses;
import org.forgerock.opendj.ldap.messages.StartTlsExtendedRequest;
import org.forgerock.util.Reject;

final class StartTlsExtendedRequestImpl
extends AbstractExtendedRequest<StartTlsExtendedRequest, ExtendedResult>
implements StartTlsExtendedRequest {
    private static final ExtendedResultDecoder<ExtendedResult> RESULT_DECODER = new ResultDecoder();
    private SslOptions sslOptions;

    StartTlsExtendedRequestImpl(SslOptions sslOptions) {
        Reject.ifNull(sslOptions);
        this.sslOptions = sslOptions;
    }

    StartTlsExtendedRequestImpl(StartTlsExtendedRequest startTLSExtendedRequest) {
        super(startTLSExtendedRequest);
        this.sslOptions = SslOptions.copyOfSslOptions(startTLSExtendedRequest.getSslOptions());
    }

    private StartTlsExtendedRequestImpl() {
    }

    @Override
    public String getOid() {
        return "1.3.6.1.4.1.1466.20037";
    }

    @Override
    public ExtendedResultDecoder<ExtendedResult> getResultDecoder() {
        return RESULT_DECODER;
    }

    @Override
    public SslOptions getSslOptions() {
        return this.sslOptions;
    }

    @Override
    public ByteString getValue() {
        return null;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public StartTlsExtendedRequest setSslOptions(SslOptions sslOptions) {
        Reject.ifNull(sslOptions);
        this.sslOptions = sslOptions;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StartTlsExtendedRequest(requestName=");
        builder.append(this.getOid());
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class ResultDecoder
    extends AbstractExtendedResultDecoder<ExtendedResult> {
        private ResultDecoder() {
        }

        @Override
        public ExtendedResult decodeExtendedResult(ExtendedResult result, DecodeOptions options) throws DecodeException {
            return result;
        }

        @Override
        public GenericExtendedResult newExtendedErrorResult(ResultCode resultCode, String matchedDN, CharSequence diagnosticMessage) {
            return Responses.newGenericExtendedResult(resultCode).setMatchedDn(matchedDN).setDiagnosticMessage(diagnosticMessage);
        }
    }

    static final class RequestDecoder
    implements ExtendedRequestDecoder<StartTlsExtendedRequest, ExtendedResult> {
        RequestDecoder() {
        }

        @Override
        public StartTlsExtendedRequest decodeExtendedRequest(ExtendedRequest<?> request, DecodeOptions options) throws DecodeException {
            StartTlsExtendedRequestImpl newRequest = new StartTlsExtendedRequestImpl();
            for (Control control : request.getControls()) {
                newRequest.addControl(control);
            }
            return newRequest;
        }
    }
}

