/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import java.util.Collection;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.AttributeParser;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.messages.AbstractProtocolOpImpl;
import org.forgerock.opendj.ldap.messages.AddRequest;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.RequestVisitor;

final class AddRequestImpl
extends AbstractProtocolOpImpl<AddRequest>
implements AddRequest {
    private final Entry entry;

    AddRequestImpl(AddRequest addRequest) {
        super(addRequest);
        this.entry = LinkedHashMapEntry.deepCopyOfEntry(addRequest);
    }

    AddRequestImpl(Entry entry) {
        this.entry = entry;
    }

    @Override
    public <R, P, E extends Exception> R accept(RequestVisitor<R, P, E> v, P p) throws E {
        return v.visitRequest(p, this);
    }

    @Override
    public boolean addAttribute(Attribute attribute) {
        return this.entry.addAttribute(attribute);
    }

    @Override
    public boolean addAttribute(Attribute attribute, Collection<? super ByteString> duplicateValues) {
        return this.entry.addAttribute(attribute, duplicateValues);
    }

    @Override
    public AddRequest addAttribute(String attributeDescription, Object ... values) {
        this.entry.addAttribute(attributeDescription, values);
        return this;
    }

    @Override
    public AddRequest clearAttributes() {
        this.entry.clearAttributes();
        return this;
    }

    @Override
    public boolean containsAttribute(Attribute attribute, Collection<? super ByteString> missingValues) {
        return this.entry.containsAttribute(attribute, missingValues);
    }

    @Override
    public boolean containsAttribute(String attributeDescription, Object ... values) {
        return this.entry.containsAttribute(attributeDescription, values);
    }

    @Override
    public boolean equals(Object object) {
        return this.entry.equals(object);
    }

    @Override
    public Iterable<Attribute> getAllAttributes() {
        return this.entry.getAllAttributes();
    }

    @Override
    public Iterable<Attribute> getAllAttributes(AttributeDescription attributeDescription) {
        return this.entry.getAllAttributes(attributeDescription);
    }

    @Override
    public Iterable<Attribute> getAllAttributes(String attributeDescription) {
        return this.entry.getAllAttributes(attributeDescription);
    }

    @Override
    public Attribute getAttribute(AttributeDescription attributeDescription) {
        return this.entry.getAttribute(attributeDescription);
    }

    @Override
    public Attribute getAttribute(String attributeDescription) {
        return this.entry.getAttribute(attributeDescription);
    }

    @Override
    public int getAttributeCount() {
        return this.entry.getAttributeCount();
    }

    @Override
    public Dn getName() {
        return this.entry.getName();
    }

    @Override
    public int hashCode() {
        return this.entry.hashCode();
    }

    @Override
    public AttributeParser parseAttribute(AttributeDescription attributeDescription) {
        return this.entry.parseAttribute(attributeDescription);
    }

    @Override
    public AttributeParser parseAttribute(String attributeDescription) {
        return this.entry.parseAttribute(attributeDescription);
    }

    @Override
    public boolean removeAttribute(Attribute attribute, Collection<? super ByteString> missingValues) {
        return this.entry.removeAttribute(attribute, missingValues);
    }

    @Override
    public boolean removeAttribute(AttributeDescription attributeDescription) {
        return this.entry.removeAttribute(attributeDescription);
    }

    @Override
    public AddRequest removeAttribute(String attributeDescription, Object ... values) {
        this.entry.removeAttribute(attributeDescription, values);
        return this;
    }

    @Override
    public boolean replaceAttribute(Attribute attribute) {
        return this.entry.replaceAttribute(attribute);
    }

    @Override
    public AddRequest replaceAttribute(String attributeDescription, Object ... values) {
        this.entry.replaceAttribute(attributeDescription, values);
        return this;
    }

    @Override
    public AddRequest setName(Dn dn) {
        this.entry.setName(dn);
        return this;
    }

    @Override
    public AddRequest setName(String dn) {
        this.entry.setName(dn);
        return this;
    }

    @Override
    public Request.RequestType getType() {
        return Request.RequestType.ADD;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AddRequest(name=");
        builder.append(this.getName());
        builder.append(", attributes=");
        builder.append(this.getAllAttributes());
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    AddRequest getThis() {
        return this;
    }
}

