/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.io.Asn1;
import org.forgerock.opendj.io.Asn1Reader;
import org.forgerock.opendj.io.Asn1Writer;
import org.forgerock.opendj.io.Ldap;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class AssertionRequestControl
implements Control {
    public static final String OID = "1.3.6.1.1.12";
    public static final ControlDecoder<AssertionRequestControl> DECODER = new ControlDecoder<AssertionRequestControl>(){

        @Override
        public AssertionRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Reject.ifNull(control);
            if (control instanceof AssertionRequestControl) {
                return (AssertionRequestControl)control;
            }
            if (!control.getOid().equals(AssertionRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_LDAPASSERT_CONTROL_BAD_OID.get(control.getOid(), AssertionRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_LDAPASSERT_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            try {
                Asn1Reader reader = Asn1.getReader(control.getValue());
                Filter filter = Ldap.readFilter(reader);
                return new AssertionRequestControl(control.isCritical(), filter);
            }
            catch (IOException e) {
                throw DecodeException.error(CoreMessages.ERR_LDAPASSERT_INVALID_CONTROL_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }

        @Override
        public String getOid() {
            return AssertionRequestControl.OID;
        }
    };
    private final Filter filter;
    private final boolean isCritical;

    public static AssertionRequestControl newControl(boolean isCritical, Filter filter) {
        return new AssertionRequestControl(isCritical, filter);
    }

    private AssertionRequestControl(boolean isCritical, Filter filter) {
        Reject.ifNull(filter);
        this.isCritical = isCritical;
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public String getOid() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        Asn1Writer writer = Asn1.getWriter(buffer);
        try {
            Ldap.writeFilter(writer, this.filter);
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AssertionRequestControl(oid=");
        builder.append(this.getOid());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", filter=\"");
        builder.append(this.filter);
        builder.append("\")");
        return builder.toString();
    }
}

