/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.SubstringReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Ava;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.Rdn;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.util.Pair;
import org.forgerock.util.Reject;

public final class Dn
implements Iterable<Rdn>,
Comparable<Dn> {
    static final byte NORMALIZED_RDN_SEPARATOR = 0;
    static final byte NORMALIZED_AVA_SEPARATOR = 1;
    static final byte NORMALIZED_ESC_BYTE = 2;
    static final char RDN_CHAR_SEPARATOR = ',';
    static final char AVA_CHAR_SEPARATOR = '+';
    private static final Dn ROOT_DN = new Dn(CoreSchema.getInstance(), null, null);
    private static final int DN_CACHE_SIZE = 32;
    private static final ThreadLocal<Map<String, Dn>> CACHE = new ThreadLocal<Map<String, Dn>>(){

        @Override
        protected Map<String, Dn> initialValue() {
            return new LinkedHashMap<String, Dn>(32, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, Dn> eldest) {
                    return this.size() > 32;
                }
            };
        }
    };
    private final Rdn rdn;
    private Dn parent;
    private final int size;
    private int hashCode = -1;
    private ByteString normalizedDn;
    private String stringValue;
    private final Schema schema;

    public static String escapeAttributeValue(Object attributeValue) {
        Reject.ifNull(attributeValue);
        String s = String.valueOf(attributeValue);
        StringBuilder builder = new StringBuilder(s.length());
        Ava.escapeAttributeValue(s, builder);
        return builder.toString();
    }

    public static Dn format(String template, Object ... attributeValues) {
        return Dn.format(template, Schema.getDefaultSchema(), attributeValues);
    }

    public static Dn format(String template, Schema schema, Object ... attributeValues) {
        String[] attributeValueStrings = new String[attributeValues.length];
        for (int i = 0; i < attributeValues.length; ++i) {
            attributeValueStrings[i] = Dn.escapeAttributeValue(attributeValues[i]);
        }
        String dnString = String.format(template, attributeValueStrings);
        return Dn.valueOf(dnString, schema);
    }

    public static Dn rootDn() {
        return ROOT_DN;
    }

    public static Dn valueOf(String dn) {
        return Dn.valueOf(dn, Schema.getDefaultSchema());
    }

    public static Dn valueOf(String dn, Schema schema) {
        Reject.ifNull(dn, schema);
        if (dn.length() == 0) {
            return ROOT_DN;
        }
        Map<String, Dn> cache = CACHE.get();
        Dn cachedDN = cache.get(dn);
        if (cachedDN != null && cachedDN.schema == schema) {
            return cachedDN;
        }
        return Dn.decode(new SubstringReader(dn), schema, cache);
    }

    public static Dn valueOf(ByteString dn) {
        return Dn.valueOf(dn.toString());
    }

    private static Dn decode(SubstringReader reader, Schema schema, Map<String, Dn> cache) {
        Rdn rdn;
        reader.skipWhitespaces();
        if (reader.remaining() == 0) {
            return ROOT_DN;
        }
        try {
            rdn = Rdn.decode(reader, schema);
        }
        catch (UnknownSchemaElementException e) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_DN_TYPE_NOT_FOUND.get(reader.getString(), e.getMessageObject()));
        }
        LinkedList<Pair<Integer, Rdn>> parentRDNs = null;
        Dn parent = null;
        while (reader.remaining() > 0 && reader.read() == ',') {
            reader.skipWhitespaces();
            if (reader.remaining() == 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DN_ATTR_NO_NAME.get(reader.getString()));
            }
            reader.mark();
            String parentString = reader.read(reader.remaining());
            parent = cache.get(parentString);
            if (parent != null) break;
            reader.reset();
            if (parentRDNs == null) {
                parentRDNs = new LinkedList<Pair<Integer, Rdn>>();
            }
            parentRDNs.add(Pair.of(reader.pos(), Rdn.decode(reader, schema)));
        }
        if (parent == null) {
            parent = ROOT_DN;
        }
        if (parentRDNs != null) {
            Iterator iter = parentRDNs.descendingIterator();
            int parentsLeft = parentRDNs.size();
            while (iter.hasNext()) {
                Pair parentRDN = (Pair)iter.next();
                parent = new Dn(schema, parent, (Rdn)parentRDN.getSecond());
                if (parentsLeft-- >= 32) continue;
                cache.put(reader.getString().substring((Integer)parentRDN.getFirst()), parent);
            }
        }
        return new Dn(schema, parent, rdn);
    }

    private Dn(Schema schema, Dn parent, Rdn rdn) {
        this(schema, parent, rdn, parent != null ? parent.size + 1 : 0);
    }

    private Dn(Schema schema, Dn parent, Rdn rdn, int size) {
        this.schema = schema;
        this.parent = parent;
        this.rdn = rdn;
        this.size = size;
        this.stringValue = rdn == null ? "" : null;
    }

    public Dn child(Dn dn) {
        Reject.ifNull(dn);
        if (dn.isRootDn()) {
            return this;
        }
        if (this.isRootDn()) {
            return dn;
        }
        Rdn[] rdns = new Rdn[dn.size()];
        int i = rdns.length;
        Dn next = dn;
        while (next.rdn != null) {
            rdns[--i] = next.rdn;
            next = next.parent;
        }
        Dn newDN = this;
        for (i = 0; i < rdns.length; ++i) {
            newDN = new Dn(this.schema, newDN, rdns[i]);
        }
        return newDN;
    }

    public Dn child(Rdn rdn) {
        Reject.ifNull(rdn);
        return new Dn(this.schema, this, rdn);
    }

    public Dn child(String dn) {
        Reject.ifNull(dn);
        return this.child(Dn.valueOf(dn));
    }

    public Dn child(String attributeType, Object attributeValue) {
        return this.child(new Rdn(attributeType, attributeValue));
    }

    @Override
    public int compareTo(Dn dn) {
        return this.toNormalizedByteString().compareTo(dn.toNormalizedByteString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Dn) {
            Dn otherDN = (Dn)obj;
            return this.toNormalizedByteString().equals(otherDN.toNormalizedByteString());
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.toNormalizedByteString().hashCode();
        }
        return this.hashCode;
    }

    public boolean isChildOf(Dn dn) {
        return dn.equals(this.parent);
    }

    public boolean isChildOf(String dn) {
        return this.isChildOf(Dn.valueOf(dn));
    }

    public boolean isInScopeOf(Dn dn, SearchScope scope) {
        switch (scope.asEnum()) {
            case BASE_OBJECT: {
                return this.equals(dn);
            }
            case SINGLE_LEVEL: {
                return this.isChildOf(dn);
            }
            case SUBORDINATES: {
                return this.isSubordinateOrEqualTo(dn) && !this.equals(dn);
            }
            case WHOLE_SUBTREE: {
                return this.isSubordinateOrEqualTo(dn);
            }
        }
        return false;
    }

    public boolean isInScopeOf(String dn, SearchScope scope) {
        return this.isInScopeOf(Dn.valueOf(dn), scope);
    }

    public boolean isParentOf(Dn dn) {
        return this.equals(dn.parent);
    }

    public boolean isParentOf(String dn) {
        return this.isParentOf(Dn.valueOf(dn));
    }

    public boolean isRootDn() {
        return this.size == 0;
    }

    public boolean isSubordinateOrEqualTo(Dn dn) {
        if (this.size < dn.size) {
            return false;
        }
        if (this.size == dn.size) {
            return this.equals(dn);
        }
        return this.parent(this.size - dn.size).equals(dn);
    }

    public boolean isSubordinateOrEqualTo(String dn) {
        return this.isSubordinateOrEqualTo(Dn.valueOf(dn));
    }

    public boolean isSuperiorOrEqualTo(Dn dn) {
        if (this.size > dn.size) {
            return false;
        }
        if (this.size == dn.size) {
            return this.equals(dn);
        }
        return dn.parent(dn.size - this.size).equals(this);
    }

    public boolean isSuperiorOrEqualTo(String dn) {
        return this.isSuperiorOrEqualTo(Dn.valueOf(dn));
    }

    @Override
    public Iterator<Rdn> iterator() {
        return new Iterator<Rdn>(){
            private Dn dn;
            {
                this.dn = Dn.this;
            }

            @Override
            public boolean hasNext() {
                return this.dn.rdn != null;
            }

            @Override
            public Rdn next() {
                if (this.dn.rdn == null) {
                    throw new NoSuchElementException();
                }
                Rdn rdn = this.dn.rdn;
                this.dn = this.dn.parent;
                return rdn;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Dn localName(int index) {
        Dn localName;
        Reject.ifFalse(index >= 0, "index less than zero");
        if (index == 0) {
            return ROOT_DN;
        }
        if (index >= this.size) {
            return this;
        }
        Dn nextLocalName = localName = new Dn(this.schema, null, this.rdn, index);
        Dn lastDN = this.parent;
        for (int i = index - 1; i > 0; --i) {
            nextLocalName = nextLocalName.parent = new Dn(this.schema, null, lastDN.rdn, i);
            lastDN = lastDN.parent;
        }
        nextLocalName.parent = ROOT_DN;
        return localName;
    }

    public Dn parent() {
        return this.parent;
    }

    public Dn parent(int index) {
        Reject.ifTrue(index < 0, "index less than zero");
        if (index > this.size) {
            return null;
        }
        Dn parentDN = this;
        for (int i = 0; parentDN != null && i < index; ++i) {
            parentDN = parentDN.parent;
        }
        return parentDN;
    }

    public Rdn rdn() {
        return this.rdn;
    }

    public Rdn rdn(int index) {
        Dn parentDN = this.parent(index);
        return parentDN != null ? parentDN.rdn : null;
    }

    public Dn rename(Dn fromDN, Dn toDN) {
        Reject.ifNull(fromDN, toDN);
        if (!this.isSubordinateOrEqualTo(fromDN)) {
            return this;
        }
        if (this.equals(fromDN)) {
            return toDN;
        }
        return toDN.child(this.localName(this.size - fromDN.size));
    }

    public Dn rename(Rdn newRdn, Dn newSuperior) {
        return this.computeNewSuperior(newSuperior).child(newRdn);
    }

    private Dn computeNewSuperior(Dn newSuperior) {
        if (newSuperior != null) {
            return newSuperior;
        }
        if (this.isRootDn()) {
            return this;
        }
        return this.parent();
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.rdn);
            Dn dn = this.parent;
            while (dn.rdn != null) {
                builder.append(',');
                if (dn.stringValue != null) {
                    builder.append(dn.stringValue);
                    break;
                }
                builder.append(dn.rdn);
                dn = dn.parent;
            }
            this.stringValue = builder.toString();
        }
        return this.stringValue;
    }

    public ByteString toNormalizedByteString() {
        if (this.normalizedDn == null) {
            if (this.rdn == null) {
                this.normalizedDn = ByteString.empty();
            } else {
                ByteStringBuilder builder;
                if (this.parent.normalizedDn != null) {
                    builder = new ByteStringBuilder(this.parent.normalizedDn.length() + 42);
                    builder.appendBytes(this.parent.normalizedDn);
                } else {
                    builder = new ByteStringBuilder(this.size * 8);
                    for (int i = this.size() - 1; i > 0; --i) {
                        this.parent(i).rdn().toNormalizedByteString(builder);
                    }
                }
                this.rdn.toNormalizedByteString(builder);
                this.normalizedDn = builder.toByteString();
            }
        }
        return this.normalizedDn;
    }

    public String toNormalizedUrlSafeString() {
        if (this.rdn() == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = this.size() - 1;
        this.parent(i).rdn().toNormalizedUrlSafeString(builder);
        --i;
        while (i >= 0) {
            Rdn rdn = this.parent(i).rdn();
            if (rdn.size() != 0) {
                builder.append(',');
            }
            rdn.toNormalizedUrlSafeString(builder);
            --i;
        }
        return builder.toString();
    }

    public UUID toUuid() {
        ByteString normDN = this.toNormalizedByteString();
        if (!normDN.isEmpty()) {
            normDN = normDN.subSequence(1, normDN.length());
        }
        return UUID.nameUUIDFromBytes(normDN.toByteArray());
    }
}

