/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.forgerock.opendj.ldap.ResultCode;
import org.glassfish.grizzly.AbstractTransformer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.AbstractCodecFilter;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

final class SaslClientFilter
extends AbstractCodecFilter<Buffer, Buffer> {
    SaslClientFilter(SaslClient saslClient, MemoryManager<?> memoryManager) {
        super(new Decoder(saslClient, memoryManager), new Encoder(saslClient, memoryManager));
    }

    private static final class Encoder
    extends AbstractTransformer<Buffer, Buffer> {
        private static final int BUFFER_SIZE = 4096;
        private final byte[] buffer = new byte[4096];
        private final SaslClient saslClient;

        private Encoder(SaslClient saslClient, MemoryManager<?> memoryManager) {
            this.saslClient = saslClient;
            this.setMemoryManager(memoryManager);
        }

        @Override
        public String getName() {
            return this.getClass().getName();
        }

        @Override
        public boolean hasInputRemaining(AttributeStorage storage, Buffer input) {
            return input != null && input.hasRemaining();
        }

        @Override
        public TransformationResult<Buffer, Buffer> transformImpl(AttributeStorage storage, Buffer input) {
            MemoryManager memoryManager = this.obtainMemoryManager(storage);
            int len = Math.min(this.buffer.length, input.remaining());
            input.get(this.buffer, 0, len);
            try {
                Buffer output = Buffers.wrap(memoryManager, this.saslClient.wrap(this.buffer, 0, len));
                return TransformationResult.createCompletedResult(output, input);
            }
            catch (SaslException e) {
                return TransformationResult.createErrorResult(ResultCode.CLIENT_SIDE_ENCODING_ERROR.intValue(), CoreMessages.ERR_SASL_PROTOCOL_ERROR.get(this.saslClient.getMechanismName(), StaticUtils.getExceptionMessage(e)).toString());
            }
        }
    }

    private static final class Decoder
    extends AbstractTransformer<Buffer, Buffer> {
        private static final int BUFFER_SIZE = 4096;
        private final byte[] buffer = new byte[4096];
        private final SaslClient saslClient;

        public Decoder(SaslClient saslClient, MemoryManager<?> memoryManager) {
            this.saslClient = saslClient;
            this.setMemoryManager(memoryManager);
        }

        @Override
        public String getName() {
            return this.getClass().getName();
        }

        @Override
        public boolean hasInputRemaining(AttributeStorage storage, Buffer input) {
            return input != null && input.hasRemaining();
        }

        @Override
        public TransformationResult<Buffer, Buffer> transformImpl(AttributeStorage storage, Buffer input) {
            MemoryManager memoryManager = this.obtainMemoryManager(storage);
            int len = Math.min(this.buffer.length, input.remaining());
            input.get(this.buffer, 0, len);
            try {
                Buffer output = Buffers.wrap(memoryManager, this.saslClient.unwrap(this.buffer, 0, len));
                return TransformationResult.createCompletedResult(output, input);
            }
            catch (SaslException e) {
                return TransformationResult.createErrorResult(ResultCode.CLIENT_SIDE_DECODING_ERROR.intValue(), CoreMessages.ERR_SASL_PROTOCOL_ERROR.get(this.saslClient.getMechanismName(), StaticUtils.getExceptionMessage(e)).toString());
            }
        }
    }
}

