/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.http;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.forgerock.http.header.ContentApiVersionHeader;
import org.forgerock.http.header.ContentTypeHeader;
import org.forgerock.http.header.MalformedHeaderException;
import org.forgerock.http.protocol.Status;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.http.routing.Version;
import org.forgerock.http.util.Json;
import org.forgerock.http.util.Paths;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.AdviceContext;
import org.forgerock.json.resource.Connection;
import org.forgerock.json.resource.CreateNotSupportedException;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestVisitor;
import org.forgerock.json.resource.Requests;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Response;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.json.resource.http.HttpUtils;
import org.forgerock.services.context.Context;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Utils;
import org.forgerock.util.encode.Base64url;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

final class RequestRunner
implements RequestVisitor<Promise<org.forgerock.http.protocol.Response, NeverThrowsException>, Void> {
    private Connection connection = null;
    private final Context context;
    private final org.forgerock.http.protocol.Request httpRequest;
    private final org.forgerock.http.protocol.Response httpResponse;
    private final Version protocolVersion;
    private final Request request;
    private final JsonGenerator jsonGenerator;

    RequestRunner(Context context, Request request, org.forgerock.http.protocol.Request httpRequest, org.forgerock.http.protocol.Response httpResponse) throws Exception {
        this.context = context;
        this.request = request;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.protocolVersion = HttpUtils.getRequestedProtocolVersion(httpRequest);
        this.jsonGenerator = HttpUtils.getJsonGenerator(httpRequest, httpResponse);
    }

    private boolean isUpsertSupported(CreateRequest request) {
        return this.protocolVersion.getMajor() >= 2 && HttpUtils.getIfNoneMatch(this.httpRequest) == null && request.getNewResourceId() != null;
    }

    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> handleError(ResourceException error) {
        this.onError(error);
        this.writeApiVersionHeaders(error);
        this.writeAdvice();
        return HttpUtils.fail(this.httpRequest, this.httpResponse, error);
    }

    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> handleResult(Connection result) {
        this.connection = result;
        return this.request.accept(this, null);
    }

    @Override
    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitActionRequest(Void p, ActionRequest request) {
        return this.connection.actionAsync(this.context, request).thenAsync(result -> {
            try {
                this.writeApiVersionHeaders((Response)result);
                this.writeAdvice();
                if (result != null) {
                    Json.makeLocalizingObjectWriter(HttpUtils.JSON_MAPPER, this.httpRequest).writeValue(this.jsonGenerator, result.getJsonContent().getObject());
                } else {
                    this.httpResponse.setStatus(Status.NO_CONTENT);
                }
                this.onSuccess();
            }
            catch (Exception e) {
                this.onError(e);
            }
            return Promises.newResultPromise(this.httpResponse);
        }, this::handleError);
    }

    @Override
    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitCreateRequest(Void p, CreateRequest request) {
        return this.connection.createAsync(this.context, request).thenAsync(result -> {
            try {
                this.writeApiVersionHeaders((Response)result);
                this.writeAdvice();
                if (result.getId() != null) {
                    this.httpResponse.getHeaders().put("Location", (Object)this.getResourceURL((ResourceResponse)result, request));
                }
                this.httpResponse.setStatus(Status.CREATED);
                this.writeResource((ResourceResponse)result);
                this.onSuccess();
            }
            catch (Exception e) {
                this.onError(e);
            }
            return Promises.newResultPromise(this.httpResponse);
        }, resourceException -> {
            try {
                if ((resourceException instanceof PreconditionFailedException || resourceException instanceof CreateNotSupportedException) && this.isUpsertSupported(request)) {
                    return this.visitUpdateRequest(p, Requests.newUpdateRequest(request));
                }
                return this.handleError((ResourceException)resourceException);
            }
            catch (Exception e) {
                this.onError(e);
                return Promises.newResultPromise(this.httpResponse);
            }
        });
    }

    @Override
    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitDeleteRequest(Void p, DeleteRequest request) {
        return this.connection.deleteAsync(this.context, request).thenAsync(this.newResourceSuccessHandler(), this::handleError);
    }

    @Override
    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitPatchRequest(Void p, PatchRequest request) {
        return this.connection.patchAsync(this.context, request).thenAsync(this.newResourceSuccessHandler(), this::handleError);
    }

    @Override
    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitQueryRequest(Void p, QueryRequest request) {
        AtomicBoolean isFirstResult = new AtomicBoolean(true);
        AtomicInteger resultCount = new AtomicInteger(0);
        return this.connection.queryAsync(this.context, request, resource -> {
            try {
                this.writeHeader(resource, isFirstResult);
                this.writeResourceJsonContent(resource);
                resultCount.incrementAndGet();
                return true;
            }
            catch (Exception e) {
                this.handleError(HttpUtils.adapt(e));
                return false;
            }
        }).thenOnResult(result -> {
            try {
                this.writeHeader((Response)result, isFirstResult);
                this.jsonGenerator.writeEndArray();
                this.jsonGenerator.writeNumberField("resultCount", resultCount.get());
                this.jsonGenerator.writeStringField("pagedResultsCookie", result.getPagedResultsCookie());
                this.jsonGenerator.writeStringField("totalPagedResultsPolicy", result.getTotalPagedResultsPolicy().toString());
                this.jsonGenerator.writeNumberField("totalPagedResults", result.getTotalPagedResults());
                this.jsonGenerator.writeNumberField("remainingPagedResults", result.getRemainingPagedResults());
                this.jsonGenerator.writeEndObject();
                this.onSuccess();
            }
            catch (Exception e) {
                this.onError(e);
            }
        }).thenOnException(error -> {
            if (isFirstResult.get()) {
                this.onError((Exception)error);
            } else {
                try {
                    this.jsonGenerator.writeEndArray();
                    this.jsonGenerator.writeNumberField("resultCount", resultCount.get());
                    this.jsonGenerator.writeObjectField("error", error.toJsonValue().getObject());
                    this.jsonGenerator.writeEndObject();
                    this.onSuccess();
                }
                catch (Exception e) {
                    this.onError(e);
                }
            }
        }).thenAsync(queryResponse -> Promises.newResultPromise(this.httpResponse), this::handleError);
    }

    private void writeHeader(Response response, AtomicBoolean isFirstResult) throws IOException {
        if (isFirstResult.compareAndSet(true, false)) {
            this.writeApiVersionHeaders(response);
            this.writeAdvice();
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeArrayFieldStart("result");
        }
    }

    @Override
    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitReadRequest(Void p, ReadRequest request) {
        return this.connection.readAsync(this.context, request).thenAsync(this.newResourceSuccessHandler(), this::handleError);
    }

    @Override
    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitUpdateRequest(Void p, UpdateRequest request) {
        return this.connection.updateAsync(this.context, request).thenAsync(this.newResourceSuccessHandler(), this::handleError);
    }

    private void onSuccess() {
        Utils.closeSilently(this.connection, this.jsonGenerator);
    }

    private void onError(Exception e) {
        Utils.closeSilently(this.connection);
    }

    private String getResourceURL(ResourceResponse resource, CreateRequest request) {
        String resourcePath;
        StringBuilder builder = new StringBuilder().append(this.httpRequest.getUri().getScheme()).append("://").append(this.httpRequest.getUri().getRawAuthority());
        String baseUri = this.context.asContext(UriRouterContext.class).getBaseUri();
        if (!baseUri.isEmpty()) {
            builder.append(Paths.addLeadingSlash(baseUri));
        }
        if (!(resourcePath = request.getResourcePath()).isEmpty()) {
            builder.append(Paths.addLeadingSlash(resourcePath));
        }
        builder.append('/');
        builder.append(resource.getId());
        return builder.toString();
    }

    private AsyncFunction<ResourceResponse, org.forgerock.http.protocol.Response, NeverThrowsException> newResourceSuccessHandler() {
        return result -> {
            try {
                String rev;
                this.writeApiVersionHeaders((Response)result);
                this.writeAdvice();
                if (this.request instanceof ReadRequest && (rev = HttpUtils.getIfNoneMatch(this.httpRequest)) != null && rev.equals(result.getRevision())) {
                    Map<String, Object> responseBody = ((ResourceException)ResourceException.newResourceException(304).setReason("Not Modified")).toJsonValue().asMap();
                    return Promises.newResultPromise(new org.forgerock.http.protocol.Response(Status.valueOf(304)).setEntity(responseBody));
                }
                this.writeResource((ResourceResponse)result);
                this.onSuccess();
            }
            catch (Exception e) {
                this.onError(e);
            }
            return Promises.newResultPromise(this.httpResponse);
        };
    }

    private void writeTextValue(JsonValue json) throws IOException {
        if (json.isMap() && !json.asMap().isEmpty()) {
            this.writeToResponse(json.asMap().entrySet().iterator().next().getValue().toString().getBytes());
        } else if (json.isList() && !json.asList().isEmpty()) {
            this.writeToResponse(json.asList(String.class).iterator().next().getBytes());
        } else if (json.isString()) {
            this.writeToResponse(json.asString().getBytes());
        } else if (json.isBoolean()) {
            this.writeToResponse(json.asBoolean().toString().getBytes());
        } else if (json.isNumber()) {
            this.writeToResponse(json.asNumber().toString().getBytes());
        } else {
            throw new IOException("Content is unknown type or is empty");
        }
    }

    private void writeBinaryValue(JsonValue json) throws IOException {
        if (json.isMap() && !json.asMap().isEmpty()) {
            this.writeToResponse(Base64url.decode(json.asMap().entrySet().iterator().next().getValue().toString()));
        } else if (json.isList() && !json.asList().isEmpty()) {
            this.writeToResponse(Base64url.decode(json.asList(String.class).iterator().next()));
        } else if (json.isString()) {
            this.writeToResponse(Base64url.decode(json.asString()));
        } else {
            throw new IOException("Content is not an accepted type or is empty");
        }
    }

    private void writeToResponse(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            throw new IOException("Content is empty or corrupt");
        }
        this.httpResponse.setEntity(data);
    }

    private void writeResource(ResourceResponse resource) throws IOException, ParseException, MalformedHeaderException {
        ContentType contentType;
        if (resource.getRevision() != null) {
            StringBuilder builder = new StringBuilder();
            builder.append('\"');
            builder.append(resource.getRevision());
            builder.append('\"');
            this.httpResponse.getHeaders().put("ETag", (Object)builder.toString());
        }
        if ((contentType = new ContentType(this.httpResponse.getHeaders().getFirst(ContentTypeHeader.class))).match("application/json")) {
            this.writeResourceJsonContent(resource);
        } else if (contentType.match("text/plain")) {
            this.writeTextValue(resource.getContent());
        } else {
            this.writeBinaryValue(resource.getContent());
        }
    }

    private void writeResourceJsonContent(ResourceResponse resource) throws IOException, MalformedHeaderException {
        ObjectWriter objectWriter = Json.makeLocalizingObjectWriter(HttpUtils.JSON_MAPPER, this.httpRequest);
        if (HttpUtils.getRequestedProtocolVersion(this.httpRequest).getMajor() >= HttpUtils.PROTOCOL_VERSION_2.getMajor()) {
            this.jsonGenerator.writeStartObject();
            JsonValue content = resource.getContent();
            if (resource.getId() != null) {
                this.jsonGenerator.writeObjectField("_id", resource.getId());
            } else {
                Object id = content.get("_id").getObject();
                if (id != null) {
                    this.jsonGenerator.writeObjectField("_id", id.toString());
                }
            }
            if (resource.getRevision() != null) {
                this.jsonGenerator.writeObjectField("_rev", resource.getRevision());
            } else {
                Object rev = content.get("_rev").getObject();
                if (rev != null) {
                    this.jsonGenerator.writeObjectField("_rev", rev.toString());
                }
            }
            for (Map.Entry<String, Object> property : content.asMap().entrySet()) {
                String key = property.getKey();
                if ("_id".equals(key) || "_rev".equals(key)) continue;
                this.jsonGenerator.writeFieldName(key);
                objectWriter.writeValue(this.jsonGenerator, property.getValue());
            }
            this.jsonGenerator.writeEndObject();
        } else {
            objectWriter.writeValue(this.jsonGenerator, resource.getContent().getObject());
        }
    }

    private void writeApiVersionHeaders(Response response) {
        if (response.getResourceApiVersion() != null) {
            this.httpResponse.getHeaders().put(new ContentApiVersionHeader(this.protocolVersion, response.getResourceApiVersion()));
        }
    }

    private void writeAdvice() {
        if (this.context.containsContext(AdviceContext.class)) {
            AdviceContext adviceContext = this.context.asContext(AdviceContext.class);
            for (Map.Entry<String, List<String>> entry : adviceContext.getAdvices().entrySet()) {
                this.httpResponse.getHeaders().put(entry.getKey(), (Object)entry.getValue());
            }
        }
    }
}

