/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.forgerock.api.annotations.Action;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.AnnotatedMethod;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;

class AnnotatedActionMethods {
    private Map<String, AnnotatedMethod> methodsWithIdActions = new HashMap<String, AnnotatedMethod>();
    private Map<String, AnnotatedMethod> methodsWithoutIdActions = new HashMap<String, AnnotatedMethod>();

    AnnotatedActionMethods() {
    }

    Promise<ActionResponse, ResourceException> invoke(Context context, ActionRequest request) {
        return this.invoke(context, request, null, this.methodsWithoutIdActions.get(request.getAction()));
    }

    Promise<ActionResponse, ResourceException> invoke(Context context, ActionRequest request, String id) {
        return this.invoke(context, request, id, this.methodsWithIdActions.get(request.getAction()));
    }

    private Promise<ActionResponse, ResourceException> invoke(Context context, ActionRequest request, String id, AnnotatedMethod method) {
        if (method == null) {
            return new NotSupportedException(request.getAction() + " not supported").asPromise();
        }
        return method.invoke(context, (Request)request, id);
    }

    static AnnotatedActionMethods findAll(Object requestHandler, boolean needsId) {
        AnnotatedActionMethods methods = new AnnotatedActionMethods();
        for (Method method : requestHandler.getClass().getMethods()) {
            AnnotatedMethod checked;
            Action action = method.getAnnotation(Action.class);
            if (action == null || (checked = AnnotatedMethod.checkMethod(Action.class, requestHandler, method, needsId)) == null) continue;
            String actionName = action.name();
            if (actionName == null || actionName.length() == 0) {
                actionName = method.getName();
            }
            if (checked.isUsingId()) {
                methods.methodsWithIdActions.put(actionName, checked);
                continue;
            }
            methods.methodsWithoutIdActions.put(actionName, checked);
        }
        return methods;
    }
}

