/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe.handlers.encryption;

import java.security.Key;
import org.forgerock.json.jose.exceptions.JweDecryptionException;
import org.forgerock.json.jose.jwe.EncryptionMethod;
import org.forgerock.json.jose.jwe.JweEncryption;
import org.forgerock.json.jose.jwe.handlers.encryption.ContentEncryptionHandler;
import org.forgerock.json.jose.jwe.handlers.encryption.EncryptionHandler;
import org.forgerock.util.annotations.VisibleForTesting;

public final class DirectEncryptionHandler
implements EncryptionHandler {
    private final ContentEncryptionHandler contentEncryptionHandler;

    public DirectEncryptionHandler(EncryptionMethod encryptionMethod) {
        this(ContentEncryptionHandler.getInstance(encryptionMethod));
    }

    @VisibleForTesting
    DirectEncryptionHandler(ContentEncryptionHandler contentEncryptionHandler) {
        this.contentEncryptionHandler = contentEncryptionHandler;
    }

    @Override
    public Key getContentEncryptionKey() {
        return null;
    }

    @Override
    public byte[] generateJWEEncryptedKey(Key key, Key contentEncryptionKey) {
        return new byte[0];
    }

    @Override
    public byte[] generateInitialisationVector() {
        return this.contentEncryptionHandler.generateInitialisationVector();
    }

    @Override
    public JweEncryption encryptPlaintext(Key contentEncryptionKey, byte[] initialisationVector, byte[] plaintext, byte[] additionalAuthenticatedData) {
        return this.contentEncryptionHandler.encrypt(contentEncryptionKey, initialisationVector, plaintext, additionalAuthenticatedData);
    }

    @Override
    public Key decryptContentEncryptionKey(Key key, byte[] encryptedContentEncryptionKey) {
        if (encryptedContentEncryptionKey != null && encryptedContentEncryptionKey.length != 0) {
            throw new JweDecryptionException();
        }
        return key;
    }

    @Override
    public byte[] decryptCiphertext(Key contentEncryptionKey, byte[] initialisationVector, byte[] ciphertext, byte[] authenticationTag, byte[] additionalAuthenticatedData) {
        return this.contentEncryptionHandler.decrypt(contentEncryptionKey, initialisationVector, new JweEncryption(ciphertext, authenticationTag), additionalAuthenticatedData);
    }
}

