/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.protocol;

import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Status;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promises;

public final class Responses {
    private static final AsyncFunction<Exception, Response, NeverThrowsException> INTERNAL_SERVER_ERROR_ASYNC_FUNC = e -> Promises.newResultPromise(Responses.newInternalServerError(e));
    private static final Function<NeverThrowsException, Object, Exception> NOOP_EXCEPTION_FUNC = value -> {
        throw new IllegalStateException("NeverThrowsException has been throw ?!");
    };

    public static Response newInternalServerError() {
        return new Response(Status.INTERNAL_SERVER_ERROR);
    }

    public static Response newInternalServerError(Exception exception) {
        return Responses.newInternalServerError().setCause(exception);
    }

    public static Response newNotFound() {
        return new Response(Status.NOT_FOUND);
    }

    public static <V, E extends Exception> Function<NeverThrowsException, V, E> noopExceptionFunction() {
        return NOOP_EXCEPTION_FUNC;
    }

    public static <E extends Exception> Function<E, Response, NeverThrowsException> onExceptionInternalServerError() {
        return Responses::newInternalServerError;
    }

    public static <E extends Exception> AsyncFunction<E, Response, NeverThrowsException> internalServerError() {
        return INTERNAL_SERVER_ERROR_ASYNC_FUNC;
    }

    private Responses() {
    }
}

