/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.filter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.filter.OptionsFilter;
import org.forgerock.http.filter.SessionFilter;
import org.forgerock.http.handler.Handlers;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Responses;
import org.forgerock.http.session.SessionManager;
import org.forgerock.services.context.Context;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;
import org.forgerock.util.encode.Base64;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;

public final class Filters {
    private static final Filter EMPTY_FILTER = (context, request, next) -> next.handle(context, request);

    private Filters() {
    }

    public static Filter newOptionsFilter(String ... allowedMethods) {
        return new OptionsFilter(allowedMethods);
    }

    public static Filter newSessionFilter(SessionManager sessionManager) {
        return new SessionFilter(sessionManager);
    }

    public static Filter requestCopyFilter() {
        return (context, request, next) -> {
            try {
                Request requestCopy = new Request(request);
                return next.handle(context, requestCopy).thenAlways(() -> Utils.closeSilently(requestCopy));
            }
            catch (IOException ioe) {
                return Response.newResponsePromise(Responses.newInternalServerError(ioe));
            }
        };
    }

    public static Filter newHttpBasicAuthenticationFilter(String username, String password) {
        return Filters.newHttpBasicAuthenticationFilter(username, password, StandardCharsets.UTF_8);
    }

    public static Filter newHttpBasicAuthenticationFilter(String username, String password, Charset charset) {
        return new HttpBasicAuthClientFilter(username, password, charset);
    }

    public static Filter chainOf(Filter ... filters) {
        return Filters.chainOf(Arrays.asList(filters));
    }

    public static Filter chainOf(List<Filter> filters) {
        if (filters.isEmpty()) {
            return EMPTY_FILTER;
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return Filters.combine(filters.get(0), Filters.chainOf(filters.subList(1, filters.size())));
    }

    private static Filter combine(Filter first, Filter second) {
        return (context, request, next) -> first.filter(context, request, Handlers.filtered(next, second));
    }

    private static class HttpBasicAuthClientFilter
    implements Filter {
        private final String credentials;

        HttpBasicAuthClientFilter(String username, String password, Charset charset) {
            Reject.ifNull(username, password, charset);
            Reject.ifTrue(username.contains(":"));
            this.credentials = "Basic " + Base64.encode((username + ":" + password).getBytes(charset));
        }

        @Override
        public Promise<Response, NeverThrowsException> filter(Context context, Request request, Handler next) {
            request.getHeaders().put("Authorization", (Object)this.credentials);
            return next.handle(context, request);
        }
    }
}

