/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.forgerock.api.jackson.JacksonUtils;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.Reference;
import org.forgerock.api.models.TranslateJsonSchema;
import org.forgerock.guava.common.base.Strings;
import org.forgerock.util.Reject;

@JsonDeserialize(builder=Builder.class)
public abstract class Schema {
    private Schema() {
    }

    public abstract Reference getReference();

    public abstract org.forgerock.json.JsonValue getSchema();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema1 = (Schema)o;
        return Objects.equals(this.getReference(), schema1.getReference()) && this.isSchemaPropertyMatches(schema1);
    }

    private boolean isSchemaPropertyMatches(Schema schema1) {
        return this.getSchema() != null && schema1.getSchema() != null ? Objects.equals(this.getSchema().getObject(), schema1.getSchema().getObject()) : schema1.getSchema() == this.getSchema();
    }

    public int hashCode() {
        org.forgerock.json.JsonValue schema = this.getSchema();
        return Objects.hash(this.getReference(), schema == null ? null : schema.getObject());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder schema() {
        return Schema.newBuilder();
    }

    public static Schema fromAnnotation(org.forgerock.api.annotations.Schema schema, ApiDescription descriptor, Class<?> relativeType) {
        Class<?> type = schema.fromType();
        if (type.equals(Void.class) && Strings.isNullOrEmpty(schema.schemaResource())) {
            return null;
        }
        Builder builder = Schema.schema();
        String id = schema.id();
        if (!type.equals(Void.class)) {
            org.forgerock.api.annotations.Schema typeSchema;
            builder.type(type);
            if (Strings.isNullOrEmpty(id) && (typeSchema = type.getAnnotation(org.forgerock.api.annotations.Schema.class)) != null && !Strings.isNullOrEmpty(typeSchema.id())) {
                id = typeSchema.id();
            }
        } else {
            InputStream resource = relativeType.getResourceAsStream(schema.schemaResource());
            try {
                org.forgerock.json.JsonValue json = org.forgerock.json.JsonValue.json(JacksonUtils.OBJECT_MAPPER.readValue(resource, Object.class)).as(new TranslateJsonSchema(relativeType.getClassLoader()));
                builder.schema(json);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read declared resource " + schema.schemaResource(), e);
            }
        }
        if (!Strings.isNullOrEmpty(id)) {
            descriptor.addDefinition(id, builder.build());
            return Schema.schema().reference(Reference.reference().value("#/definitions/" + id).build()).build();
        }
        return builder.build();
    }

    private static final class SchemaSchema
    extends Schema {
        private final org.forgerock.json.JsonValue schema;

        private SchemaSchema(org.forgerock.json.JsonValue schema) {
            this.schema = schema;
        }

        @Override
        @JsonIgnore
        public Reference getReference() {
            return null;
        }

        @Override
        @JsonValue
        public org.forgerock.json.JsonValue getSchema() {
            return this.schema;
        }
    }

    private static final class ReferenceSchema
    extends Schema {
        private final Reference reference;

        private ReferenceSchema(Reference reference) {
            this.reference = reference;
        }

        @Override
        @JsonProperty(value="$ref")
        public Reference getReference() {
            return this.reference;
        }

        @Override
        @JsonIgnore
        public org.forgerock.json.JsonValue getSchema() {
            return null;
        }
    }

    public static final class Builder {
        private org.forgerock.json.JsonValue schema;
        private Reference reference;
        private Map<String, Object> jsonValueObject = new HashMap<String, Object>();

        private Builder() {
        }

        @JsonProperty(value="$ref")
        public Builder reference(Reference reference) {
            Reject.ifNull(reference);
            this.reference = reference;
            return this;
        }

        public Builder schema(org.forgerock.json.JsonValue schema) {
            Reject.ifNull(schema);
            this.schema = schema;
            return this;
        }

        @JsonAnySetter
        public Builder schema(String key, Object value) {
            this.jsonValueObject.put(key, value);
            return this;
        }

        public Builder type(Class<?> type) {
            Reject.ifNull(type);
            try {
                JsonSchema jsonSchema = JacksonUtils.schemaFor(type);
                String schemaString = JacksonUtils.OBJECT_MAPPER.writer().writeValueAsString(jsonSchema);
                this.schema = org.forgerock.json.JsonValue.json(JacksonUtils.OBJECT_MAPPER.readValue(schemaString, Object.class)).as(new TranslateJsonSchema(type.getClassLoader()));
            }
            catch (JsonMappingException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Jackson cannot read its own JSON", e);
            }
            return this;
        }

        public Schema build() {
            if (!this.jsonValueObject.isEmpty()) {
                this.schema(org.forgerock.json.JsonValue.json(this.jsonValueObject));
            }
            return this.reference == null ? new SchemaSchema(this.schema) : new ReferenceSchema(this.reference);
        }
    }
}

