/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.forgerock.api.ApiValidationException;
import org.forgerock.api.annotations.Actions;
import org.forgerock.api.annotations.CollectionProvider;
import org.forgerock.api.enums.ParameterSource;
import org.forgerock.api.models.Action;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.Create;
import org.forgerock.api.models.Delete;
import org.forgerock.api.models.Parameter;
import org.forgerock.api.models.Patch;
import org.forgerock.api.models.Read;
import org.forgerock.api.models.Resource;
import org.forgerock.api.models.Schema;
import org.forgerock.api.models.SubResources;
import org.forgerock.api.models.Update;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.util.Reject;
import org.forgerock.util.i18n.LocalizableString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Items {
    private static final Logger LOGGER = LoggerFactory.getLogger(Items.class);
    private final Create create;
    private final Read read;
    private final Update update;
    private final Delete delete;
    private final Patch patch;
    private final Action[] actions;
    private final SubResources subresources;
    private final Parameter pathParameter;

    private Items(Builder builder) {
        this.create = builder.create;
        this.read = builder.read;
        this.update = builder.update;
        this.delete = builder.delete;
        this.patch = builder.patch;
        this.subresources = builder.subresources;
        this.pathParameter = builder.pathParameter;
        this.actions = builder.actions.toArray(new Action[builder.actions.size()]);
        if (this.create == null && this.read == null && this.update == null && this.delete == null && this.patch == null && ValidationUtil.isEmpty(this.actions)) {
            throw new ApiValidationException("At least one operation required");
        }
    }

    public Create getCreate() {
        return this.create;
    }

    public Read getRead() {
        return this.read;
    }

    public Update getUpdate() {
        return this.update;
    }

    public Delete getDelete() {
        return this.delete;
    }

    public Patch getPatch() {
        return this.patch;
    }

    public Action[] getActions() {
        return this.actions.length == 0 ? null : this.actions;
    }

    public SubResources getSubresources() {
        return this.subresources;
    }

    public Parameter getPathParameter() {
        return this.pathParameter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Items items = (Items)o;
        return Objects.equals(this.create, items.create) && Objects.equals(this.read, items.read) && Objects.equals(this.update, items.update) && Objects.equals(this.delete, items.delete) && Objects.equals(this.patch, items.patch) && Arrays.equals(this.actions, items.actions) && Objects.equals(this.subresources, items.subresources) && Objects.equals(this.pathParameter, items.pathParameter);
    }

    public int hashCode() {
        return Objects.hash(this.create, this.read, this.update, this.delete, this.patch, this.actions, this.pathParameter, this.subresources);
    }

    @JsonIgnore
    public Resource asResource(boolean mvccSupported, Schema resourceSchema, LocalizableString title, LocalizableString description) {
        List<Action> actions = this.getActions() == null ? Collections.emptyList() : Arrays.asList(this.getActions());
        return Resource.resource().mvccSupported(mvccSupported).resourceSchema(resourceSchema).title(title).description(description).create(this.getCreate()).read(this.getRead()).update(this.getUpdate()).delete(this.getDelete()).patch(this.getPatch()).actions(actions).build();
    }

    public static Builder items() {
        return new Builder();
    }

    public static Items fromAnnotatedType(Class<?> type, ApiDescription descriptor, SubResources subResources) {
        Builder builder = Items.items();
        CollectionProvider provider = type.getAnnotation(CollectionProvider.class);
        if (provider == null) {
            LOGGER.info("Asked for Items for annotated type, but type does not have required RequestHandler annotation. No api descriptor will be available for " + type);
            return null;
        }
        builder.pathParameter(Parameter.fromAnnotation(type, provider.pathParam()));
        for (Method m : type.getMethods()) {
            org.forgerock.api.annotations.Patch patch;
            org.forgerock.api.annotations.Delete delete;
            org.forgerock.api.annotations.Update update;
            org.forgerock.api.annotations.Read read;
            org.forgerock.api.annotations.Create create;
            Actions actions;
            boolean instanceMethod = Arrays.asList(m.getParameterTypes()).indexOf(String.class) > -1;
            org.forgerock.api.annotations.Action action = m.getAnnotation(org.forgerock.api.annotations.Action.class);
            if (action != null && instanceMethod) {
                builder.actions.add(Action.fromAnnotation(action, m, descriptor, type));
            }
            if ((actions = m.getAnnotation(Actions.class)) != null && instanceMethod) {
                for (org.forgerock.api.annotations.Action a : actions.value()) {
                    builder.actions.add(Action.fromAnnotation(a, null, descriptor, type));
                }
            }
            if ((create = m.getAnnotation(org.forgerock.api.annotations.Create.class)) != null) {
                builder.create = Create.fromAnnotation(create, true, descriptor, type);
            }
            if ((read = m.getAnnotation(org.forgerock.api.annotations.Read.class)) != null) {
                builder.read = Read.fromAnnotation(read, descriptor, type);
            }
            if ((update = m.getAnnotation(org.forgerock.api.annotations.Update.class)) != null) {
                builder.update = Update.fromAnnotation(update, descriptor, type);
            }
            if ((delete = m.getAnnotation(org.forgerock.api.annotations.Delete.class)) != null) {
                builder.delete = Delete.fromAnnotation(delete, descriptor, type);
            }
            if ((patch = m.getAnnotation(org.forgerock.api.annotations.Patch.class)) == null) continue;
            builder.patch = Patch.fromAnnotation(patch, descriptor, type);
        }
        return builder.subresources(subResources).build();
    }

    public static final class Builder {
        private Create create;
        private Read read;
        private Update update;
        private Delete delete;
        private Patch patch;
        private SubResources subresources;
        private Parameter pathParameter = Parameter.parameter().name("id").type("string").source(ParameterSource.PATH).required(true).build();
        private final Set<Action> actions = new TreeSet<Action>();
        private boolean built = false;

        protected Builder() {
        }

        @JsonProperty(value="create")
        public Builder create(Create create) {
            this.checkState();
            this.create = create;
            return this;
        }

        @JsonProperty(value="read")
        public Builder read(Read read) {
            this.checkState();
            this.read = read;
            return this;
        }

        @JsonProperty(value="update")
        public Builder update(Update update) {
            this.checkState();
            this.update = update;
            return this;
        }

        @JsonProperty(value="delete")
        public Builder delete(Delete delete) {
            this.checkState();
            this.delete = delete;
            return this;
        }

        @JsonProperty(value="patch")
        public Builder patch(Patch patch) {
            this.checkState();
            this.patch = patch;
            return this;
        }

        @JsonProperty(value="actions")
        public Builder actions(List<Action> actions) {
            this.checkState();
            this.actions.addAll(actions);
            return this;
        }

        public Builder action(Action action) {
            this.checkState();
            this.actions.add(action);
            return this;
        }

        @JsonProperty(value="pathParameter")
        public Builder pathParameter(Parameter pathParameter) {
            this.checkState();
            this.pathParameter = pathParameter;
            return this;
        }

        @JsonProperty(value="subresources")
        public Builder subresources(SubResources subresources) {
            this.checkState();
            this.subresources = subresources;
            return this;
        }

        public Items build() {
            this.checkState();
            this.built = true;
            if (this.create == null && this.read == null && this.update == null && this.delete == null && this.patch == null && this.actions.isEmpty() && this.subresources == null) {
                return null;
            }
            return new Items(this);
        }

        private void checkState() {
            Reject.rejectStateIfTrue(this.built, "Already built Items");
        }
    }
}

