/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableTake<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long limit;

    public FlowableTake(Publisher<T> source, long limit) {
        super(source);
        this.limit = limit;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new TakeSubscriber<T>(s, this.limit));
    }

    static final class TakeSubscriber<T>
    extends AtomicBoolean
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = -5636543848937116287L;
        boolean done;
        Subscription subscription;
        final Subscriber<? super T> actual;
        final long limit;
        long remaining;

        TakeSubscriber(Subscriber<? super T> actual, long limit) {
            this.actual = actual;
            this.limit = limit;
            this.remaining = limit;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.subscription, s)) {
                this.subscription = s;
                if (this.limit == 0L) {
                    s.cancel();
                    this.done = true;
                    EmptySubscription.complete(this.actual);
                } else {
                    this.actual.onSubscribe(this);
                }
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.done && this.remaining-- > 0L) {
                boolean stop = this.remaining == 0L;
                this.actual.onNext(t);
                if (stop) {
                    this.subscription.cancel();
                    this.onComplete();
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (!this.done) {
                this.done = true;
                this.subscription.cancel();
                this.actual.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.actual.onComplete();
            }
        }

        @Override
        public void request(long n) {
            if (!SubscriptionHelper.validate(n)) {
                return;
            }
            if (!this.get() && this.compareAndSet(false, true) && n >= this.limit) {
                this.subscription.request(Long.MAX_VALUE);
                return;
            }
            this.subscription.request(n);
        }

        @Override
        public void cancel() {
            this.subscription.cancel();
        }
    }
}

