/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableDelaySubscriptionOther<T, U>
extends Flowable<T> {
    final Publisher<? extends T> main;
    final Publisher<U> other;

    public FlowableDelaySubscriptionOther(Publisher<? extends T> main, Publisher<U> other) {
        this.main = main;
        this.other = other;
    }

    @Override
    public void subscribeActual(final Subscriber<? super T> child) {
        final SubscriptionArbiter serial = new SubscriptionArbiter();
        child.onSubscribe(serial);
        Subscriber otherSubscriber = new Subscriber<U>(){
            boolean done;

            @Override
            public void onSubscribe(final Subscription s) {
                serial.setSubscription(new Subscription(){

                    @Override
                    public void request(long n) {
                    }

                    @Override
                    public void cancel() {
                        s.cancel();
                    }
                });
                s.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(U t) {
                this.onComplete();
            }

            @Override
            public void onError(Throwable e) {
                if (this.done) {
                    RxJavaPlugins.onError(e);
                    return;
                }
                this.done = true;
                child.onError(e);
            }

            @Override
            public void onComplete() {
                if (this.done) {
                    return;
                }
                this.done = true;
                FlowableDelaySubscriptionOther.this.main.subscribe(new Subscriber<T>(){

                    @Override
                    public void onSubscribe(Subscription s) {
                        serial.setSubscription(s);
                    }

                    @Override
                    public void onNext(T t) {
                        child.onNext(t);
                    }

                    @Override
                    public void onError(Throwable t) {
                        child.onError(t);
                    }

                    @Override
                    public void onComplete() {
                        child.onComplete();
                    }
                });
            }
        };
        this.other.subscribe(otherSubscriber);
    }
}

