/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.QueueDrainHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subscribers.DisposableSubscriber;
import io.reactivex.subscribers.SerializedSubscriber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableBufferBoundary<T, U extends Collection<? super T>, Open, Close>
extends AbstractFlowableWithUpstream<T, U> {
    final Callable<U> bufferSupplier;
    final Publisher<? extends Open> bufferOpen;
    final Function<? super Open, ? extends Publisher<? extends Close>> bufferClose;

    public FlowableBufferBoundary(Publisher<T> source, Publisher<? extends Open> bufferOpen, Function<? super Open, ? extends Publisher<? extends Close>> bufferClose, Callable<U> bufferSupplier) {
        super(source);
        this.bufferOpen = bufferOpen;
        this.bufferClose = bufferClose;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s) {
        this.source.subscribe(new BufferBoundarySubscriber(new SerializedSubscriber<U>(s), this.bufferOpen, this.bufferClose, this.bufferSupplier));
    }

    static final class BufferCloseSubscriber<T, U extends Collection<? super T>, Open, Close>
    extends DisposableSubscriber<Close> {
        final BufferBoundarySubscriber<T, U, Open, Close> parent;
        final U value;
        boolean done;

        BufferCloseSubscriber(U value, BufferBoundarySubscriber<T, U, Open, Close> parent) {
            this.parent = parent;
            this.value = value;
        }

        @Override
        public void onNext(Close t) {
            this.onComplete();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.parent.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.close(this.value, this);
        }
    }

    static final class BufferOpenSubscriber<T, U extends Collection<? super T>, Open, Close>
    extends DisposableSubscriber<Open> {
        final BufferBoundarySubscriber<T, U, Open, Close> parent;
        boolean done;

        BufferOpenSubscriber(BufferBoundarySubscriber<T, U, Open, Close> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(Open t) {
            if (this.done) {
                return;
            }
            this.parent.open(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.parent.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.openFinished(this);
        }
    }

    static final class BufferBoundarySubscriber<T, U extends Collection<? super T>, Open, Close>
    extends QueueDrainSubscriber<T, U, U>
    implements Subscription,
    Disposable {
        final Publisher<? extends Open> bufferOpen;
        final Function<? super Open, ? extends Publisher<? extends Close>> bufferClose;
        final Callable<U> bufferSupplier;
        final CompositeDisposable resources;
        Subscription s;
        final List<U> buffers;
        final AtomicInteger windows = new AtomicInteger();

        BufferBoundarySubscriber(Subscriber<? super U> actual, Publisher<? extends Open> bufferOpen, Function<? super Open, ? extends Publisher<? extends Close>> bufferClose, Callable<U> bufferSupplier) {
            super(actual, new MpscLinkedQueue());
            this.bufferOpen = bufferOpen;
            this.bufferClose = bufferClose;
            this.bufferSupplier = bufferSupplier;
            this.buffers = new LinkedList<U>();
            this.resources = new CompositeDisposable();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                BufferOpenSubscriber bos = new BufferOpenSubscriber(this);
                this.resources.add(bos);
                this.actual.onSubscribe(this);
                this.windows.lazySet(1);
                this.bufferOpen.subscribe(bos);
                s.request(Long.MAX_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                for (Collection b : this.buffers) {
                    b.add(t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t) {
            this.cancel();
            this.cancelled = true;
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                this.buffers.clear();
            }
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.windows.decrementAndGet() == 0) {
                this.complete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void complete() {
            ArrayList<U> list;
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                list = new ArrayList<U>(this.buffers);
                this.buffers.clear();
            }
            SimplePlainQueue q = this.queue;
            for (Collection u : list) {
                q.offer(u);
            }
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainMaxLoop(q, this.actual, false, this, this);
            }
        }

        @Override
        public void request(long n) {
            this.requested(n);
        }

        @Override
        public void dispose() {
            this.resources.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.resources.isDisposed();
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.dispose();
            }
        }

        @Override
        public boolean accept(Subscriber<? super U> a, U v) {
            a.onNext(v);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open(Open window) {
            Publisher<Close> p;
            Collection b;
            if (this.cancelled) {
                return;
            }
            try {
                b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.onError(e);
                return;
            }
            try {
                p = ObjectHelper.requireNonNull(this.bufferClose.apply(window), "The buffer closing publisher is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.onError(e);
                return;
            }
            if (this.cancelled) {
                return;
            }
            BufferBoundarySubscriber e = this;
            synchronized (e) {
                if (this.cancelled) {
                    return;
                }
                this.buffers.add(b);
            }
            BufferCloseSubscriber bcs = new BufferCloseSubscriber(b, this);
            this.resources.add(bcs);
            this.windows.getAndIncrement();
            p.subscribe(bcs);
        }

        void openFinished(Disposable d) {
            if (this.resources.remove(d) && this.windows.decrementAndGet() == 0) {
                this.complete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(U b, Disposable d) {
            boolean e;
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                e = this.buffers.remove(b);
            }
            if (e) {
                this.fastPathOrderedEmitMax(b, false, this);
            }
            if (this.resources.remove(d) && this.windows.decrementAndGet() == 0) {
                this.complete();
            }
        }
    }
}

