/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class TransactionIdControl
implements Control {
    public static final String OID = "1.3.6.1.4.1.36733.2.1.5.1";
    public static final ControlDecoder<TransactionIdControl> DECODER = new ControlDecoder<TransactionIdControl>(){

        @Override
        public TransactionIdControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Reject.ifNull(control);
            if (control instanceof TransactionIdControl) {
                return (TransactionIdControl)control;
            }
            if (!control.getOid().equals(TransactionIdControl.OID)) {
                throw DecodeException.error(CoreMessages.ERR_TRANSACTION_ID_CONTROL_BAD_OID.get(control.getOid(), TransactionIdControl.OID));
            }
            if (!control.hasValue()) {
                throw DecodeException.error(CoreMessages.ERR_TRANSACTION_ID_CONTROL_DECODE_NULL.get());
            }
            return new TransactionIdControl(control.getValue().toString());
        }

        @Override
        public String getOid() {
            return TransactionIdControl.OID;
        }
    };
    private final String transactionId;

    public static TransactionIdControl newControl(String transactionId) {
        Reject.ifNull(transactionId);
        return new TransactionIdControl(transactionId);
    }

    private TransactionIdControl(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public String getOid() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        return ByteString.valueOfUtf8(this.transactionId);
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TransactionIdControl(oid=");
        builder.append(this.getOid());
        builder.append(", transactionId=");
        builder.append(this.transactionId);
        builder.append(")");
        return builder.toString();
    }
}

